/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;

public class FixedElement
extends ElementCreator {
    private int nameCode;
    protected int[] namespaceCodes = null;
    private ItemType itemType;

    public FixedElement(int nameCode, int[] namespaceCodes, boolean inheritNamespaces, SchemaType schemaType, int validation) {
        this.nameCode = nameCode;
        this.namespaceCodes = namespaceCodes;
        this.inheritNamespaces = inheritNamespaces;
        this.setSchemaType(schemaType);
        this.validation = validation;
        this.preservingTypes = schemaType == null && validation == 3;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Configuration config = visitor.getConfiguration();
        this.setLazyConstruction(config.isLazyConstructionMode());
        this.preservingTypes |= !visitor.getExecutable().isSchemaAware();
        return super.simplify(visitor);
    }

    protected void checkContentSequence(StaticContext env) throws XPathException {
        super.checkContentSequence(env);
        this.itemType = this.computeFixedElementItemType(this, env, this.validation, this.getSchemaType(), this.nameCode, this.content);
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (!this.inheritNamespaces) {
            return this;
        }
        if (this.namespaceCodes == null || this.namespaceCodes.length == 0) {
            return this;
        }
        NamePool pool = visitor.getExecutable().getConfiguration().getNamePool();
        short uriCode = this.getURICode(pool);
        if (this.content instanceof FixedElement) {
            if (((FixedElement)this.content).getURICode(pool) == uriCode) {
                ((FixedElement)this.content).removeRedundantNamespaces(visitor, this.namespaceCodes);
            }
            return this;
        }
        if (this.content instanceof Block) {
            Iterator<Expression> iter = this.content.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression exp = iter.next();
                if (!(exp instanceof FixedElement) || ((FixedElement)exp).getURICode(pool) != uriCode) continue;
                ((FixedElement)exp).removeRedundantNamespaces(visitor, this.namespaceCodes);
            }
        }
        return this;
    }

    private void removeRedundantNamespaces(ExpressionVisitor visitor, int[] parentNamespaces) {
        ItemType contentType;
        boolean ok;
        if (this.namespaceCodes == null || this.namespaceCodes.length == 0) {
            return;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        boolean bl = ok = th.relationship(contentType = this.content.getItemType(th), NodeKindTest.ATTRIBUTE) == 4;
        if (!ok && this.content instanceof Block) {
            ok = true;
            Iterator<Expression> iter = this.content.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression exp = iter.next();
                if (exp instanceof FixedAttribute) {
                    int attNameCode = ((FixedAttribute)exp).getAttributeNameCode();
                    if (!NamePool.isPrefixed(attNameCode)) continue;
                    ok = false;
                    break;
                }
                ItemType childType = exp.getItemType(th);
                if (th.relationship(childType, NodeKindTest.ATTRIBUTE) == 4) continue;
                ok = false;
                break;
            }
        }
        if (ok) {
            int j;
            int removed = 0;
            block1: for (int i = 0; i < this.namespaceCodes.length; ++i) {
                for (j = 0; j < parentNamespaces.length; ++j) {
                    if (this.namespaceCodes[i] != parentNamespaces[j]) continue;
                    this.namespaceCodes[i] = -1;
                    ++removed;
                    continue block1;
                }
            }
            if (removed > 0) {
                if (removed == this.namespaceCodes.length) {
                    this.namespaceCodes = null;
                } else {
                    int[] ns2 = new int[this.namespaceCodes.length - removed];
                    j = 0;
                    for (int i = 0; i < this.namespaceCodes.length; ++i) {
                        if (this.namespaceCodes[i] == -1) continue;
                        ns2[j++] = this.namespaceCodes[i];
                    }
                    this.namespaceCodes = ns2;
                }
            }
        }
    }

    public Expression copy() {
        FixedElement fe = new FixedElement(this.nameCode, this.namespaceCodes, this.inheritNamespaces, this.getSchemaType(), this.validation);
        fe.setContentExpression(this.content.copy());
        fe.setBaseURI(this.getBaseURI());
        return fe;
    }

    public short getURICode(NamePool pool) {
        return pool.getURICode(this.nameCode);
    }

    private ItemType computeFixedElementItemType(FixedElement instr, StaticContext env, int validation, SchemaType schemaType, int nameCode, Expression content) throws XPathException {
        NodeTest itemType;
        Configuration config = env.getConfiguration();
        if (schemaType == null) {
            if (validation == 1) {
                SchemaDeclaration decl = config.getElementDeclaration(nameCode & 0xFFFFF);
                if (decl == null) {
                    XPathException err = new XPathException("There is no global element declaration for " + env.getNamePool().getDisplayName(nameCode) + ", so strict validation will fail");
                    err.setErrorCode(instr.isXSLT() ? "XTTE1512" : "XQDY0027");
                    err.setIsTypeError(true);
                    err.setLocator(instr);
                    throw err;
                }
                if (decl.isAbstract()) {
                    XPathException err = new XPathException("The element declaration for " + env.getNamePool().getDisplayName(nameCode) + " is abstract, so strict validation will fail");
                    err.setErrorCode(instr.isXSLT() ? "XTTE1512" : "XQDY0027");
                    err.setIsTypeError(true);
                    err.setLocator(instr);
                    throw err;
                }
                schemaType = decl.getType();
                instr.setSchemaType(schemaType);
                itemType = new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, schemaType, config));
                try {
                    schemaType.analyzeContentExpression(content, 1, env);
                }
                catch (XPathException e) {
                    e.setErrorCode(instr.isXSLT() ? "XTTE1510" : "XQDY0027");
                    e.setLocator(instr);
                    throw e;
                }
                SchemaType xsiType = instr.getXSIType(env);
                if (xsiType != null) {
                    xsiType.analyzeContentExpression(content, 1, env);
                    try {
                        config.checkTypeDerivationIsOK(xsiType, schemaType, 0);
                    }
                    catch (SchemaException e) {
                        ValidationException ve = new ValidationException("The specified xsi:type " + xsiType.getDescription() + " is not validly derived from the required type " + schemaType.getDescription());
                        ve.setConstraintReference(1, "cvc-elt", "4.3");
                        ve.setErrorCode(instr.isXSLT() ? "XTTE1515" : "XQDY0027");
                        ve.setLocator(instr);
                        throw ve;
                    }
                }
            } else if (validation == 2) {
                SchemaDeclaration decl = config.getElementDeclaration(nameCode & 0xFFFFF);
                if (decl == null) {
                    env.issueWarning("There is no global element declaration for " + env.getNamePool().getDisplayName(nameCode), instr);
                    itemType = new NameTest(1, nameCode, env.getNamePool());
                } else {
                    schemaType = decl.getType();
                    instr.setSchemaType(schemaType);
                    itemType = new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, instr.getSchemaType(), config));
                    try {
                        schemaType.analyzeContentExpression(content, 1, env);
                    }
                    catch (XPathException e) {
                        e.setErrorCode(instr.isXSLT() ? "XTTE1515" : "XQDY0027");
                        e.setLocator(instr);
                        throw e;
                    }
                }
            } else {
                itemType = validation == 3 ? new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, AnyType.getInstance(), config)) : new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, Untyped.getInstance(), config));
            }
        } else {
            itemType = new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, schemaType, config));
            try {
                schemaType.analyzeContentExpression(content, 1, env);
            }
            catch (XPathException e) {
                e.setErrorCode(instr.isXSLT() ? "XTTE1540" : "XQDY0027");
                e.setLocator(instr);
                throw e;
            }
        }
        return itemType;
    }

    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType == null) {
            return super.getItemType(th);
        }
        return this.itemType;
    }

    public int getNameCode(XPathContext context, NodeInfo copiedNode) {
        return this.nameCode;
    }

    public String getNewBaseURI(XPathContext context, NodeInfo copiedNode) {
        return this.getBaseURI();
    }

    private SchemaType getXSIType(StaticContext env) throws XPathException {
        if (this.content instanceof FixedAttribute) {
            return this.testForXSIType((FixedAttribute)this.content, env);
        }
        if (this.content instanceof Block) {
            Iterator<Expression> iter = this.content.iterateSubExpressions();
            while (iter.hasNext()) {
                SchemaType type;
                Expression exp = iter.next();
                if (!(exp instanceof FixedAttribute) || (type = this.testForXSIType((FixedAttribute)exp, env)) == null) continue;
                return type;
            }
            return null;
        }
        return null;
    }

    private SchemaType testForXSIType(FixedAttribute fat, StaticContext env) throws XPathException {
        Expression attValue;
        int att = fat.getAttributeNameCode() & 0xFFFFF;
        if (att == 641 && (attValue = fat.getContentExpression()) instanceof StringLiteral) {
            try {
                NamePool pool = env.getNamePool();
                String[] parts = env.getConfiguration().getNameChecker().getQNameParts(((StringLiteral)attValue).getStringValue());
                int uriCode = -1;
                for (int n = 0; n < this.namespaceCodes.length; ++n) {
                    String prefix = pool.getPrefixFromNamespaceCode(this.namespaceCodes[n]);
                    if (!prefix.equals(parts[0])) continue;
                    uriCode = this.namespaceCodes[n] & 0xFFFF;
                    break;
                }
                if (uriCode == -1) {
                    return null;
                }
                String uri = pool.getURIFromURICode((short)uriCode);
                int typefp = pool.allocate(parts[0], uri, parts[1]) & 0xFFFFF;
                return env.getConfiguration().getSchemaType(typefp);
            }
            catch (QNameException e) {
                throw new XPathException(e.getMessage());
            }
        }
        return null;
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        SchemaType type;
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Element " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element is of simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (((ComplexType)parentType).isSimpleContent()) {
            XPathException err = new XPathException("Element " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element has a complex type with simple content");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (whole) {
            Block block = new Block();
            block.setChildren(new Expression[]{this});
            parentType.analyzeContentExpression(block, 1, env);
        }
        try {
            type = ((ComplexType)parentType).getElementParticleType(this.nameCode & 0xFFFFF, true);
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
        if (type == null) {
            XPathException err = new XPathException("Element " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            err.setErrorCode(this.isXSLT() ? "XTTE1510" : "XQDY0027");
            throw err;
        }
        if (type instanceof AnyType) {
            return;
        }
        try {
            this.content.checkPermittedContents(type, env, true);
        }
        catch (XPathException e) {
            if (e.getLocator() == null || e.getLocator() == e) {
                e.setLocator(this);
            }
            throw e;
        }
    }

    protected void outputNamespaceNodes(XPathContext context, Receiver out, int nameCode, NodeInfo copiedNode) throws XPathException {
        if (this.namespaceCodes != null) {
            for (int i = 0; i < this.namespaceCodes.length; ++i) {
                out.namespace(this.namespaceCodes[i], 0);
            }
        }
    }

    public int[] getActiveNamespaces() {
        return this.namespaceCodes;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("directElement");
        out.emitAttribute("name", out.getNamePool().getClarkName(this.nameCode));
        out.emitAttribute("validation", Validation.toString(this.validation));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        this.content.explain(out);
        out.endElement();
    }
}

