/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.NumericPromoter;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class PromoteToFloat
extends NumericPromoter {
    public PromoteToFloat(Expression exp) {
        super(exp);
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.FLOAT;
    }

    public Expression copy() {
        return new PromoteToFloat(this.getBaseExpression().copy());
    }

    protected AtomicValue promote(AtomicValue value, ConversionRules rules) throws XPathException {
        if (!(value instanceof NumericValue) && !(value instanceof UntypedAtomicValue)) {
            XPathException err = new XPathException("Cannot promote non-numeric value to xs:float", "XPTY0004");
            err.setLocator(this);
            throw err;
        }
        if (value instanceof DoubleValue) {
            XPathException err = new XPathException("Cannot promote from xs:double to xs:float", "XPTY0004");
            err.setLocator(this);
            throw err;
        }
        return value.convert(BuiltInAtomicType.FLOAT, true, rules).asAtomic();
    }
}

