/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.readers;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLCatalogReader {
    public Element readCatalog(Source source) {
        Element root;
        block9: {
            root = null;
            try {
                if (source instanceof SAXSource) {
                    root = this.readCatalogSAX((SAXSource)source);
                    break block9;
                }
                if (source instanceof DOMSource) {
                    root = this.readCatalogDOM((DOMSource)source);
                    break block9;
                }
                if (source instanceof StAXSource) {
                    root = this.readCatalogStAX((StAXSource)source);
                    break block9;
                }
                if (source instanceof StreamSource) {
                    root = this.readCatalogStream((StreamSource)source);
                    break block9;
                }
                return null;
            }
            catch (ParserConfigurationException pce) {
                return null;
            }
            catch (SAXException se) {
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        System.out.println("Name: {" + root.getNamespaceURI() + "}" + root.getNodeName());
        if ("catalog".equals(root.getNodeName()) && "urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(root.getNamespaceURI())) {
            return root;
        }
        return null;
    }

    private Element readCatalogSAX(SAXSource source) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = null;
        if (source.getInputSource() != null) {
            doc = builder.parse(source.getInputSource());
        }
        if (source.getXMLReader() == null) {
            throw new UnsupportedOperationException("Unexpected XMLReader on SAXSource");
        }
        if (source.getSystemId() != null) {
            doc = builder.parse(source.getSystemId());
        }
        return doc == null ? null : doc.getDocumentElement();
    }

    private Element readCatalogDOM(DOMSource source) {
        Node node = source.getNode();
        if (node.getNodeType() == 9) {
            return ((Document)node).getDocumentElement();
        }
        if (node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    private Element readCatalogStAX(StAXSource source) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = null;
        if (source.getXMLEventReader() != null) {
            throw new UnsupportedOperationException("Unexpected XMLEventReader on StAXSource");
        }
        if (source.getXMLStreamReader() == null) {
            throw new UnsupportedOperationException("Unexpected XMLStreamReader on StAXSource");
        }
        if (source.getSystemId() != null) {
            doc = builder.parse(source.getSystemId());
        }
        return doc == null ? null : doc.getDocumentElement();
    }

    private Element readCatalogStream(StreamSource source) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = null;
        if (source.getInputStream() != null) {
            doc = builder.parse(source.getInputStream());
        } else {
            if (source.getReader() != null) {
                throw new UnsupportedOperationException("Unexpected Reader on StreamSource");
            }
            if (source.getSystemId() != null) {
                doc = builder.parse(source.getSystemId());
            }
        }
        return doc == null ? null : doc.getDocumentElement();
    }
}

