#ifndef MANAGER_H
#define MANAGER_H

#include <Foundation/NSObject.h>

#define TEXT_EDITOR	@"xterm -e vi"
#define LAUNCH_CMD	@"xterm -e"
#define DEBUG_CMD	@"xterm -e gdb"
#define MAKE_CMD	@"make 2>&1"
#define MAKEFILE_GEN	@"mfg"

@class GTKList, GTKListItem;
@class GTKOptionMenu;
@class GTKAction;
@class NSMutableDictionary;
@class NSArray, NSSring;

@interface Manager : NSObject
{
    GTKList *list1;
    GTKList *list2;
    GTKOptionMenu *target;

    NSMutableDictionary *files;
    NSArray *groups;
    NSString *program;
    NSString *path;
    NSString *filename;
}

- (void) info:sender;
- (void) select:sender;
- (void) selectFile:sender;
- (void) add:sender;
- (void) addFile:(GTKListItem *) group;
- (void) ok:sender data:(BOOL *) ok;
- (void) cancel:sender data:(BOOL *) ok;
- (void) remove:sender;
- (void) open:sender;
- (void) launch:sender;
- (void) debug:sender;
- (void) attrib:sender;
- (void) build:sender;
- (void) loadFromFile:(NSString *) filename;
- (void) save:sender;
- (void) saveToFile:(NSString *) filename;
@end

#endif
