#ifndef GTOOLKIT_GTKTREE_H
#define GTOOLKIT_GTKTREE_H

#include <GToolKit/GTKContainer.h>
#include <gtk/gtktree.h>

@interface GTKTree : GTKContainer
+ (guint) getType;
+ tree;
- init;
- (void) append:(GTKWidget *) tree_item;
- (void) prepend:(GTKWidget *) tree_item;
- (void) insert:(GTKWidget *) tree_item position:(gint) position;
- (void) removeItems:(NSArray *) items;
- (void) clearItems:(gint) start end:(gint) end;
- (void) selectItem:(gint) item;
- (void) unselectItem:(gint) item;
- (void) selectChild:(GTKWidget *) tree_item;
- (void) unselectChild:(GTKWidget *) tree_item;
- (gint) childPosition:(GTKWidget *) child;
- (void) setSelectionMode:(GtkSelectionMode) mode;
- (void) setViewMode:(GtkTreeViewMode) mode;
- (void) setViewLines:(guint) flag;
- (void) removeItem:(GTKWidget *) child;
@end

#endif
