#include <stdio.h>

#include "Calc.h"
#include <GToolKit/GToolKit.h>

@interface Calc(Private)
- cpu;                  // wenn mglich: value[0] op= value[1]
@end

@implementation Calc(Private)
- cpu
{
	if (state)
		switch (op) {
		case '+':
			value[0] += value[1];
			break;
		case '-':
			value[0] -= value[1];
			break;
		case '*':
			value[0] *= value[1];
			break;
		case '/':
			if (value[1])
				value[0] /= value[1];
			else
				value[0] |= ~0U >> 1;
		}
	return self;
}
@end



#include <ctype.h>

@implementation Calc

- (void) setTarget:_target
{
    target = _target;
}

- (void) gate: sender
{       char key;

	if (! [sender isKindOfClass: [GTKButton class]]) return;
	key = [sender tag];

	switch (key) {
	case 'Q':
	case '\0':                              // Schlu
		exit(0);
	default:
		if (isdigit(key))               // Ziffern sammeln
		{       value[state] *= 10;
			value[state] += key - '0';
			[target setIntValue:value[state]];
		}
		break;                          // Rest ignorieren
	case '+':                               // addieren
	case '-':                               // subtrahieren
	case '*':                               // multiplizieren
	case '/':                               // dividieren
		[self cpu];                     // letzten Operator verwenden
		if (state)                      // ...und Wert ausgeben
			[target setIntValue:value[0]];
		else
			state = 1;              // so oder so, im Zustand 1...
		value[1] = 0;                   // neuen Wert berechnen...
		op = key;                       // und Operator notieren
		break;
	case 'C':                               // lschen
		value[state] = 0;
		[target setIntValue:value[state]];
		break;
	case '=':                               // Summe
		[self cpu];                     // letzten Operator verwenden
		[target setIntValue:value[0]];
		state = 0;
		value[0] = 0;        // neu anfangen
	}
}
@end
