/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998  Elmar Ludwig - Universitaet Osnabrueck
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTK_H
#define GTOOLKIT_GTK_H

#include <glib.h>
#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>

@class NSArray, NSMutableArray, NSNotification;
@class GTKApplication, GTKAction;

@class GTKAcceleratorTable;
@class GTKAdjustment;
@class GTKAlignment;
@class GTKArrow;
@class GTKAspectFrame;
@class GTKBin;
@class GTKBox;
@class GTKButton;
@class GTKButtonBox;
@class GTKCList;
@class GTKCheckButton;
@class GTKCheckMenuItem;
@class GTKColorSelection;
@class GTKColorSelectionDialog;
@class GTKCombo;
@class GTKContainer;
@class GTKCurve;
@class GTKData;
@class GTKDialog;
@class GTKDrawingArea;
@class GTKEditable;
@class GTKEntry;
@class GTKEventBox;
@class GTKFileSelection;
@class GTKFixed;
@class GTKFrame;
@class GTKGammaCurve;
@class GTKHBox;
@class GTKHButtonBox;
@class GTKHPaned;
@class GTKHRuler;
@class GTKHScale;
@class GTKHScrollbar;
@class GTKHSeparator;
@class GTKHandleBox;
@class GTKImage;
@class GTKInputDialog;
@class GTKItem;
@class GTKLabel;
@class GTKList;
@class GTKListItem;
@class GTKMenu;
@class GTKMenuBar;
@class GTKMenuFactory;
@class GTKMenuItem;
@class GTKMenuShell;
@class GTKMisc;
@class GTKNotebook;
@class GTKObject;
@class GTKOptionMenu;
@class GTKPaned;
@class GTKPixmap;
@class GTKPreview;
@class GTKProgressBar;
@class GTKRadioButton;
@class GTKRadioMenuItem;
@class GTKRange;
@class GTKRuler;
@class GTKScale;
@class GTKScrollbar;
@class GTKScrolledWindow;
@class GTKSeparator;
@class GTKSpinButton;
@class GTKStatusbar;
@class GTKStyle;
@class GTKTable;
@class GTKText;
@class GTKTipsQuery;
@class GTKToggleButton;
@class GTKToolbar;
@class GTKTooltips;
@class GTKTree;
@class GTKTreeItem;
@class GTKVBox;
@class GTKVButtonBox;
@class GTKVPaned;
@class GTKVRuler;
@class GTKVScale;
@class GTKVScrollbar;
@class GTKVSeparator;
@class GTKViewport;
@class GTKWidget;
@class GTKWindow;

#define String_to_NSString(s)	[NSString stringWithCString:s]
#define NSString_to_String(s)	(char *) [(NSString *)(s) cString]

extern NSArray *GList_to_NSArray (GList *list);
extern GList *NSArray_to_GList (NSArray *array);
extern const char **NSArray_to_StrVec (NSArray *array);

#define GSList_to_NSArray(l)	(NSArray *) (l)
#define NSArray_to_GSList(a)	(GSList *) (a)

/* Find Objective-C object for given gtk-object pointer */
#define GTK_GET_OBJECT(gtk)	Gtk_to_Object(gtk,0)
extern id Gtk_to_Object (gpointer gtk, const char *class);

/*
 * GTK is the base class of all classes in the Objective-C interface to
 * the GIMP Toolkit. It provides access to the internal gtk-object and
 * methods to connect signals to actions, which represent object/selector
 * combinations.<p>
 * All objects may be assigned a /tag/ (a user defined integer value) to
 * allow for easy identification.<p>
 * Note!!: The methods below that control signal connections and actions are
 * valid only for instances of the @GTKObject class and its subclasses.
 */
@interface GTK : NSObject
{
    gpointer gtk;		// internal gtk-object pointer
    gint32 tag;			// assigned tag
    NSMutableArray *actions;	// array of connected actions
}

/* internal methods */
+ (void) taskNowMultiThreaded:(NSNotification *) event;
- initWithGtk:(gpointer) gtk;

/* commonly used methods */
- (gpointer) gtk;
- (void) setTag:(gint32) tag;
- (gint32) tag;

/* signal handling */
+ (void) addUserSignal:(NSString *) signal;
- (void) emit:sender signal:(NSString *) signal;
- (void) stop:sender signal:(NSString *) signal;
- (void) connectSignal:(NSString *) signal withAction:(GTKAction *) action;
- (void) connectSignal:(NSString *) signal withTarget:target sel:(SEL) sel;
- (void) connectSignal:(NSString *) signal withTarget:target sel:(SEL) sel
	 data:(const void *) data;
- (void) connectSignal:(NSString *) signal withActionAfter:(GTKAction *) action;
- (void) disconnectAction:(GTKAction *) action;
- (void) blockAction:(GTKAction *) action;
- (void) unblockAction:(GTKAction *) action;
@end

#endif
