/*
 * GToolKit - Objective-C interface to the GIMP Toolkit
 * Copyright (c) 1998, 1999, 2000  Elmar Ludwig
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GTOOLKIT_GTK_H
#define GTOOLKIT_GTK_H

#define GTK_DISABLE_COMPAT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <gtk/gtkenums.h>
#include <glib.h>

#define GTOOLKIT_MAJOR_VERSION	0
#define GTOOLKIT_MINOR_VERSION	9
#define GTOOLKIT_MICRO_VERSION	4

@class NSArray, NSMutableArray, NSNotification;
@class GTKAction;

extern BOOL gtoolkit_debug;	// enable limited debug output

/* The following six functions are for internal use only */
extern const char *gtoolkit_utf8_string (NSString *string);
extern NSString *gtoolkit_objc_string (const char *string);

extern GList *gtoolkit_array_to_list (NSArray *array);
extern NSArray *gtoolkit_list_to_array (GList *glist);

extern const char **gtoolkit_array_to_strvec (NSArray *array);
extern NSArray *gtoolkit_strvec_to_array (const char **vector);

/* Backwards compatibility macros (do not use) */
#define NSString_to_String(s)	gtoolkit_utf8_string(s)
#define String_to_NSString(s)	gtoolkit_objc_string(s)
#define NSArray_to_GList(a)	gtoolkit_array_to_list(a)
#define GList_to_NSArray(g)	gtoolkit_list_to_array(g)
#define NSArray_to_StrVec(a)	gtoolkit_array_to_strvec(a)
#define StrVec_to_NSArray(v)	gtoolkit_strvec_to_array(v)

#ifdef HAVE_SEL_GETNAME		/* unused */
#define sel_get_name(sel)	sel_getName(sel)
#endif

/* Find Objective-C object for given gtk-object pointer */
extern id gtoolkit_object (gpointer gtk, const char *class);
#define GTOOLKIT_OBJECT(gtk)	gtoolkit_object(gtk, 0)

/* Do not use, these are now deprecated */
#define Gtk_to_Object(gtk, cls)	gtoolkit_object(gtk, cls)
#define GTK_GET_OBJECT(gtk)	GTOOLKIT_OBJECT(gtk)

/*
 * GTK is the base class of almost all classes in the Objective-C interface
 * to the GIMP Toolkit. It provides access to the internal gtk-object and
 * methods to connect signals to actions, which represent object/selector
 * combinations. Because these "wrapper" objects do not carry (or cache)
 * state information about their corresponding GTK+ objects, you can freely
 * intermix ordinary GTK+ function calls (to the internal gtk-object pointer)
 * with Objective-C method calls to the same object.<p>
 * All objects may be assigned a tag (a user defined integer value) to allow
 * for easy identification. The initial tag value is |0|.<p>
 * Note:!! The methods below that control signal connections and actions are
 * valid only for instances of the @GTKObject class and its subclasses.
 */
@interface GTK : NSObject
{
@public
    const gpointer gtk;		// internal gtk-object pointer (read only)
@protected
    gint32 tag;			// assigned tag value (user data)
    NSMutableArray *actions;	// array of connected actions
}

/* internal methods */
+ (void) taskNowMultiThreaded:(NSNotification *) event;
- (id) initWithGtk:(gpointer) gtk;

/* commonly used methods */
- (gpointer) gtk;
- (void) setTag:(gint32) tag;
- (gint32) tag;

/* signal handling for GTKObject */
+ (void) addUserSignal:(NSString *) signal flags:(GtkSignalRunType) flags;
- (void) emit:(id) sender signal:(NSString *) signal;
- (void) stop:(id) sender signal:(NSString *) signal;
- (void) connectSignal:(NSString *) signal withAction:(GTKAction *) action;
- (void) connectSignal:(NSString *) signal withTarget:(id) target sel:(SEL) sel;
- (void) connectSignal:(NSString *) signal withTarget:(id) target sel:(SEL) sel
	 data:(const void *) data;
- (void) connectSignal:(NSString *) signal withActionAfter:(GTKAction *) action;
- (void) disconnectAction:(GTKAction *) action;
- (void) blockAction:(GTKAction *) action;
- (void) unblockAction:(GTKAction *) action;
@end

#endif /* GTOOLKIT_GTK_H */
