Taler Merchant Backend pages

# Description

This project generates templates for the Taler Merchant backend:

- OfferRefund
- RequestPayment
- ShowOrderDetails

These pages are provided by the merchant-backend service and will be queried for browsers 
that either may or may not have enabled JavaScript.
The merchant-backend service is currently supporting a mustache library for server-side rendering.
We also want the be able to create a more interactive design given the case that browsers have JavaScript enabled, 
so the pages will be rendered with all information in HTML format as well as with JavaScript.
In this scenario, we are using jsx to build the template of the page that will be rendered into the mustache template at build time. 
This template can then be deployed in a merchant-backend that will complete the information before it is sent to the browser.

# Building

The building process can be executed with `pnpm build`

# Testing

This project is using a JavaScript implementation of mustache that can be executed with the command `pnpm render-examples`.
The script will take the pages previously built in the `dist/pages` directory and the examples definition 
in the `src/pages/[exampleName].examples.ts` files and renders a page to be sent to the user like the Taler Merchant Backend would do.
This example will be saved individually into the directory `dist/examples` and can be opened in your test browser.
Testing should be done with JavaScript enabled and disabled, in both cases the result should look OK.
