/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class SimplePrimitiveId
implements PrimitiveId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final OsmPrimitiveType type;
    public static final Pattern ID_PATTERN = Pattern.compile("(n|node|w|way|r|rel|relation)[ /]?(\\d+)");
    public static final Pattern MULTIPLE_IDS_PATTERN = Pattern.compile(ID_PATTERN.pattern() + "(-(\\d+))?");

    public SimplePrimitiveId(long id, OsmPrimitiveType type) {
        this.id = id;
        this.type = type;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.type;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public int hashCode() {
        return Long.hashCode(this.id) + 31 * Objects.hashCode((Object)this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimplePrimitiveId that = (SimplePrimitiveId)obj;
        return this.id == that.id && this.type == that.type;
    }

    public String toString() {
        return this.type.toString() + " " + this.id;
    }

    public static SimplePrimitiveId fromString(String s) {
        Matcher m = ID_PATTERN.matcher(s);
        if (m.matches()) {
            return new SimplePrimitiveId(Long.parseLong(m.group(m.groupCount())), SimplePrimitiveId.getOsmPrimitiveType(s.charAt(0)));
        }
        throw new IllegalArgumentException("The string " + s + " does not match the pattern " + String.valueOf(ID_PATTERN));
    }

    public static List<SimplePrimitiveId> multipleFromString(String s) {
        Matcher m = MULTIPLE_IDS_PATTERN.matcher(s);
        if (m.matches()) {
            return SimplePrimitiveId.extractIdsInto(m, new ArrayList<SimplePrimitiveId>());
        }
        throw new IllegalArgumentException("The string " + s + " does not match the pattern " + String.valueOf(MULTIPLE_IDS_PATTERN));
    }

    public static List<SimplePrimitiveId> fuzzyParse(String s) {
        ArrayList<SimplePrimitiveId> ids = new ArrayList<SimplePrimitiveId>();
        Matcher m = MULTIPLE_IDS_PATTERN.matcher(s);
        while (m.find()) {
            SimplePrimitiveId.extractIdsInto(m, ids);
        }
        return ids;
    }

    private static List<SimplePrimitiveId> extractIdsInto(MatchResult m, List<SimplePrimitiveId> ids) {
        OsmPrimitiveType type = SimplePrimitiveId.getOsmPrimitiveType(m.group(1).charAt(0));
        String firstId = m.group(2);
        String lastId = m.group(4);
        if (lastId != null) {
            long lastIdParsed = lastId.length() < firstId.length() ? Long.parseLong(firstId.substring(0, firstId.length() - lastId.length()) + lastId) : Long.parseLong(lastId);
            for (long i = Long.parseLong(firstId); i <= lastIdParsed; ++i) {
                if (i <= 0L) continue;
                ids.add(new SimplePrimitiveId(i, type));
            }
        } else {
            long i = Long.parseLong(firstId);
            if (i > 0L) {
                ids.add(new SimplePrimitiveId(i, type));
            }
        }
        return ids;
    }

    private static OsmPrimitiveType getOsmPrimitiveType(char firstChar) {
        return firstChar == 'n' ? OsmPrimitiveType.NODE : (firstChar == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION);
    }

    public static String toSimpleId(PrimitiveId primitive) {
        switch (primitive.getType()) {
            case NODE: {
                return "n" + primitive.getUniqueId();
            }
            case CLOSEDWAY: 
            case WAY: {
                return "w" + primitive.getUniqueId();
            }
            case MULTIPOLYGON: 
            case RELATION: {
                return "r" + primitive.getUniqueId();
            }
        }
        throw new IllegalArgumentException("Unknown primitive type: " + String.valueOf((Object)primitive.getType()));
    }
}

