/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowser;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;

public class HistoryBrowserDialog
extends JDialog
implements HistoryDataSetListener {
    private final HistoryBrowser browser = new HistoryBrowser();
    private final CloseAction closeAction = new CloseAction();
    private final JLabel titleLabel = new JLabel("", 0);

    public HistoryBrowserDialog(History history) {
        super(GuiHelper.getFrameForComponent(MainApplication.getMainFrame()), false);
        this.build();
        this.setHistory(history);
        this.setTitle(HistoryBrowserDialog.buildTitle(history));
        this.pack();
        if (this.getInsets().top > 0) {
            this.titleLabel.setVisible(false);
        }
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        this.addWindowListener(new WindowClosingAdapter());
    }

    static String buildTitle(History h) {
        String title;
        switch (h.getEarliest().getType()) {
            case NODE: {
                title = I18n.marktr("History for node {0}");
                break;
            }
            case WAY: {
                title = I18n.marktr("History for way {0}");
                break;
            }
            case RELATION: {
                title = I18n.marktr("History for relation {0}");
                break;
            }
            default: {
                title = "";
            }
        }
        return I18n.tr(title, Long.toString(h.getId()));
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        if (this.titleLabel != null) {
            this.titleLabel.setText(title);
        }
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.browser, "Center");
        JPanel pnl = new JPanel(new FlowLayout(1));
        JButton btn = new JButton(new ReloadAction());
        btn.setName("btn.reload");
        pnl.add(btn);
        btn = new JButton(this.closeAction);
        btn.setName("btn.close");
        pnl.add(btn);
        InputMapUtils.addEscapeAction(this.getRootPane(), this.closeAction);
        btn = new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/ObjectHistory")));
        btn.setName("btn.help");
        pnl.add(btn);
        this.add((Component)pnl, "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/ObjectHistory"));
    }

    protected void setHistory(History history) {
        this.browser.populate(history);
    }

    @Override
    public void historyUpdated(HistoryDataSet source, PrimitiveId primitiveId) {
        History history;
        if ((primitiveId == null || primitiveId.equals(this.browser.getHistory().getPrimitiveId())) && (history = source.getHistory(this.browser.getHistory().getPrimitiveId())) != null) {
            this.browser.populate(history);
        }
    }

    @Override
    public void historyDataSetCleared(HistoryDataSet source) {
        if (this.isVisible()) {
            this.closeAction.run();
        }
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.browser;
    }

    @Override
    public void dispose() {
        HistoryDataSet.getInstance().removeHistoryDataSetListener(this);
        GuiHelper.destroyComponents(this, false);
        super.dispose();
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
        }

        void run() {
            HistoryBrowserDialogManager.getInstance().hide(HistoryBrowserDialog.this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (HistoryBrowserDialog.this.isVisible()) {
                HistoryBrowserDialog.this.closeAction.run();
            }
        }
    }

    class ReloadAction
    extends AbstractAction {
        ReloadAction() {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reload the history from the server", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryLoadTask task = new HistoryLoadTask();
            task.add(HistoryBrowserDialog.this.browser.getHistory());
            MainApplication.worker.submit(task);
        }
    }
}

