/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.scripting.xmltags.OgnlCache;

public class ExpressionEvaluator {
    public boolean evaluateBoolean(String expression, Object parameterObject) {
        Object value = OgnlCache.getValue(expression, parameterObject);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return new BigDecimal(String.valueOf(value)).compareTo(BigDecimal.ZERO) != 0;
        }
        return value != null;
    }

    @Deprecated
    public Iterable<?> evaluateIterable(String expression, Object parameterObject) {
        return this.evaluateIterable(expression, parameterObject, false);
    }

    public Iterable<?> evaluateIterable(String expression, Object parameterObject, boolean nullable) {
        Object value = OgnlCache.getValue(expression, parameterObject);
        if (value == null) {
            if (nullable) {
                return null;
            }
            throw new BuilderException("The expression '" + expression + "' evaluated to a null value.");
        }
        if (value instanceof Iterable) {
            return (Iterable)value;
        }
        if (value.getClass().isArray()) {
            int size = Array.getLength(value);
            ArrayList<Object> answer = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(value, i);
                answer.add(o);
            }
            return answer;
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet();
        }
        throw new BuilderException("Error evaluating expression '" + expression + "'.  Return value (" + value + ") was not iterable.");
    }
}

