% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesnecfit-class.R
\docType{class}
\name{bayesnecfit-class}
\alias{bayesnecfit-class}
\alias{bayesnecfit}
\title{Class \code{bayesnecfit} of models fitted with the \pkg{brms} package}
\description{
Models fitted with the \code{\link[bayesnec:bayesnec-package]{bayesnec}}
package are represented as a \code{bayesnecfit} object, which contain the
original \code{\link[brms]{brmsfit}} fitted object, list of initialisation
values used, the validated \code{\link{bayesnecformula}}, name of non-linear
model that was fitted, posterior predictions, posterior parameter estimates
and a series of other statistics.
}
\details{
See \code{methods(class = "bayesnecfit")} for an overview of
available methods.
}
\section{Slots}{

\describe{
\item{\code{fit}}{The fitted Bayesian model of class \code{\link[brms]{brmsfit}}.}

\item{\code{model}}{A \code{\link[base]{character}} string indicating the name of
the fitted model.}

\item{\code{init}}{A \code{\link[base]{list}} containing the initialisation values
for to fit the model.}

\item{\code{bayesnecformula}}{An object of class \code{\link{bayesnecformula}} and
\code{\link[stats]{formula}}.}

\item{\code{pred_vals}}{A \code{\link[base]{list}} containing a
\code{\link[base]{data.frame}} of summary posterior predicted values
and a vector containing based on the supplied \code{precision} and
\code{x_range}.}

\item{\code{top}}{The estimate for parameter "top" in the fitted model.}

\item{\code{beta}}{The estimate for parameter "beta" in the fitted model.}

\item{\code{nec}}{The estimated NEC.}

\item{\code{f}}{The estimate for parameter "f" in the fitted model, NA if
absent for the fitted model type.}

\item{\code{bot}}{The estimate for parameter "bot" in the fitted model, NA if
absent for the fitted model type.}

\item{\code{d}}{The estimate for parameter "d" in the fitted model, NA if absent
for the fitted model type.}

\item{\code{slope}}{The estimate for parameter "slope" in the fitted model, NA if
absent for the fitted model type.}

\item{\code{ec50}}{The estimate for parameter "ec50" in the fitted model, NA if
absent for the fitted model type.}

\item{\code{dispersion}}{An estimate of dispersion.}

\item{\code{predicted_y}}{The predicted values for the observed data.}

\item{\code{residuals}}{Residual values of the observed data from the fitted model.}

\item{\code{nec_posterior}}{A full posterior estimate of the NEC.}
}}

\seealso{
\code{\link{bayesnec}},
\code{\link{bnec}},
\code{\link{bayesmanecfit}},
\code{\link{bayesnecformula}}
}
