% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.bayesnecfit}
\alias{predict.bayesmanecfit}
\title{Generates mean posterior predictions for objects fitted by
\code{\link{bnec}}}
\usage{
\method{predict}{bayesnecfit}(object, ...)

\method{predict}{bayesmanecfit}(object, summary = TRUE, robust = FALSE, probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Additional arguments to \code{\link[brms]{predict.brmsfit}} if
object is of class \code{\link{bayesnecfit}}, or to
\code{\link[brms]{posterior_predict.brmsfit}} if object is of class
\code{\link{bayesmanecfit}}.}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as
the measure of central tendency and the standard deviation as
the measure of variability. If \code{TRUE}, the median and the
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}
}
\value{
See \code{?brms::predict.brmsfit}.
}
\description{
Generates mean posterior predictions for objects fitted by
\code{\link{bnec}}. \code{object} should be of class
\code{\link{bayesnecfit}} or \code{\link{bayesmanecfit}}.
}
\examples{
\dontrun{
library(bayesnec)
# Uses default `precision` and `x_range` to generate `newdata` internally
predict(manec_example)
# Provide user-specified `newdata`
nd_ <- data.frame(x = seq(0, 3, length.out = 200))
predict(manec_example, ecx_val = 50, newdata = nd_, make_newdata = FALSE)
# Predictions for raw input data
nec4param <- pull_out(manec_example, model = "nec4param")
preds <- predict(nec4param, make_newdata = FALSE)
x <- pull_brmsfit(nec4param)$data$x
plot(x, preds[, 1])
}
}
