% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigstatsr-package.R
\docType{package}
\name{bigstatsr-package}
\alias{bigstatsr}
\alias{bigstatsr-package}
\title{bigstatsr: Statistical Tools for Filebacked Big Matrices}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{X.code}{An object of class \link[=FBM.code256-class]{FBM.code256}.}

\item{y.train}{Vector of responses, corresponding to \code{ind.train}.}

\item{y01.train}{Vector of responses, corresponding to \code{ind.train}.
\strong{Must be only 0s and 1s.}}

\item{ind.train}{An optional vector of the row indices that are used,
for the training part. If not specified, all rows are used.
\strong{Don't use negative indices.}}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{fun.scaling}{A function with parameters \code{X}, \code{ind.row} and \code{ind.col},
and that returns a data.frame with \verb{$center} and \verb{$scale} for the columns
corresponding to \code{ind.col}, to scale each of their elements such as followed:
\deqn{\frac{X_{i,j} - center_j}{scale_j}.} Default doesn't use any scaling.
You can also provide your own \code{center} and \code{scale} by using \code{\link[=as_scaling_fun]{as_scaling_fun()}}.}

\item{covar.train}{Matrix of covariables to be added in each model to correct
for confounders (e.g. the scores of PCA), corresponding to \code{ind.train}.
Default is \code{NULL} and corresponds to only adding an intercept to each model.
You can use \code{\link[=covar_from_df]{covar_from_df()}} to convert from a data frame.}

\item{covar.row}{Matrix of covariables to be added in each model to correct
for confounders (e.g. the scores of PCA), corresponding to \code{ind.row}.
Default is \code{NULL} and corresponds to only adding an intercept to each model.
You can use \code{\link[=covar_from_df]{covar_from_df()}} to convert from a data frame.}

\item{center}{Vector of same length of \code{ind.col} to subtract from columns of \code{X}.}

\item{scale}{Vector of same length of \code{ind.col} to divide from columns of \code{X}.}
}
\description{
Easy-to-use, efficient, flexible and scalable statistical tools. Package bigstatsr provides and uses Filebacked Big Matrices via memory-mapping. It provides for instance matrix operations, Principal Component Analysis, sparse linear supervised models, utility functions and more <doi:10.1093/bioinformatics/bty185>.
}
\section{Matrix parallelization}{

Large matrix computations are made block-wise and won't be parallelized
in order to not have to reduce the size of these blocks.
Instead, you may use \href{https://mran.microsoft.com/open/}{Microsoft R Open}
or OpenBLAS in order to accelerate these block matrix computations.
You can also control the number of cores used with
\code{bigparallelr::set_blas_ncores()}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://privefl.github.io/bigstatsr/}
  \item Report bugs at \url{https://github.com/privefl/bigstatsr/issues}
}

}
\author{
\strong{Maintainer}: Florian Privé \email{florian.prive.21@gmail.com}

Other contributors:
\itemize{
  \item Michael Blum [thesis advisor]
  \item Hugues Aschard \email{hugues.aschard@pasteur.fr} [thesis advisor]
}

}
\keyword{internal}
