# Precompile vignettes that run Stan models, and write out tests

precompile <- function(vignette,
                       skip_on_cran = TRUE,
                       skip_on_ci = FALSE,
                       skip_on_travis = skip_on_ci,
                       build_vignette = TRUE, write_tests = TRUE) {
  root <- rprojroot::is_r_package

  rmd_in <- root$find_file("vignettes", vignette)

  if (build_vignette) {

    # .Rmd.orig files are compiled to static .Rmd first
    if (tools::file_ext(rmd_in) == "orig") {
      rmd_built <- tools::file_path_sans_ext(rmd_in)
      knitr::knit(rmd_in, output = rmd_built)
      rmd_in <- rmd_built
      write_tests <- FALSE
    }

    rmarkdown::render(rmd_in)
  }

  if (write_tests) {
    r_out <- root$find_file("tests", "testthat",
                            paste0("test-", gsub("\\.Rmd$", "", vignette, ignore.case = TRUE), ".R"))

    test_env <- new.env()
    test_env$params <- list(run_tests = TRUE)

    knitr::purl(rmd_in, output = r_out, envir = test_env)

    writeLines(c(
        paste0("# Generated by vignette ", vignette, ": do not edit by hand"),
        paste0("# Instead edit ", vignette, " and then run precompile.R"),
        "",
        if (skip_on_cran) "skip_on_cran()" else "",
        if (skip_on_ci) "skip_on_ci()" else "",
        if (skip_on_travis) "skip_on_travis()" else "",
        "",
        readLines(r_out),
        "",
        "# Force clean up",
        "rm(list = ls())",
        "gc()",
        ""
      ),
      r_out
    )
  }
}

precompile("example_smoking.Rmd")
precompile("example_thrombolytics.Rmd")
precompile("example_blocker.Rmd")
precompile("example_dietary_fat.Rmd")
precompile("example_diabetes.Rmd")
precompile("example_parkinsons.Rmd")
precompile("example_transfusion.Rmd")
precompile("example_atrial_fibrillation.Rmd")
precompile("example_statins.Rmd")
precompile("example_bcg_vaccine.Rmd")
precompile("example_plaque_psoriasis.Rmd")
precompile("example_hta_psoriasis.Rmd")

# NDMM example is fully static (for pkgdown as well as cran)
# precompile("example_ndmm.Rmd.orig", write_tests = FALSE)
precompile("example_ndmm.Rmd", write_tests = FALSE)

