% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perry-deprecated.R
\name{perry-deprecated}
\alias{perry-deprecated}
\alias{fortify.perry}
\alias{fortify.perrySelect}
\alias{fortify.perryTuning}
\alias{perryPlot.default}
\title{Deprecated functions in package \pkg{perry}}
\usage{
\method{fortify}{perry}(
  model,
  data,
  select = NULL,
  reps = model$splits$R > 1,
  seFactor = NA,
  ...
)

\method{fortify}{perrySelect}(
  model,
  data,
  subset = NULL,
  select = NULL,
  reps = model$splits$R > 1,
  seFactor = model$seFactor,
  ...
)

\method{fortify}{perryTuning}(model, data, ...)

\method{perryPlot}{default}(
  object,
  method = c("box", "density", "dot", "line"),
  mapping,
  facets = attr(object, "facets"),
  ...
)
}
\arguments{
\item{model}{an object inheriting from class \code{"perry"} or
\code{"perrySelect"} that contains prediction error results.}

\item{data}{currently ignored.}

\item{select}{a character, integer or logical vector indicating the columns
of prediction error results to be converted.}

\item{reps}{a logical indicating whether to convert the results from all
replications (\code{TRUE}) or the aggregated results (\code{FALSE}).  The
former is suitable for box plots or smooth density plots, while the latter
is suitable for dot plots or line plots (see \code{\link{perryPlot}}).}

\item{seFactor}{a numeric value giving the multiplication factor of the
standard error for displaying error bars in dot plots or line plots.  Error
bars in those plots can be suppressed by setting this to \code{NA}.}

\item{\dots}{for the \code{"perryTuning"} method of \code{fortify},
additional arguments to be passed down to its \code{"perrySelect"}
method.  For the other methods of \code{fortify}, additional arguments are
currently ignored.  For the default method of \code{perryPlot}, additional
arguments to be passed down to \code{\link[ggplot2]{geom_boxplot}},
\code{\link[ggplot2]{geom_density}}, \code{\link[ggplot2]{geom_pointrange}}
or \code{\link[ggplot2]{geom_line}}.}

\item{subset}{a character, integer or logical vector indicating the subset
of models to be converted.}

\item{object}{an object inheriting from class \code{"perry"} or
\code{"perrySelect"} that contains prediction error results, or a data frame
containing all necessary information for plotting (as generated by the
corresponding \code{\link[=fortify.perry]{fortify}} method).}

\item{method}{a character string specifying the type of plot.  Possible
values are \code{"box"} to create a box plot, \code{"density"} to create a
smooth density plot, \code{"dot"} to create a dot plot, or \code{"line"} to
plot the (average) results for each model as a connected line (for objects
inheriting from class \code{"perrySelect"}).  Note that the first two plots
are only meaningful in case of repeated resampling.  The default is to use
\code{"box"} in case of repeated resampling and \code{"dot"} otherwise.  In
any case, partial string matching allows supply abbreviations of the
accepted values.}

\item{mapping}{an aesthetic mapping to override the default behavior (see
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}).}

\item{facets}{a faceting formula to override the default behavior.  If
supplied, \code{\link[ggplot2]{facet_wrap}} or
\code{\link[ggplot2]{facet_grid}} is called depending on whether the formula
is one-sided or two-sided.}
}
\value{
The \code{fortify} methods return a data frame containing the
columns listed below, as well as additional information stored in the
attribute \code{"facets"} (default faceting formula for the plots).
\describe{
  \item{\code{Fit}}{a vector or factor containing the identifiers of the
  models.}
  \item{\code{Name}}{a factor containing the names of the predictor error
  results (not returned in case of only one column of prediction error
  results with the default name).}
  \item{\code{PE}}{the estimated prediction errors.}
  \item{\code{Lower}}{the lower end points of the error bars (only returned
  if \code{reps} is \code{FALSE}).}
  \item{\code{Upper}}{the upper end points of the error bars (only returned
  if \code{reps} is \code{FALSE}).}
}
}
\description{
These functions are provided for compatibility with older versions only, and
may be defunct as soon as the next release.
}
\details{
The \code{fortify} methods extract all necessary information for plotting
from resampling-based prediction error results and store it in a data frame.

The default method of \code{perryPlot} creates the corresponding plot from
the data frame returned by \code{fortify}.
}
\note{
Duplicate indices in \code{subset} or \code{select} are removed such
that all models and prediction error results are unique.
}
\author{
Andreas Alfons
}
\keyword{utilities}
