% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testFuzzyMultiset}
\alias{testFuzzyMultiset}
\alias{checkFuzzyMultiset}
\alias{assertFuzzyMultiset}
\title{assert/check/test/FuzzyMultiset}
\usage{
testFuzzyMultiset(object, errormsg = "This is not an R6 FuzzyMultiset object")

checkFuzzyMultiset(object, errormsg = "This is not an R6 FuzzyMultiset object")

assertFuzzyMultiset(
  object,
  errormsg = "This is not an R6 FuzzyMultiset object"
)
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{FuzzyMultiset}.
}
\examples{
testFuzzyMultiset(Set$new(2, 3))
testFuzzyMultiset(list(Set$new(2), Set$new(3)))
testFuzzyMultiset(Tuple$new(2, 3))
testFuzzyMultiset(Interval$new())
testFuzzyMultiset(FuzzySet$new(2, 0.1))
testFuzzyMultiset(FuzzyTuple$new(2, 0.1))
testFuzzyMultiset(ConditionalSet$new(function(x) x == 0))
}
