% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\name{bind.variables}
\alias{bind.variables}
\title{Bind Variables and Create a Data.frame}
\usage{
bind.variables(
  varList,
  interpolate = FALSE,
  adjustLeadLags = FALSE,
  numExo = 0,
  horizon = 0
)
}
\arguments{
\item{varList}{A list of variables (i.e., \code{ldtv} objects) with similar frequency class.}

\item{interpolate}{If \code{TRUE}, missing observations are interpolated.}

\item{adjustLeadLags}{If \code{TRUE}, leads and lags are adjusted with respect to the first variable.}

\item{numExo}{An integer representing the number of exogenous variables.}

\item{horizon}{An integer representing the required length of out-of-sample data if \code{adjustLeadLags} is \code{TRUE} and there are exogenous variables.
It creates lags of exogenous variables or omits \code{NaN}s to make data available.}
}
\value{
A list with the following members:
\item{data}{A numeric matrix representing the final data after the requested fixes. It is a matrix with variables in the columns and frequencies as the row names.}
\item{info}{An integer matrix containing information about the columns of the final data, such as range of data, missing data, lags/leads, etc.}
\item{startFrequency}{The start frequency of the data.}
\item{startClass}{The frequency class of the data.}
}
\description{
Use this function to bind variables with the same class of frequency together.
}
\examples{
v1 = variable(c(1,2,3,2,3,4,5),f.monthly(2022,12),"V1")
v2 = variable(c(10,20,30,20,30,40,50),f.monthly(2022,8),"V2")
L = bind.variables(list(v1,v2))
}
