% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_f.R
\name{get.class.id}
\alias{get.class.id}
\title{Get the Class Id of a Frequency}
\usage{
get.class.id(frequency)
}
\arguments{
\item{frequency}{The frequency, which must be an \code{ldtf} object returned from the \code{f.?} functions.}
}
\value{
A character string that represents the class id of this frequency.
}
\description{
Use this function to get the 'id' of a frequency class.
}
\details{
You need this 'id' to convert the character back to the object. Some frequencies have a constant class id, such as 'm' for 'monthly' data. Some class 'ids' have parameters in them. Note that the format is explained in the \code{f.?} functions.
}
\examples{

freq <- f.x.times.a.day(f.daily(c(2023,5,16)),13, 12)
freq_class_id <- get.class.id(freq) # this will be 'da13|d'.

}
