/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.data.Data;
import org.basex.query.expr.Expr;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public final class ExprType {
    private SeqType seqType;
    private long size;
    private Data data;

    public ExprType(SeqType seqType) {
        this.assign(seqType);
    }

    public ExprType(ExprType et) {
        this.seqType = et.seqType;
        this.size = et.size;
        this.data = et.data;
    }

    public SeqType seqType() {
        return this.seqType;
    }

    public long size() {
        return this.size;
    }

    public Data data() {
        return this.data;
    }

    public void data(Data dt) {
        if (dt != null) {
            this.data = dt;
        }
    }

    public void data(Expr ... exprs) {
        Data dt = null;
        for (Expr expr : exprs) {
            if (expr == null || expr.seqType().zero()) continue;
            Data d = expr.data();
            if (dt == null) {
                dt = d;
            }
            if (dt != null && dt == d) continue;
            return;
        }
        this.data(dt);
    }

    public void data(Expr expr) {
        if (expr != null) {
            this.data(expr.data());
        }
    }

    public void assign(Expr expr) {
        this.asg(expr.seqType(), expr.size());
        this.data(expr);
    }

    public ExprType assign(SeqType st) {
        if (st != this.seqType) {
            this.asg(st, st.zero() ? 0L : (st.one() ? 1L : -1L));
        }
        return this;
    }

    public void assign(Type type) {
        this.seqType = SeqType.get(type, this.seqType.occ);
    }

    public ExprType assign(Type type, Occ occ) {
        return this.assign(SeqType.get(type, occ));
    }

    public ExprType assign(Occ occ) {
        return this.assign(this.seqType.with(occ));
    }

    public ExprType assign(SeqType st, long sz) {
        if (sz >= 0L) {
            this.asg(st.with(sz == 0L ? Occ.ZERO : (sz == 1L ? Occ.EXACTLY_ONE : Occ.ONE_OR_MORE)), sz);
        } else {
            this.assign(st);
        }
        return this;
    }

    public ExprType assign(SeqType st, Occ occ, long sz) {
        return this.assign(sz >= 0L ? st : st.with(occ), sz);
    }

    public void assign(Expr expr, long[] minMax) {
        long sz;
        long min = minMax[0];
        long max = minMax[1];
        long l = sz = min == max ? min : -1L;
        Occ occ = min > 0L ? Occ.ONE_OR_MORE : (max == 1L ? Occ.ZERO_OR_ONE : Occ.ZERO_OR_MORE);
        this.assign(expr.seqType(), occ, sz);
        this.data(expr);
    }

    public void refine(Expr expr) {
        SeqType st = this.seqType;
        SeqType est = expr.seqType();
        if (!st.instanceOf(est)) {
            long es = expr.size();
            SeqType ist = st.intersect(est);
            if (ist != null) {
                this.asg(ist, es == this.size || this.size == -1L ? es : (es == -1L ? this.size : -1L));
            } else {
                Util.errln("Expression type % cannot be refined for % (%): %", st, Util.className(expr), est, expr);
            }
        }
        this.data(expr);
    }

    private void asg(SeqType st, long sz) {
        this.seqType = st;
        this.size = sz;
    }

    public String toString() {
        return Util.className(this) + "[" + String.valueOf(this.seqType) + ", " + this.size + "]";
    }
}

