/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.core.Databases;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.FuncDefinition;
import org.basex.query.func.HofArgs;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.list.StringList;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public abstract class StandardFunc
extends Arr {
    public FuncDefinition definition;

    protected StandardFunc() {
        super(null, Types.ITEM_ZM, new Expr[0]);
    }

    final void init(InputInfo ii, FuncDefinition df, Expr[] args) {
        this.info = ii;
        this.definition = df;
        this.exprs = args;
        this.exprType.assign(df.seqType);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        this.checkPerm(cc.qc, this.definition.perm);
        this.simplifyArgs(cc);
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        SeqType st = this.definition.seqType;
        return this.values(st.occ.max > 1L || st.type instanceof FType, cc) && this.isSimple() ? cc.preEval(this) : this;
    }

    protected void simplifyArgs(CompileContext cc) throws QueryException {
        int al = this.args().length;
        for (int a = 0; a < al; ++a) {
            int p = Math.min(a, this.definition.types.length - 1);
            Type type = this.definition.types[p].type;
            if (!type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) continue;
            CompileContext.Simplify mode = type.instanceOf(AtomType.NUMERIC) ? CompileContext.Simplify.NUMBER : (type.instanceOf(AtomType.STRING) ? CompileContext.Simplify.STRING : CompileContext.Simplify.DATA);
            this.arg(a, arg -> arg.simplifyFor(mode, cc));
        }
    }

    protected Expr opt(CompileContext cc) throws QueryException {
        return this;
    }

    @Override
    public final StandardFunc copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(this.definition.get(this.info, StandardFunc.copyAll((CompileContext)cc, vm, (Expr[])this.args())));
    }

    protected final Expr optFirst() {
        return this.optFirst(true, true, null);
    }

    protected final Expr optFirst(boolean occ, boolean atom, Value value) {
        Value expr;
        Expr expr2 = expr = this.defined(0) ? this.arg(0) : value;
        if (expr != null) {
            SeqType st = expr.seqType();
            if (st.zero()) {
                return expr instanceof Dummy ? Empty.VALUE : expr;
            }
            if (occ && st.oneOrMore() && (!atom || !st.mayBeArray()) && this.exprType.seqType().zeroOrOne()) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
        return this;
    }

    protected final byte[] serialize(Iter iter, SerializerOptions sopts, QueryError err, QueryContext qc) throws QueryException {
        try {
            ArrayOutput ao = new ArrayOutput();
            try (Serializer ser = Serializer.get(ao, sopts);){
                Item item;
                while ((item = qc.next(iter)) != null) {
                    ser.serialize(item);
                }
            }
            return new TokenBuilder(ao.finish()).normalize().finish();
        }
        catch (QueryIOException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            throw err.get(this.info, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final boolean has(Flag ... flags) {
        int hof = this.hofIndex();
        if (hof >= 0 && hof < Integer.MAX_VALUE && !this.defined(hof)) {
            hof = -1;
        }
        Flag[] flagArray = flags;
        int n = flagArray.length;
        int n2 = 0;
        while (true) {
            block15: {
                if (n2 >= n) {
                    return super.has(Flag.remove(flags, Flag.HOF));
                }
                Flag flag = flagArray[n2];
                switch (flag) {
                    case HOF: {
                        if (hof >= 0) {
                            return true;
                        }
                        break block15;
                    }
                    case UPD: {
                        if (!this.hasUPD()) break;
                        return true;
                    }
                    case CTX: {
                        if (!this.hasCTX()) break;
                        return true;
                    }
                    case NDT: {
                        if (hof == Integer.MAX_VALUE) {
                            return true;
                        }
                        if (hof < 0) break;
                        Expr expr = this.arg(hof);
                        if (!(expr instanceof Value)) {
                            return true;
                        }
                        Value value = (Value)expr;
                        for (Item item : value) {
                            if (item instanceof FuncItem) {
                                FuncItem fi = (FuncItem)item;
                                if (!fi.expr.has(Flag.NDT)) continue;
                            }
                            return true;
                        }
                    }
                }
                if (this.definition.has(flag)) {
                    return true;
                }
            }
            ++n2;
        }
    }

    public boolean hasUPD() {
        return this.definition.has(Flag.UPD) || this.sc().mixUpdates && this.hofIndex() >= 0;
    }

    public boolean hasCTX() {
        return this.definition.has(Flag.CTX);
    }

    public int hofIndex() {
        return this.definition.has(Flag.HOF) ? Integer.MAX_VALUE : -1;
    }

    @Override
    public boolean vacuous() {
        return this.size() == 0L && !this.has(Flag.UPD);
    }

    public final Expr coerceFunc(int i, CompileContext cc) throws QueryException {
        return this.coerceFunc(i, cc, -1);
    }

    public final Expr coerceFunc(int i, CompileContext cc, int arity) throws QueryException {
        FuncType ft = (FuncType)this.definition.types[i].type;
        if (arity != -1 && arity != ft.argTypes.length) {
            ft = ft.with(arity);
        }
        return new TypeCheck(this.info, this.arg(i), ft.seqType()).optimize(cc);
    }

    public static Expr refineFunc(Expr expr, CompileContext cc, SeqType ... argTypes) throws QueryException {
        Expr expr2;
        if (expr instanceof FuncItem) {
            FuncItem fi = (FuncItem)expr;
            expr2 = fi.refine(argTypes, cc);
        } else {
            expr2 = expr;
        }
        return expr2;
    }

    public static int arity(Expr expr) {
        SeqType[] at;
        FuncType ft = expr.funcType();
        if (ft != null && (at = ft.argTypes) != null) {
            return at.length;
        }
        return -1;
    }

    protected final Expr compileData(CompileContext cc) throws QueryException {
        if (cc.dynamic && this.defined(0) && this.arg(0) instanceof Value) {
            Data data = this.toData(cc.qc);
            this.exprType.data(data);
            cc.info("open database \"%\"", data.meta.name);
        }
        return this;
    }

    protected Expr embed(CompileContext cc, boolean skip) throws QueryException {
        Expr[] ops;
        if (this.arg(0) instanceof SimpleMap && ((Checks<Expr>)arg_0 -> StandardFunc.lambda$embed$1(ops = this.arg(0).args(), arg_0)).all((Expr[])ops)) {
            Expr[] args = (Expr[])((ExprList)((ExprList)new ExprList().add(this.args())).set(0, ops[0])).finish();
            Expr fn = this.definition.get(this.info, args).optimize(cc);
            return skip ? fn : SimpleMap.get(cc, this.info, (Expr[])((ExprList)new ExprList((Expr[])ops.clone()).set(0, fn)).finish());
        }
        return this;
    }

    protected final ADate toGregorian(Item item, QueryContext qc) throws QueryException {
        return (ADate)Types.GREGORIAN_ZO.coerce((Value)item, null, qc, null, this.info);
    }

    protected final ADate toDate(Item item, AtomType type, QueryContext qc) throws QueryException {
        return (ADate)(item.type.isUntyped() ? type.cast(item, qc, this.info) : this.checkType(item, type));
    }

    protected final DBNode toDBNode(Item item, boolean mainmem) throws QueryException {
        if (item instanceof DBNode) {
            DBNode node = (DBNode)item;
            if (mainmem || !node.data().inMemory()) {
                return node;
            }
        }
        throw QueryError.DB_NODE_X.get(this.info, item);
    }

    protected final AStr toStr(Expr expr, QueryContext qc) throws QueryException {
        AStr str;
        Item value = expr.atomItem(qc, this.info);
        return value instanceof AStr ? (str = (AStr)value) : Str.get(this.toToken(value));
    }

    protected final AStr toZeroStr(Expr expr, QueryContext qc) throws QueryException {
        AStr aStr;
        Item value = expr.atomItem(qc, this.info);
        if (value.isEmpty()) {
            aStr = Str.EMPTY;
        } else if (value instanceof AStr) {
            AStr str = (AStr)value;
            aStr = str;
        } else {
            aStr = Str.get(this.toToken(value));
        }
        return aStr;
    }

    protected final Dur toDur(Item item) throws QueryException {
        if (item instanceof Dur) {
            Dur dur = (Dur)item;
            return dur;
        }
        if (item.type.isUntyped()) {
            return new Dur(item.string(this.info), this.info);
        }
        throw QueryError.typeError(item, AtomType.DURATION, this.info);
    }

    protected final Collation toCollation(Expr expr, QueryContext qc) throws QueryException {
        return this.toCollation(this.toTokenOrNull(expr, qc), qc);
    }

    protected final Collation toCollation(byte[] collation, QueryContext qc) throws QueryException {
        return Collation.get(collation, qc, this.info, QueryError.WHICHCOLL_X);
    }

    protected final Path toPath(Expr expr, QueryContext qc) throws QueryException {
        return this.toPath(this.toString(expr, qc));
    }

    protected final Path toPath(String path) throws QueryException {
        try {
            return path.startsWith("file:/") ? Paths.get(new URI(path)) : Paths.get(path, new String[0]);
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            Util.debug(ex);
            throw QueryError.FILE_INVALID_PATH_X.get(this.info, path);
        }
    }

    protected final IO toIO(Expr expr, QueryContext qc) throws QueryException {
        return this.toIO(this.toString(expr, qc), false);
    }

    protected final IO toIO(String uri, boolean content) throws QueryException {
        IO io = this.sc().resolve(uri);
        if (io instanceof IOContent) {
            if (!content) {
                throw QueryError.RESURI_X.get(this.info, uri);
            }
        } else {
            if (Strings.contains(io.path(), '#')) {
                throw QueryError.RESFRAG_X.get(this.info, io);
            }
            if (io instanceof IOFile && io.isDir()) {
                throw QueryError.RESDIR_X.get(this.info, io);
            }
            if (!io.exists()) {
                throw QueryError.RESWHICH_X.get(this.info, io);
            }
            if (!Uri.get(uri).isValid()) {
                throw QueryError.RESURI_X.get(this.info, uri);
            }
        }
        return io;
    }

    protected final IOContent toContent(Expr expr, QueryContext qc) throws QueryException {
        Item item = this.toAtomItem(expr, qc);
        return item instanceof Uri ? this.toContent(Token.string(item.string(this.info)), qc) : new IOContent(this.toToken(item));
    }

    protected final IOContent toContent(String source, QueryContext qc) throws QueryException {
        this.checkPerm(qc, Perm.ADMIN);
        IO io = this.toIO(source, false);
        try {
            return new IOContent(io.readString(), io.url());
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    protected final String toBaseUri(String path, Options options, StringOption option) {
        String base = options.get(option);
        return base != null && !base.isEmpty() ? base : (path != null && !path.isEmpty() ? path : Token.string(this.sc().baseURI().string()));
    }

    protected final String toEncodingOrNull(Expr expr, QueryError err, QueryContext qc) throws QueryException {
        return this.toEncodingOrNull(this.toStringOrNull(expr, qc), err);
    }

    protected final String toEncodingOrNull(String encoding, QueryError err) throws QueryException {
        if (encoding == null) {
            return null;
        }
        String error = Strings.checkEncoding(encoding);
        if (error != null) {
            throw err.get(this.info, error);
        }
        return Strings.normEncoding(encoding, false);
    }

    protected final Item toNodeOrAtomItem(Expr expr, boolean empty, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        if (empty && item.isEmpty()) {
            return null;
        }
        if (!(item instanceof ANode)) {
            item = item.atomItem(qc, this.info);
        }
        if (item.isEmpty()) {
            throw QueryError.typeError(item, AtomType.ITEM, this.info);
        }
        return item;
    }

    protected final SerializerOptions toSerializerOptions(Expr expr, QueryContext qc) throws QueryException {
        SerializerOptions options = new SerializerOptions();
        options.set(SerializerOptions.METHOD, SerialMethod.XML);
        Item item = expr.item(qc, this.info);
        if (item instanceof XQMap) {
            XQMap map = (XQMap)item;
            options.assign(map, this.info);
        } else if (!item.isEmpty()) {
            options.assign(item, this.info);
        }
        return options;
    }

    protected final HashMap<String, String> toOptions(Expr expr, QueryContext qc) throws QueryException {
        return this.toOptions(expr, new Options(), qc).free();
    }

    protected final <E extends Options> E toOptions(Expr expr, E options, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        if (!item.isEmpty()) {
            options.assign(this.toMap(item), this.info);
        }
        return options;
    }

    protected final HashMap<String, Value> toBindings(Expr expr, QueryContext qc) throws QueryException {
        HashMap<String, Value> hm = new HashMap<String, Value>();
        Item item = expr.item(qc, this.info);
        XQMap map = item.isEmpty() ? XQMap.empty() : this.toMap(item);
        map.forEach((key, value) -> {
            byte[] k = key.type.isStringOrUntyped() ? key.string(this.info) : this.toQNm((Item)key).unique();
            hm.put(Token.string(k), (Value)value);
        });
        return hm;
    }

    protected final Data toData(QueryContext qc) throws QueryException {
        Data data = this.exprType.data();
        return data != null ? data : this.toData(this.toName(this.arg(0), false, QueryError.DB_NAME_X, qc), qc);
    }

    protected final String toName(Expr expr, boolean empty, QueryError error, QueryContext qc) throws QueryException {
        String name = this.toZeroString(expr, qc);
        if (empty && name.isEmpty() || Databases.validName(name)) {
            return name;
        }
        throw error.get(this.info, name);
    }

    protected final long toMs(Expr expr, QueryContext qc) throws QueryException {
        Dtm dtm = (Dtm)this.checkType(expr, AtomType.DATE_TIME, qc);
        if (dtm.yea() > 292278993L) {
            throw QueryError.INTRANGE_X.get(this.info, dtm.yea());
        }
        return dtm.toJava().toGregorianCalendar().getTimeInMillis();
    }

    protected final Data toData(String name, QueryContext qc) throws QueryException {
        return qc.resources.database(name, qc.user, this.definition.has(Flag.UPD), this.info);
    }

    protected final FItem toFunctionOrNull(Expr expr, int nargs, QueryContext qc) throws QueryException {
        Item item = expr.item(qc, this.info);
        return item.isEmpty() ? null : this.checkArity(this.toFunction(item, qc), nargs, false);
    }

    protected final FItem toFunction(Expr expr, int nargs, QueryContext qc) throws QueryException {
        return this.toFunction(expr, nargs, false, qc);
    }

    protected final FItem toFunction(Expr expr, int nargs, boolean updating, QueryContext qc) throws QueryException {
        return this.checkArity(this.toFunction(expr, qc), nargs, updating);
    }

    private FItem checkArity(FItem func, int nargs, boolean updating) throws QueryException {
        this.checkUp(func, updating);
        int arity = func.arity();
        if (nargs < arity) {
            throw QueryError.arityError(func, arity, nargs, true, this.info);
        }
        return func;
    }

    protected final boolean test(FItem predicate, HofArgs args, QueryContext qc) throws QueryException {
        Item item = this.invoke(predicate, args, qc).atomItem(qc, this.info);
        return !item.isEmpty() && this.toBoolean(item);
    }

    protected final Value invoke(FItem function, HofArgs args, QueryContext qc) throws QueryException {
        return function.invoke(qc, this.info, args.get());
    }

    protected final boolean defined(int i) {
        return this.arg(i) != Empty.UNDEFINED;
    }

    protected final boolean dataLock(Expr expr, boolean backup, ASTVisitor visitor) {
        return visitor.lock(() -> {
            String name;
            ArrayList<String> list = new ArrayList<String>(1);
            if (expr instanceof Str) {
                Str str = (Str)expr;
                v0 = Token.string(str.string());
            } else if (expr instanceof Atm) {
                Atm atm = (Atm)expr;
                v0 = Token.string(atm.string(this.info));
            } else {
                v0 = name = null;
            }
            if (name != null) {
                if (backup) {
                    String db = Databases.name(name);
                    if (db.isEmpty()) {
                        name = db;
                    } else {
                        list.add(db);
                    }
                }
                if (name.isEmpty()) {
                    name = null;
                }
            }
            list.add(name);
            return list;
        });
    }

    protected final QueryException error(QueryException ex, QueryError error) {
        if (error == null) {
            return ex;
        }
        Util.debug(ex);
        return error.get(this.info, ex.getLocalizedMessage());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof StandardFunc)) return false;
        StandardFunc sf = (StandardFunc)obj;
        if (this.definition != sf.definition) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public final String description() {
        return this.definition.toString();
    }

    @Override
    public final void toXml(QueryPlan plan) {
        byte[] name = this.definition.name.prefixId(QueryText.FN_URI);
        int undefined = this.undefined();
        if (undefined == 0) {
            plan.add(plan.create(this, "name", name), this.args());
        } else {
            int al = this.args().length;
            QNm[] names = this.definition.paramNames(al);
            ExprList args = new ExprList(al - undefined);
            StringList nms = new StringList(al - undefined);
            for (int a = 0; a < al; ++a) {
                if (!this.defined(a)) continue;
                args.add(this.arg(a));
                nms.add(names[a].toString());
            }
            plan.add(plan.create(this, "name", name, "arg", String.join((CharSequence)", ", (CharSequence[])nms.finish())), (ExprInfo[])args.finish());
        }
    }

    @Override
    public final void toString(QueryString qs) {
        byte[] name = this.definition.name.prefixId(QueryText.FN_URI);
        int undefined = this.undefined();
        if (undefined == 0) {
            qs.token(name).params(this.args());
        } else {
            int al = this.args().length;
            QNm[] names = this.definition.paramNames(al);
            Object[] args = new Object[al - undefined];
            boolean gap = false;
            int b = 0;
            for (int a = 0; a < al; ++a) {
                if (this.defined(a)) {
                    args[b++] = gap ? String.valueOf(names[a]) + " := " + String.valueOf(this.arg(a)) : this.arg(a);
                    continue;
                }
                gap = true;
            }
            qs.token(name).params(args);
        }
    }

    private int undefined() {
        int c = 0;
        int al = this.args().length;
        for (int a = 0; a < al; ++a) {
            if (this.defined(a)) continue;
            ++c;
        }
        return c;
    }

    private static /* synthetic */ boolean lambda$embed$1(Expr[] ops, Expr op) {
        return op == ops[0] || op.seqType().one() && !op.has(Flag.POS);
    }
}

