/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.ssh;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class OpenSshConfigFile
implements SshConfigStore {
    private final File home;
    private final File configFile;
    private final String localUserName;
    private Instant lastModified;
    private State state;

    public OpenSshConfigFile(@NonNull File home, @NonNull File config, @NonNull String localUserName) {
        this.home = home;
        this.configFile = config;
        this.localUserName = localUserName;
        this.state = new State();
    }

    @Override
    @NonNull
    public HostEntry lookup(@NonNull String hostName, int port, String userName) {
        return this.lookup(hostName, port, userName, false);
    }

    @Override
    @NonNull
    public HostEntry lookupDefault(@NonNull String hostName, int port, String userName) {
        return this.lookup(hostName, port, userName, true);
    }

    private HostEntry lookup(@NonNull String hostName, int port, String userName, boolean fillDefaults) {
        State cache = this.refresh();
        String cacheKey = this.toCacheKey(hostName, port, userName);
        HostEntry h2 = cache.hosts.get(cacheKey);
        if (h2 != null) {
            return h2;
        }
        HostEntry fullConfig = new HostEntry();
        Iterator<HostEntry> entries = cache.entries.iterator();
        if (entries.hasNext()) {
            fullConfig.merge(entries.next());
            entries.forEachRemaining(entry -> {
                if (entry.matches(hostName)) {
                    fullConfig.merge((HostEntry)entry);
                }
            });
        }
        fullConfig.substitute(hostName, port, userName, this.localUserName, this.home, fillDefaults);
        cache.hosts.put(cacheKey, fullConfig);
        return fullConfig;
    }

    @NonNull
    private String toCacheKey(@NonNull String hostName, int port, String userName) {
        Object key = hostName;
        if (port > 0) {
            key = (String)key + ":" + Integer.toString(port);
        }
        if (userName != null && !userName.isEmpty()) {
            key = userName + "@" + (String)key;
        }
        return key;
    }

    private synchronized State refresh() {
        Instant mtime = FS.DETECTED.lastModifiedInstant(this.configFile);
        if (!mtime.equals(this.lastModified)) {
            State newState = new State();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader br = Files.newBufferedReader(this.configFile.toPath(), StandardCharsets.UTF_8);){
                    newState.entries = this.parse(br);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
            this.lastModified = mtime;
            this.state = newState;
        }
        return this.state;
    }

    private List<HostEntry> parse(BufferedReader reader) throws IOException {
        String line;
        HostEntry defaults;
        ArrayList<HostEntry> entries = new ArrayList<HostEntry>();
        HostEntry current = defaults = new HostEntry();
        entries.add(defaults);
        block4: while ((line = reader.readLine()) != null) {
            String argValue;
            String[] parts;
            String keyword;
            if ((line = line.strip()).isEmpty() || (keyword = (parts = line.split("[ \t]*[= \t]", 2))[0].strip()).isEmpty()) continue;
            switch (keyword.charAt(0)) {
                case '#': {
                    continue block4;
                }
                case '\"': {
                    List<String> dequoted = OpenSshConfigFile.parseList(keyword);
                    keyword = dequoted.isEmpty() ? "" : dequoted.get(0);
                    break;
                }
                default: {
                    int i = keyword.indexOf(35);
                    if (i < 0) break;
                    keyword = keyword.substring(0, i);
                }
            }
            if (keyword.isEmpty()) continue;
            String string = argValue = parts.length > 1 ? parts[1].strip() : "";
            if (StringUtils.equalsIgnoreCase("Host", keyword)) {
                current = new HostEntry(OpenSshConfigFile.parseList(argValue));
                entries.add(current);
                continue;
            }
            if (HostEntry.isListKey(keyword)) {
                List<String> args = this.validate(keyword, OpenSshConfigFile.parseList(argValue));
                current.setValue(keyword, args);
                continue;
            }
            if (argValue.isEmpty()) continue;
            List<String> args = OpenSshConfigFile.parseList(argValue);
            String arg = args.isEmpty() ? "" : args.get(0);
            argValue = this.validate(keyword, arg);
            current.setValue(keyword, argValue);
        }
        return entries;
    }

    private static List<String> parseList(String argument) {
        ArrayList<String> result = new ArrayList<String>(4);
        int start = 0;
        int length = argument.length();
        while (start < length) {
            char ch = argument.charAt(start);
            if (Character.isWhitespace(ch)) {
                ++start;
                continue;
            }
            if (ch == '#') break;
            start = OpenSshConfigFile.parseToken(argument, start, length, result);
        }
        return result;
    }

    private static int parseToken(String argument, int from, int to, List<String> result) {
        StringBuilder b = new StringBuilder();
        int i = from;
        char quote = '\u0000';
        boolean escaped = false;
        block5: while (i < to) {
            char ch = argument.charAt(i);
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        if (escaped) {
                            b.append(ch);
                        } else {
                            quote = ch;
                        }
                    } else if (!escaped && quote == ch) {
                        quote = '\u0000';
                    } else {
                        b.append(ch);
                    }
                    escaped = false;
                    break;
                }
                case '\\': {
                    if (escaped) {
                        b.append(ch);
                    }
                    escaped = !escaped;
                    break;
                }
                case ' ': {
                    if (quote == '\u0000') {
                        if (!escaped) break block5;
                        b.append(ch);
                        escaped = false;
                        break;
                    }
                    if (escaped) {
                        b.append('\\');
                    }
                    b.append(ch);
                    escaped = false;
                    break;
                }
                default: {
                    if (escaped) {
                        b.append('\\');
                    }
                    if (quote == '\u0000' && Character.isWhitespace(ch)) break block5;
                    b.append(ch);
                    escaped = false;
                }
            }
            ++i;
        }
        if (b.length() > 0) {
            result.add(b.toString());
        }
        return i;
    }

    protected String validate(String key, String value) {
        if ("PreferredAuthentications".equalsIgnoreCase(key)) {
            return OpenSshConfigFile.stripWhitespace(value);
        }
        return value;
    }

    protected List<String> validate(String key, List<String> value) {
        return value;
    }

    private static boolean patternMatchesHost(String pattern, String name) {
        if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
            FileNameMatcher fn;
            try {
                fn = new FileNameMatcher(pattern, null);
            }
            catch (InvalidPatternException e) {
                return false;
            }
            fn.append(name);
            return fn.isMatch();
        }
        return pattern.equals(name);
    }

    private static String stripWhitespace(String value) {
        StringBuilder b = new StringBuilder();
        int length = value.length();
        int i = 0;
        while (i < length) {
            char ch = value.charAt(i);
            if (!Character.isWhitespace(ch)) {
                b.append(ch);
            }
            ++i;
        }
        return b.toString();
    }

    private static File toFile(String path, File home) {
        if (path.startsWith("~/") || path.startsWith("~" + File.separator)) {
            return new File(home, path.substring(2));
        }
        File ret = new File(path);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(home, path);
    }

    public static int positive(String value) {
        if (value != null) {
            try {
                return Integer.parseUnsignedInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static boolean flag(String value) {
        if (value == null) {
            return false;
        }
        return "yes".equals(value) || "on".equals(value) || "true".equals(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int timeSpec(String value) {
        if (value == null) {
            return -1;
        }
        try {
            int length = value.length();
            int i = 0;
            int seconds = 0;
            boolean valueSeen = false;
            while (i < length) {
                char ch = value.charAt(i);
                if (Character.isWhitespace(ch)) {
                    ++i;
                    continue;
                }
                if (ch == '+') {
                    // empty if block
                }
                int val = 0;
                int j = ++i;
                while (j < length) {
                    if ((ch = value.charAt(j++)) >= '0' && ch <= '9') {
                        val = Math.addExact(Math.multiplyExact(val, 10), ch - 48);
                        continue;
                    }
                    --j;
                    break;
                }
                if (i == j) {
                    return -1;
                }
                i = j;
                int multiplier = 1;
                if (i < length) {
                    ch = value.charAt(i++);
                    switch (ch) {
                        case 'S': 
                        case 's': {
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            multiplier = 60;
                            break;
                        }
                        case 'H': 
                        case 'h': {
                            multiplier = 3600;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            multiplier = 86400;
                            break;
                        }
                        case 'W': 
                        case 'w': {
                            multiplier = 604800;
                            break;
                        }
                        default: {
                            if (!Character.isWhitespace(ch)) return -1;
                            break;
                        }
                    }
                }
                seconds = Math.addExact(seconds, Math.multiplyExact(val, multiplier));
                valueSeen = true;
            }
            if (!valueSeen) return -1;
            int n = seconds;
            return n;
        }
        catch (ArithmeticException e) {
            return -1;
        }
    }

    public String getLocalUserName() {
        return this.localUserName;
    }

    public String toString() {
        return "OpenSshConfig [home=" + String.valueOf(this.home) + ", configFile=" + String.valueOf(this.configFile) + ", lastModified=" + String.valueOf(this.lastModified) + ", state=" + String.valueOf(this.state) + "]";
    }

    public static class HostEntry
    implements SshConfigStore.HostConfig {
        private static final Set<String> MULTI_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        private static final Set<String> LIST_KEYS;
        private static final Map<String, String> ALIASES;
        private Map<String, String> options;
        private Map<String, List<String>> multiOptions;
        private Map<String, List<String>> listOptions;
        private final List<String> patterns;

        static {
            MULTI_KEYS.add("CertificateFile");
            MULTI_KEYS.add("IdentityFile");
            MULTI_KEYS.add("LocalForward");
            MULTI_KEYS.add("RemoteForward");
            MULTI_KEYS.add("SendEnv");
            LIST_KEYS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            LIST_KEYS.add("CanonicalDomains");
            LIST_KEYS.add("GlobalKnownHostsFile");
            LIST_KEYS.add("SendEnv");
            LIST_KEYS.add("UserKnownHostsFile");
            LIST_KEYS.add("AddKeysToAgent");
            ALIASES = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            ALIASES.put("PubkeyAcceptedKeyTypes", "PubkeyAcceptedAlgorithms");
        }

        public HostEntry() {
            this.patterns = Collections.emptyList();
        }

        public HostEntry(List<String> patterns) {
            this.patterns = patterns;
        }

        boolean matches(String hostName) {
            boolean doesMatch = false;
            for (String pattern : this.patterns) {
                if (pattern.startsWith("!")) {
                    if (!OpenSshConfigFile.patternMatchesHost(pattern.substring(1), hostName)) continue;
                    return false;
                }
                if (doesMatch || !OpenSshConfigFile.patternMatchesHost(pattern, hostName)) continue;
                doesMatch = true;
            }
            return doesMatch;
        }

        private static String toKey(String key) {
            String k = ALIASES.get(key);
            return k != null ? k : key;
        }

        @Override
        public String getValue(String key) {
            String result;
            String k = HostEntry.toKey(key);
            String string = result = this.options != null ? this.options.get(k) : null;
            if (result == null) {
                List<String> values;
                List<String> list = values = this.listOptions != null ? this.listOptions.get(k) : null;
                if (values == null) {
                    List<String> list2 = values = this.multiOptions != null ? this.multiOptions.get(k) : null;
                }
                if (values != null && !values.isEmpty()) {
                    result = values.get(0);
                }
            }
            return result;
        }

        @Override
        public List<String> getValues(String key) {
            List<String> values;
            String k = HostEntry.toKey(key);
            List<String> list = values = this.listOptions != null ? this.listOptions.get(k) : null;
            if (values == null) {
                List<String> list2 = values = this.multiOptions != null ? this.multiOptions.get(k) : null;
            }
            if (values == null || values.isEmpty()) {
                return new ArrayList<String>();
            }
            return new ArrayList<String>(values);
        }

        public void setValue(String key, String value) {
            String k = HostEntry.toKey(key);
            if (value == null) {
                if (this.multiOptions != null) {
                    this.multiOptions.remove(k);
                }
                if (this.listOptions != null) {
                    this.listOptions.remove(k);
                }
                if (this.options != null) {
                    this.options.remove(k);
                }
                return;
            }
            if (MULTI_KEYS.contains(k)) {
                List<String> values;
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if ((values = this.multiOptions.get(k)) == null) {
                    values = new ArrayList<String>(4);
                    this.multiOptions.put(k, values);
                }
                values.add(value);
            } else {
                if (this.options == null) {
                    this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                }
                if (!this.options.containsKey(k)) {
                    this.options.put(k, value);
                }
            }
        }

        public void setValue(String key, List<String> values) {
            if (values.isEmpty()) {
                return;
            }
            String k = HostEntry.toKey(key);
            if (MULTI_KEYS.contains(k)) {
                List<String> items;
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if ((items = this.multiOptions.get(k)) == null) {
                    items = new ArrayList<String>(values);
                    this.multiOptions.put(k, items);
                } else {
                    items.addAll(values);
                }
            } else {
                if (this.listOptions == null) {
                    this.listOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                if (!this.listOptions.containsKey(k)) {
                    this.listOptions.put(k, values);
                }
            }
        }

        public static boolean isListKey(String key) {
            return LIST_KEYS.contains(HostEntry.toKey(key));
        }

        void merge(HostEntry entry) {
            if (entry == null) {
                return;
            }
            if (entry.options != null) {
                if (this.options == null) {
                    this.options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry2 : entry.options.entrySet()) {
                    if (this.options.containsKey(entry2.getKey())) continue;
                    this.options.put(entry2.getKey(), (String)entry2.getValue());
                }
            }
            if (entry.listOptions != null) {
                if (this.listOptions == null) {
                    this.listOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry3 : entry.listOptions.entrySet()) {
                    if (this.listOptions.containsKey(entry3.getKey())) continue;
                    this.listOptions.put(entry3.getKey(), (List)entry3.getValue());
                }
            }
            if (entry.multiOptions != null) {
                if (this.multiOptions == null) {
                    this.multiOptions = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
                }
                for (Map.Entry<String, Object> entry4 : entry.multiOptions.entrySet()) {
                    List<String> values = this.multiOptions.get(entry4.getKey());
                    if (values == null) {
                        values = new ArrayList<String>((Collection)entry4.getValue());
                        this.multiOptions.put(entry4.getKey(), values);
                        continue;
                    }
                    values.addAll((Collection)entry4.getValue());
                }
            }
        }

        private List<String> substitute(List<String> values, String allowed, Replacer r, boolean withEnv) {
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (String value : values) {
                result.add(r.substitute(value, allowed, withEnv));
            }
            return result;
        }

        private List<String> replaceTilde(List<String> values, File home) {
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (String value : values) {
                result.add(OpenSshConfigFile.toFile(value, home).getPath());
            }
            return result;
        }

        void substitute(String originalHostName, int port, String userName, String localUserName, File home, boolean fillDefaults) {
            List<String> values;
            String u;
            int p;
            int n = p = port > 0 ? port : OpenSshConfigFile.positive(this.getValue("Port"));
            if (p <= 0) {
                p = 22;
            }
            String string = u = !StringUtils.isEmptyOrNull(userName) ? userName : this.getValue("User");
            if (u == null || u.isEmpty()) {
                u = localUserName;
            }
            Replacer r = new Replacer(originalHostName, p, u, localUserName, home);
            if (this.options != null) {
                String hostName = this.options.get("HostName");
                if (hostName == null || hostName.isEmpty()) {
                    this.options.put("HostName", originalHostName);
                } else {
                    hostName = r.substitute(hostName, "h", false);
                    this.options.put("HostName", hostName);
                    r.update('h', hostName);
                }
            } else if (fillDefaults) {
                this.setValue("HostName", originalHostName);
            }
            if (this.multiOptions != null) {
                values = this.multiOptions.get("IdentityFile");
                if (values != null) {
                    values = this.substitute(values, "CdhLlnpru", r, true);
                    values = this.replaceTilde(values, home);
                    this.multiOptions.put("IdentityFile", values);
                }
                if ((values = this.multiOptions.get("CertificateFile")) != null) {
                    values = this.substitute(values, "CdhLlnpru", r, true);
                    values = this.replaceTilde(values, home);
                    this.multiOptions.put("CertificateFile", values);
                }
            }
            if (this.listOptions != null && (values = this.listOptions.get("UserKnownHostsFile")) != null) {
                values = this.substitute(values, "CdhLlnpru", r, true);
                values = this.replaceTilde(values, home);
                this.listOptions.put("UserKnownHostsFile", values);
            }
            if (this.options != null) {
                String value = this.options.get("IdentityAgent");
                if (value != null && !"none".equals(value) && !"SSH_AUTH_SOCK".equals(value)) {
                    value = r.substitute(value, "CdhLlnpru", true);
                    value = OpenSshConfigFile.toFile(value, home).getPath();
                    this.options.put("IdentityAgent", value);
                }
                if ((value = this.options.get("ControlPath")) != null) {
                    value = r.substitute(value, "CdhLlnpru", true);
                    value = OpenSshConfigFile.toFile(value, home).getPath();
                    this.options.put("ControlPath", value);
                }
                if ((value = this.options.get("LocalCommand")) != null) {
                    value = r.substitute(value, "CdhLlnprTu", false);
                    this.options.put("LocalCommand", value);
                }
                if ((value = this.options.get("RemoteCommand")) != null) {
                    value = r.substitute(value, "CdhLlnpru", false);
                    this.options.put("RemoteCommand", value);
                }
                if ((value = this.options.get("ProxyCommand")) != null) {
                    value = r.substitute(value, "hnpr", false);
                    this.options.put("ProxyCommand", value);
                }
            }
            if (fillDefaults) {
                String s2 = this.options.get("User");
                if (StringUtils.isEmptyOrNull(s2)) {
                    this.options.put("User", u);
                }
                if (OpenSshConfigFile.positive(this.options.get("Port")) <= 0) {
                    this.options.put("Port", Integer.toString(p));
                }
                if (OpenSshConfigFile.positive(this.options.get("ConnectionAttempts")) <= 0) {
                    this.options.put("ConnectionAttempts", "1");
                }
            }
        }

        @Override
        @NonNull
        public Map<String, String> getOptions() {
            if (this.options == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.options);
        }

        @Override
        @NonNull
        public Map<String, List<String>> getMultiValuedOptions() {
            if (this.listOptions == null && this.multiOptions == null) {
                return Collections.emptyMap();
            }
            TreeMap<String, List<String>> allValues = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            if (this.multiOptions != null) {
                allValues.putAll(this.multiOptions);
            }
            if (this.listOptions != null) {
                allValues.putAll(this.listOptions);
            }
            return Collections.unmodifiableMap(allValues);
        }

        public String toString() {
            return "HostEntry [options=" + String.valueOf(this.options) + ", multiOptions=" + String.valueOf(this.multiOptions) + ", listOptions=" + String.valueOf(this.listOptions) + "]";
        }
    }

    private static class Replacer {
        public static final String DEFAULT_TOKENS = "CdhLlnpru";
        private final Map<Character, String> replacements = new HashMap<Character, String>();

        public Replacer(String host, int port, String user, String localUserName, File home) {
            this.replacements.put(Character.valueOf('%'), "%");
            this.replacements.put(Character.valueOf('d'), home.getPath());
            this.replacements.put(Character.valueOf('h'), host);
            String localhost = SystemReader.getInstance().getHostname();
            this.replacements.put(Character.valueOf('l'), localhost);
            int period = localhost.indexOf(46);
            if (period > 0) {
                localhost = localhost.substring(0, period);
            }
            this.replacements.put(Character.valueOf('L'), localhost);
            this.replacements.put(Character.valueOf('n'), host);
            this.replacements.put(Character.valueOf('p'), Integer.toString(port));
            this.replacements.put(Character.valueOf('r'), user == null ? "" : user);
            this.replacements.put(Character.valueOf('u'), localUserName);
            this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr", false));
            this.replacements.put(Character.valueOf('T'), "NONE");
        }

        public void update(char key, String value) {
            this.replacements.put(Character.valueOf(key), value);
            if ("lhpr".indexOf(key) >= 0) {
                this.replacements.put(Character.valueOf('C'), this.substitute("%l%h%p%r", "hlpr", false));
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public String substitute(String input, String allowed, boolean withEnv) {
            if (input == null || input.length() <= 1 || input.indexOf(37) < 0 && (!withEnv || input.indexOf("${") < 0)) {
                return input;
            }
            StringBuilder builder = new StringBuilder();
            int start = 0;
            int length = input.length();
            block4: while (start < length) {
                char ch = input.charAt(start);
                switch (ch) {
                    case '%': {
                        if (start + 1 >= length) break;
                        String replacement = null;
                        ch = input.charAt(start + 1);
                        if (ch == '%' || allowed.indexOf(ch) >= 0) {
                            replacement = this.replacements.get(Character.valueOf(ch));
                        }
                        if (replacement == null) {
                            builder.append('%').append(ch);
                        } else {
                            builder.append(replacement);
                        }
                        start += 2;
                        continue block4;
                    }
                    case '$': {
                        int close;
                        if (!withEnv || start + 2 >= length) break;
                        ch = input.charAt(start + 1);
                        if (ch == '{' && (close = input.indexOf(125, start + 2)) > start + 2) {
                            String variable = SystemReader.getInstance().getenv(input.substring(start + 2, close));
                            if (!StringUtils.isEmptyOrNull(variable)) {
                                builder.append(variable);
                            }
                            start = close + 1;
                            continue block4;
                        }
                        ch = '$';
                    }
                }
                builder.append(ch);
                ++start;
            }
            return builder.toString();
        }
    }

    private static class State {
        List<HostEntry> entries = new ArrayList<HostEntry>();
        Map<String, HostEntry> hosts = new HashMap<String, HostEntry>();

        private State() {
        }

        public String toString() {
            return "State [entries=" + String.valueOf(this.entries) + ", hosts=" + String.valueOf(this.hosts) + "]";
        }
    }
}

