# Welcome to `zizmor`'s documentation!

[![CI](https://github.com/zizmorcore/zizmor/actions/workflows/ci.yml/badge.svg)](https://github.com/zizmorcore/zizmor/actions/workflows/ci.yml)
[![Crates.io](https://img.shields.io/crates/v/zizmor)](https://crates.io/crates/zizmor)
[![Packaging status](https://repology.org/badge/tiny-repos/zizmor.svg)](https://repology.org/project/zizmor/versions)
[![GitHub Sponsors](https://img.shields.io/github/sponsors/woodruffw?style=flat&logo=githubsponsors&labelColor=white&color=white)](https://github.com/sponsors/woodruffw)
[![Discord](https://img.shields.io/badge/Discord-%235865F2.svg?logo=discord&logoColor=white)](https://discord.com/invite/PGU3zGZuGG)

:rainbow: Hello, and welcome to `zizmor`'s documentation! :rainbow:

`zizmor` is a static analysis tool for GitHub Actions. It can find and fix
many common security issues in typical GitHub Actions CI/CD setups.

<div class="grid cards" markdown>
-   :material-download:{.lg .middle} Install `zizmor`

    ---

    Install `zizmor` using your favorite package manager.

    [:octicons-arrow-right-24: Installation steps](./installation.md)

-   :material-clock-fast:{.lg .middle} Quickstart

    ---

    Get started with `zizmor` in just a few minutes.

    [:octicons-arrow-right-24: Getting started](./quickstart.md)

-   :material-wrench:{.lg .middle} Usage Recipes

    ---

    Learn how to use and configure `zizmor`.

    [:octicons-arrow-right-24: Usage recipes](./usage.md)

-   :material-robot-love:{.lg .middle} Integrations

    ---

    Learn how to integrate `zizmor` into
    [GitHub Actions](./integrations.md#github-actions),
    [`pre-commit`](./integrations.md#pre-commit),
    [IDEs](./integrations.md#ides), and more!

    [:octicons-arrow-right-24: Integrations](./integrations.md)
</div>

<figure markdown="1">
![](https://zizmor.sh/assets/zizmor-demo.gif)
</figure>

## Sponsors 💖 { #sponsoring }

`zizmor`'s development is supported by these amazing sponsors!

<figure>
--8<-- "sponsors.html"
</figure>

Want to see your name or logo above? Consider becoming a sponsor
through one of the following:

- [GitHub Sponsors](https://github.com/sponsors/woodruffw) (preferred)
- [thanks.dev](https://thanks.dev/u/gh/woodruffw)
- [ko-fi](https://ko-fi.com/woodruffw)
