;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 2001-2009 Clozure Associates
;;;   This file is part of Clozure CL.  
;;;
;;;   Clozure CL is licensed under the terms of the Lisp Lesser GNU Public
;;;   License , known as the LLGPL and distributed with Clozure CL as the
;;;   file "LICENSE".  The LLGPL consists of a preamble and the LGPL,
;;;   which is distributed with Clozure CL as the file "LGPL".  Where these
;;;   conflict, the preamble takes precedence.  
;;;
;;;   Clozure CL is referenced in the preamble as the "LIBRARY."
;;;
;;;   The LLGPL is also available online at
;;;   http://opensource.franz.com/preamble.html

(in-package "CCL")

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "SYSCALL"))







(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::exit 1 (:signed-fullword) :void)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fork 2 () :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::read 3 (:unsigned-fullword :address :unsigned-fullword)
		:signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::write 4 (:unsigned-fullword :address :unsigned-fullword)
		:signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::open 5 (:address :unsigned-fullword :unsigned-fullword) :signed-fullword :min-args 2)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::close 6 (:unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::waitpid 7 (:unsigned-fullword :address :signed-fullword)
		:signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::creat 8 (:address :unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::link 9 (:address :address) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::unlink 10 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::execve 11 (:address :address :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::chdir 12 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::time 13 (:address) :unsigned-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mknod 14 (:address :unsigned-fullword :unsigned-fullword)
		:signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::chmod 15 (:address :unsigned-fullword) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::lchown 16 (:address :unsigned-fullword :unsigned-fullword)
		:signed-fullword)
;(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::oldstat 18 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::lseek 19 (:unsigned-fullword :signed-fullword :unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getpid 20 () :unsigned-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mount 21 (:address
				 :address
				 :address
				 :unsigned-fullword
				 :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::umount 22 (:address) :signed-fullword )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setuid 23 (:unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getuid 24 () :unsigned-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::stime 25 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ptrace 26 (:unsigned-fullword
				  :unsigned-fullword
				  :address
				  :address)
		:signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::alarm 27 (:unsigned-fullword) :unsigned-fullword )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::pause 29 () :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::utime 30 (:address :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::access 33 (:address :unsigned-fullword) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::nice 34 (:signed-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sync 36 () :unsigned-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::kill 37 (:signed-fullword :unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rename 38 (:address :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mkdir 39 (:address :unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rmdir 40 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::dup 41 (:unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::pipe 42 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::times 43 (:address) :unsigned-fullword )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::brk 45 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setgid 46 (:unsigned-fullword) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getgid 47 () :unsigned-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::signal 48 (:unsigned-fullword :address) :address )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::geteuid 49 () :unsigned-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getegid 50 () :unsigned-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::acct 51 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::umount2 52 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ioctl 54 (:unsigned-fullword :signed-fullword :address) :signed-fullword :min-args 2 )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fcntl 55 (:unsigned-fullword :signed-fullword :signed-fullword) :signed-fullword :min-args 2 )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setpgid 57 (:signed-fullword :signed-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::umask 60 (:unsigned-fullword) :unsigned-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::chroot 61 (:address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ustat 62 (:unsigned-fullword :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::dup2 63 (:unsigned-fullword :unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getppid 64 () :unsigned-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getpgrp 65 () :unsigned-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setsid 66 () :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sigaction 67 (:unsigned-fullword :address :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getrusage 77 (:signed-fullword :address) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::gettimeofday 78 (:address :address) :void)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ftruncate 93 (:unsigned-fullword :unsigned-fullword)
		:signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fchmod 94 (:unsigned-fullword :unsigned-fullword)
		:signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::socketcall 102 (:unsigned-fullword :address) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::stat 106 (:address :address) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::lstat 107 (:address :address) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fstat 108 (:unsigned-fullword :address) :signed-fullword )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fsync 118 (:unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::uname 122  (:address) :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fchdir 133 (:unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::_llseek 140 (:unsigned-fullword :unsigned-fullword :unsigned-fullword :address :unsigned-fullword) :signed-fullword )
(define-syscall (logior platform-cpu-ppc platform-os-linux) 	syscalls::select 142 (:unsigned-fullword :address :address
                                                  :address :address)
                :signed-fullword)
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getcwd 182 (:address :unsigned-fullword) :signed-fullword )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::poll 167 ((:* (:struct :pollfd)) :int :int) :int)

#+notdefinedyet
(progn
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sgetmask 68 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ssetmask 69 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setreuid 70 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setregid 71 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sigsuspend 72 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sigpending 73 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sethostname 74 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setrlimit 75 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getrlimit 76 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::settimeofday 79 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getgroups 80 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setgroups 81 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::symlink 83 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::oldlstat 84 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::readlink 85 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::uselib 86 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::swapon 87 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::reboot 88 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::readdir 89 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mmap 90 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::munmap 91 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::truncate 92 () )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fchown 95 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getpriority 96 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setpriority 97 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::statfs 99 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fstatfs 100 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ioperm 101 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::syslog 103 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setitimer 104 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getitimer 105 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::olduname 109 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::iopl 110 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::vhangup 111 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::idle 112 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::vm86 113 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::wait4 114 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::swapoff 115 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sysinfo 116 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::ipc 117 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sigreturn 119 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::clone 120 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setdomainname 121 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::modify_ldt 123 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::adjtimex 124 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mprotect 125 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sigprocmask 126 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::create_module	127 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::init_module	128 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::delete_module	129 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::get_kernel_syms	130 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::quotactl 131 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getpgid 132 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::bdflush 134 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sysfs 135 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::personality 136 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setfsuid 138 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setfsgid 139 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getdents 141 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::_newselect 142 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::flock 143 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::msync 144 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::readv 145 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::writev 146 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getsid 147 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::fdatasync 148 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::_sysctl 149 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mlock 150 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::munlock 151 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mlockall 152 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::munlockall 153 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_setparam 154 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_getparam 155 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_setscheduler 156 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_getscheduler 157 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_yield 158 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_get_priority_max 159 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_get_priority_min 160 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sched_rr_get_interval 161 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::nanosleep 162 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::mremap 163 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setresuid 164 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getresuid 165 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::query_module	166 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::poll 167 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::nfsservctl 168 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::setresgid 169 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getresgid 170 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::prctl 171 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigreturn 172 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigaction 173 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigprocmask 174 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigpending 175 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigtimedwait 176 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigqueueinfo 177 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::rt_sigsuspend 178 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::pread 179 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::pwrite 180 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::chown 181 (:address) )

(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::capget 183 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::capset 184 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sigaltstack 185 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::sendfile 186 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::getpmsg 187	 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::putpmsg 188	 () )
(define-syscall (logior platform-cpu-ppc platform-os-linux)  syscalls::vfork 189 () )

)
