# t30002 - Package dependency test case
## Config
```yaml
diagrams:
  t30002_package:
    type: package
    glob:
      - t30002.cc
    include:
      namespaces:
        - clanguml::t30002
    exclude:
      namespaces:
        - clanguml::t30002::detail
    using_namespace: clanguml::t30002
    plantuml:
      before:
        - "' t30002 test package diagram"
```
## Source code
File `tests/t30002/t30002.cc`
```cpp
#include <array>
#include <map>
#include <memory>
#include <string>
#include <vector>

namespace clanguml {
namespace t30002 {
namespace A::AA {
namespace A1 {
struct CA { };
}
namespace A2 {
template <typename T> struct CB {
    T cb;
};
}
namespace A3 {
struct CC { };
}
namespace A4 {
struct CD { };
}
namespace A5 {
struct CE { };
}
namespace A6 {
struct CF { };
}
namespace A7 {
struct CG { };
}
namespace A8 {
struct CH { };
}
namespace A9 {
struct CI { };
}
namespace A10 {
struct CJ { };
}
namespace A11 {
struct CK { };
}
namespace A12 {
struct CL { };
}
namespace A13 {
struct CM { };
}
namespace A14 {
struct CN { };
}
namespace A15 {
struct CO { };
}
namespace A16 {
struct CP { };
}
namespace A17 {
struct CR { };
}
namespace A18 {
enum class S { s1, s2, s3 };
}
}
namespace B::BB::BBB {
class CBA : public A::AA::A6::CF {
public:
    A::AA::A1::CA *ca_;
    A::AA::A2::CB<int> cb_;
    std::shared_ptr<A::AA::A3::CC> cc_;
    std::map<std::string, std::unique_ptr<A::AA::A4::CD>> *cd_;
    std::array<A::AA::A15::CO, 5> co_;
    static A::AA::A16::CP *cp_;

    CBA() = default;

    CBA(A::AA::A14::CN *cn) { }

    friend A::AA::A17::CR;

    template <typename... Item> CBA(std::tuple<Item...> &items) { }

    void ce(const std::vector<A::AA::A5::CE> /*ce_*/) { }

    std::shared_ptr<A::AA::A7::CG> cg() { return {}; }

    template <typename T>
    void ch(std::map<T, std::shared_ptr<A::AA::A8::CH>> &ch_)
    {
    }

    template <typename T>
    std::map<T, std::shared_ptr<A::AA::A9::CI>> ci(T * /*t*/)
    {
        return {};
    }

    A::AA::A18::S s;
};

void cj(std::unique_ptr<A::AA::A10::CJ> /*cj_*/) { }

std::unique_ptr<A::AA::A11::CK> ck() { return {}; }

template <typename T>
void cl(std::map<T, std::shared_ptr<A::AA::A12::CL>> & /*ch_*/)
{
}

template <typename T> std::map<T, std::shared_ptr<A::AA::A13::CM>> cm()
{
    return {};
}
}
} // namespace t30002
} // namespace clanguml

```
## Generated PlantUML diagrams
![t30002_package](./t30002_package.svg "Package dependency test case")
## Generated Mermaid diagrams
![t30002_package](./t30002_package_mermaid.svg "Package dependency test case")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "display_name": "A",
      "elements": [
        {
          "display_name": "AA",
          "elements": [
            {
              "display_name": "A1",
              "id": "9319733512138168425",
              "is_deprecated": false,
              "name": "A1",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 10,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A2",
              "id": "5562928906891852079",
              "is_deprecated": false,
              "name": "A2",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 13,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A3",
              "id": "10141672598406988224",
              "is_deprecated": false,
              "name": "A3",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 18,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A4",
              "id": "2394102540250964834",
              "is_deprecated": false,
              "name": "A4",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 21,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A5",
              "id": "9662114321733444169",
              "is_deprecated": false,
              "name": "A5",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 24,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A6",
              "id": "7192729013823215515",
              "is_deprecated": false,
              "name": "A6",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 27,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A7",
              "id": "4510893876404442092",
              "is_deprecated": false,
              "name": "A7",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 30,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A8",
              "id": "6713170737149747123",
              "is_deprecated": false,
              "name": "A8",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 33,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A9",
              "id": "13206681275667377960",
              "is_deprecated": false,
              "name": "A9",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 36,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A10",
              "id": "11625943530579009458",
              "is_deprecated": false,
              "name": "A10",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 39,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A11",
              "id": "3078670210975015891",
              "is_deprecated": false,
              "name": "A11",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 42,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A12",
              "id": "9596216299922841108",
              "is_deprecated": false,
              "name": "A12",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 45,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A13",
              "id": "4965517949692921527",
              "is_deprecated": false,
              "name": "A13",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 48,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A14",
              "id": "2414867811021691488",
              "is_deprecated": false,
              "name": "A14",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 51,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A15",
              "id": "4489917650621835488",
              "is_deprecated": false,
              "name": "A15",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 54,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A16",
              "id": "11323187065267284195",
              "is_deprecated": false,
              "name": "A16",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 57,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A17",
              "id": "4259502996240959994",
              "is_deprecated": false,
              "name": "A17",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 60,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            },
            {
              "display_name": "A18",
              "id": "3245698680931899146",
              "is_deprecated": false,
              "name": "A18",
              "namespace": "clanguml::t30002::A::AA",
              "source_location": {
                "column": 11,
                "file": "t30002.cc",
                "line": 63,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            }
          ],
          "id": "13357963775744683208",
          "is_deprecated": false,
          "name": "AA",
          "namespace": "clanguml::t30002::A",
          "source_location": {
            "column": 14,
            "file": "t30002.cc",
            "line": 9,
            "translation_unit": "t30002.cc"
          },
          "type": "namespace"
        }
      ],
      "id": "12347845725058053133",
      "is_deprecated": false,
      "name": "A",
      "namespace": "clanguml::t30002",
      "source_location": {
        "column": 11,
        "file": "t30002.cc",
        "line": 9,
        "translation_unit": "t30002.cc"
      },
      "type": "namespace"
    },
    {
      "display_name": "B",
      "elements": [
        {
          "display_name": "BB",
          "elements": [
            {
              "display_name": "BBB",
              "id": "18044170717259402844",
              "is_deprecated": false,
              "name": "BBB",
              "namespace": "clanguml::t30002::B::BB",
              "source_location": {
                "column": 18,
                "file": "t30002.cc",
                "line": 67,
                "translation_unit": "t30002.cc"
              },
              "type": "namespace"
            }
          ],
          "id": "15510893116990553883",
          "is_deprecated": false,
          "name": "BB",
          "namespace": "clanguml::t30002::B",
          "source_location": {
            "column": 14,
            "file": "t30002.cc",
            "line": 67,
            "translation_unit": "t30002.cc"
          },
          "type": "namespace"
        }
      ],
      "id": "1162422187714887647",
      "is_deprecated": false,
      "name": "B",
      "namespace": "clanguml::t30002",
      "source_location": {
        "column": 11,
        "file": "t30002.cc",
        "line": 67,
        "translation_unit": "t30002.cc"
      },
      "type": "namespace"
    }
  ],
  "name": "t30002_package",
  "package_type": "namespace",
  "relationships": [
    {
      "destination": "6713170737149747123",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "13206681275667377960",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "9319733512138168425",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "5562928906891852079",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "10141672598406988224",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "2394102540250964834",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "4489917650621835488",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "3245698680931899146",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "11323187065267284195",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "2414867811021691488",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "9662114321733444169",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "4510893876404442092",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "4259502996240959994",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "7192729013823215515",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "11625943530579009458",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "3078670210975015891",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "9596216299922841108",
      "source": "18044170717259402844",
      "type": "dependency"
    },
    {
      "destination": "4965517949692921527",
      "source": "18044170717259402844",
      "type": "dependency"
    }
  ],
  "using_namespace": "clanguml::t30002"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t30002</data>
  <node id="n0">
   <data key="nd2">A</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">AA</data>
     <data key="nd1">namespace</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd2">A1</data>
       <data key="nd1">namespace</data>
       <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n3">
       <data key="nd2">A2</data>
       <data key="nd1">namespace</data>
       <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n4">
       <data key="nd2">A3</data>
       <data key="nd1">namespace</data>
       <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n5">
       <data key="nd2">A4</data>
       <data key="nd1">namespace</data>
       <graph id="g6" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n6">
       <data key="nd2">A5</data>
       <data key="nd1">namespace</data>
       <graph id="g7" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n7">
       <data key="nd2">A6</data>
       <data key="nd1">namespace</data>
       <graph id="g8" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n8">
       <data key="nd2">A7</data>
       <data key="nd1">namespace</data>
       <graph id="g9" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n9">
       <data key="nd2">A8</data>
       <data key="nd1">namespace</data>
       <graph id="g10" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n10">
       <data key="nd2">A9</data>
       <data key="nd1">namespace</data>
       <graph id="g11" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n11">
       <data key="nd2">A10</data>
       <data key="nd1">namespace</data>
       <graph id="g12" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n12">
       <data key="nd2">A11</data>
       <data key="nd1">namespace</data>
       <graph id="g13" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n13">
       <data key="nd2">A12</data>
       <data key="nd1">namespace</data>
       <graph id="g14" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n14">
       <data key="nd2">A13</data>
       <data key="nd1">namespace</data>
       <graph id="g15" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n15">
       <data key="nd2">A14</data>
       <data key="nd1">namespace</data>
       <graph id="g16" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n16">
       <data key="nd2">A15</data>
       <data key="nd1">namespace</data>
       <graph id="g17" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n17">
       <data key="nd2">A16</data>
       <data key="nd1">namespace</data>
       <graph id="g18" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n18">
       <data key="nd2">A17</data>
       <data key="nd1">namespace</data>
       <graph id="g19" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n19">
       <data key="nd2">A18</data>
       <data key="nd1">namespace</data>
       <graph id="g20" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <node id="n20">
   <data key="nd2">B</data>
   <data key="nd1">namespace</data>
   <graph id="g21" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n21">
     <data key="nd2">BB</data>
     <data key="nd1">namespace</data>
     <graph id="g22" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n22">
       <data key="nd2">BBB</data>
       <data key="nd1">namespace</data>
       <graph id="g23" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n22" target="n9">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e1" source="n22" target="n10">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e2" source="n22" target="n2">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e3" source="n22" target="n3">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e4" source="n22" target="n4">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e5" source="n22" target="n5">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e6" source="n22" target="n16">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e7" source="n22" target="n19">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e8" source="n22" target="n17">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e9" source="n22" target="n15">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e10" source="n22" target="n6">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e11" source="n22" target="n8">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e12" source="n22" target="n18">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e13" source="n22" target="n7">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e14" source="n22" target="n11">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e15" source="n22" target="n12">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e16" source="n22" target="n13">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e17" source="n22" target="n14">
   <data key="ed0">dependency</data>
  </edge>
 </graph>
</graphml>

```
