#!/bin/bash

set -euo pipefail

cd $(dirname "${BASH_SOURCE[0]}")

# Do not replace with newer without dicussing! Intentionally using older clang-format-version.
tool=clang-format-8
# Using full config dumped with older clang format should produce more consistent result when some 
# people have slightly newer clang-format. 8 chosen because it is newest version available in Ubuntu 16.04 official repository.
output_file=../_clang-format


# Usage:
# modify scripts/_clang_format
# run this script
# compare the generated outptu with previous version

temp_file=_clang_format_new
echo -e "# Do not edit this file! Automatically generated using scripts/udate_clang_format.sh and scripts/_clang_format\n# See update_clang_format.sh for more information." > $temp_file
echo "# generated using `$tool --version`" >> $temp_file
$tool -style=file -dump-config >> $temp_file
mv $temp_file $output_file

echo Done
