; master library - MS-DOS - 30BIOS
;
; Description:
;	30sBIOS ( (c)lucifer ) 쐧
;
; Function/Procedures:
;	void bios30_setmode( int mode );
;		mode ... BIOS30_NORMAL, BIOS30_SPECIAL, BIOS30_RATIONAL, BIOS30_VGA
;			 BIOS30_FKEY, BIOS30_CW
;
; Parameters:
;	
;
; Returns:
;	
;
; Binding Target:
;	Microsoft-C / Turbo-C / Turbo Pascal
;
; Running Target:
;	MS-DOS (with 30bios or TT)
;
; Requiring Resources:
;	CPU: 8086
;
; Notes:
;	30bios/TT API݂Γ삵܂B݂Ȃ΂Ȃɂ܂B
;	30sBIOSRational[hT|[g̏ꍇ͐ݒ肪ɂȂB
;
; Assembly Language Note:
;	
;
; Compiler/Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Author:
;	ˏF
;	`
;
; Advice & Check:
;	
;
; Revision History:
;	93/ 4/10 Initial: master.lib/b30.asm
;	93/ 4/25 bios30_setline/getlineb30line.asmɕ
;	93/ 4/25 bios30_getversionb30ver.asmɕ
;	94/ 4/25 bios30_getmodeb30getmo.asmɕ
;	93/ 8/30 [M0.21] TT 1.0ɑΉc TŤÂo[Wł͌듮삷?
;	93/ 9/13 [M0.21] bios30_existp~, bios30_tt_existǉ
;	93/ 9/13 Initial: b30setmo.asm/master.lib 0.21
;	93/12/ 9 [M0.22] TT APIΉ
;	94/ 8/ 8 30sBIOS Ver1.2027i݁jɑΉ

	.MODEL SMALL
	include func.inc
	EXTRN BIOS30_TT_EXIST:CALLMODEL

	.CODE
;		mode ... {BIOS30_NORMAL,BIOS30_SPECIAL,BIOS30_RATIONAL,BIOS30_VGA}
;			|{BIOS30_FKEY, BIOS30_CW}
;			|{BIOS30_WIDELINE, BIOS30_NORMALLINE}
; ʃoCgmodify maskŁ[
; A0̂Ƃ͉ʃoCg𒼐ڐݒ肵܂B
; 30bios݂ȂΉ܂B
func BIOS30_SETMODE	; void bios30_setmode( int mode ) {
	_call	BIOS30_TT_EXIST
	and	AL,84h			; 30bios API, TT 1.50 API
	mov	BX,SP
	mode = (RETSIZE+0)*2
	mov	AX,SS:[BX+mode]
	jz	short SET_FAILURE
	jns	short SET_TT

	mov	BX,'30'+'s'
	not	AH
	test	AH,AH
	je	short SET_NOMODIFY
	mov	CX,AX
	mov	AH,0bh	; getmode
	int	18h
	and	AL,CH
	or	AL,CL
SET_NOMODIFY:
	mov	AH,0ah
TT_RETURN:
	int	18h
SET_FAILURE:
	ret	2

;		30bios    1.20			TT
;		0..0.... 00.0.... normal		.00.0...
;		0..1.... 00.1.... special (View)	.01.1...
;		1..1.... 11.1.... vga     (All)		.10.1...
;		........ 01.1.... rational(Layer)	.00.1...
;
;		..0..... ..0..... function key		........
;		..1..... ..1..... CW			........
;
;		.......0 .......0 normalline		.......0
;		.......1 .......1 wideline		.......1

;
; ȉ̎菇́Abit7(vga)𗎂ƂƂ(->special)A8000hnĂ
; normal modeɐݒ肵Ă܂肪B
; normal modêƂɎŝȂ炢̂B܂ÂƂ̓
; 30biosł͒`ĂȂ̂ŁA9010hŐݒ肵ĂȂƍ邩炢B
;
SET_TT:
	mov	dx,ax		; dx [h
	and	dx,0101h

	and	ax,0d0d0h	; ʏԂTTpɂ
	jz	short TT_NO_MODE
	shr	ax,1
	xor	al,20h
	or	dx,ax
;	test	dl,40h		; | `ĂlO
;	jz	TT_NO_ALL	; | ȉʏԂݒ肳\Ȃ
;	and	dl,NOT 20h	; | ̃Rg͂
TT_NO_ALL:
TT_NO_MODE:
	mov	bx,'TT'		; [hݒ
	mov	ax,1802h
	int	18h
	not	dh
	and	al,dh
	or	al,dl
	jmp	short TT_RETURN
endfunc			; }

END
