; master library - PC-9801 - RS-232C - READ SIGNAL
;
; Description:
;	RS-232C̊eԂ𓾂
;
; Function/Procedures:
;	int sio_read_signal( int ch ) ;
;	int sio_read_err( int ch ) ;
;	int sio_read_dr( int ch ) ;
;
; Parameters:
;	ch	RS-232C|[g̃`lԍ( 0={̓ )
;
; Returns:
;	sio_read_signal	SIO_CI(80h) Čo
;	sio_read_signal SIO_CS(40h) M
;	sio_read_signal SIO_CD(20h) LAo
;	sio_read_err	SIO_PERR    peBG[
;	sio_read_err	SIO_OERR    I[o[G[
;	sio_read_err	SIO_FERR    t[~OG[
;	sio_read_dr	!=0         DTRo
;
; Binding Target:
;	Microsoft-C / Turbo-C / Turbo Pascal
;
; Running Target:
;	PC-9801
;
; Requiring Resources:
;	CPU: 8086
;
; Notes:
;	
;
; Assembly Language Note:
;	
;
; Compiler/Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Author:
;	ˏF
;
; Revision History:
;	93/ 7/23 Initial: siosignal.asm/master.lib 0.20
;	93/ 9/22 [M0.21] sio_read_signal̃rbg]YC

	.MODEL SMALL
	include func.inc

	.CODE

func SIO_READ_SIGNAL	; sio_read_signal() {
	in	AL,33h
	not	AX
	and	AX,0e0h
	ret	2
endfunc		; }

func SIO_READ_ERR	; sio_read_err() {
	in	AL,32h
	and	AX,38h
	ret	2
endfunc		; }

func SIO_READ_DR	; sio_read_dr() {
	in	AL,32h
	and	AX,80h
	ret	2
endfunc		; }

END
