note
	description: "String Manipulator String Manipulator Library"
	generator: "Automatically generated by the EiffelCOM Wizard."

class
	STRING_MANIPULATOR_PROXY

inherit
	ISTRING_INTERFACE

	ECOM_QUERIABLE

create
	make,
	make_from_other,
	make_from_pointer

feature {NONE}  -- Initialization

	make
			-- Creation
		do
			initializer := ccom_create_string_manipulator_coclass
			item := ccom_item (initializer)
		end

	make_from_pointer (a_object: POINTER)
			-- Make from pointer
		do
			initializer := ccom_create_string_manipulator_coclass_from_pointer(a_object)
			item := ccom_item (initializer)
		end

feature -- Access

	string: STRING
			-- Manipulated string
		do
			Result := ccom_string (initializer)
		end

feature -- Basic Operations

	set_string (a_string: STRING)
			-- Set manipulated string with `a_string'.
			-- `a_string' [in].
		do
			ccom_set_string (initializer, a_string)
		end

	replace_substring (s: STRING; start_pos: INTEGER; end_pos: INTEGER)
			-- Copy the characters of `s' to positions `start_pos' .. `end_pos'.
			-- `s' [in].
			-- `start_pos' [in].
			-- `end_pos' [in].
		do
			ccom_replace_substring (initializer, s, start_pos, end_pos)
		end

	prune_all (c: CHARACTER)
			-- Remove all occurrences of `c'.
			-- `c' [in].
		do
			ccom_prune_all (initializer, c)
		end

feature {NONE}  -- Implementation

	delete_wrapper
			-- Delete wrapper
		do
			ccom_delete_string_manipulator_coclass(initializer)
		end

feature {NONE}  -- Externals

	ccom_string (a_object: POINTER): STRING
			-- Manipulated string
		external
			"C++ [ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"](): EIF_REFERENCE"
		end

	ccom_set_string (a_object: POINTER; a_string: STRING)
			-- Set manipulated string with `a_string'.
		external
			"C++ [ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"](EIF_OBJECT)"
		end

	ccom_replace_substring (a_object: POINTER; s: STRING; start_pos: INTEGER; end_pos: INTEGER)
			-- Copy the characters of `s' to positions `start_pos' .. `end_pos'.
		external
			"C++ [ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"](EIF_OBJECT,EIF_INTEGER,EIF_INTEGER)"
		end

	ccom_prune_all (a_object: POINTER; c: CHARACTER)
			-- Remove all occurrences of `c'.
		external
			"C++ [ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"](EIF_CHARACTER)"
		end

	ccom_create_string_manipulator_coclass: POINTER
			-- Creation
		external
			"C++ [new ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"]()"
		end

	ccom_delete_string_manipulator_coclass (a_pointer: POINTER)
			-- Release resource
		external
			"C++ [delete ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"]()"
		end

	ccom_create_string_manipulator_coclass_from_pointer (a_pointer: POINTER): POINTER
			-- Create from pointer
		external
			"C++ [new ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"](IUnknown *)"
		end

	ccom_item (a_object: POINTER): POINTER
			-- Item
		external
			"C++ [ecom_StringManipulatorLib::StringManipulator %"ecom_StringManipulatorLib_StringManipulator.h%"](): EIF_POINTER"
		end

end -- STRING_MANIPULATOR_PROXY


