case $CONFIG in
'')
	if test ! -f config.sh; then
		(echo "Can't find config.sh."; exit 1)
	fi 2>/dev/null
	. ./config.sh
	;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting "."/Makefile (with variable substitutions)"
$spitshell >Makefile <<!GROK!THIS!
########################################################################
# Makefile generated from Makefile.SH on $DATE

SHELL = /bin/sh
AR = ar rc
CC = $cc
CTAGS = ctags
CFLAGS = $optimize $ccflags $large -I$rt_include -I"../spec/include" -DSQLITE_THREADSAFE=0 -DSQLITE_OMIT_LOAD_EXTENSION=1
MTCFLAGS = $optimize $mtccflags $large -I$rt_include -I"../spec/include" -DSQLITE_THREADSAFE=1 -DSQLITE_OMIT_LOAD_EXTENSION=1
SHAREDLINK = $sharedlink
LDSHAREDFLAGS = $ldsharedflags
SHAREDLIBS = $sharedlibs
LN = $ln
MAKE = $make
MKDEP = $mkdep \$(DPFLAGS) --
RANLIB = $ranlib
MKDIR = $mkdir -p
MV = $mv
RM = $rm -f
PLATFORM = $ISE_PLATFORM
########################################################################
# Automatically generated parameters -- do not edit

SOURCES =  \$(LSRCS)

ESQLITE_LIBS = libesqlite.a libmtesqlite.a libesqlite.so libmtesqlite.so
########################################################################
# New suffixes and associated building rules -- edit with care


!GROK!THIS!
$spitshell >>Makefile <<'!NO!SUBS!'

all: $(ESQLITE_LIBS)
	$(MKDIR) ../spec/$(PLATFORM)/lib
	$(MV) $? ../spec/$(PLATFORM)/lib
	$(MAKE) clobber

SMODE = esqlite.c sqlite3.c

LSRCS = $(SMODE)

MT_OBJECTS = \
	mtesqlite.o \
	mtsqlite3.o

OBJECTS = \
	esqlite.o \
	sqlite3.o

esqlite.o: esqlite.c
	$(CC) -c $(CFLAGS) $? -o $@

sqlite3.o: sqlite3.c
	$(CC) -c $(CFLAGS) $? -o $@

libesqlite.a: $(OBJECTS)
	$(RM) $@
	$(AR) $@ $(OBJECTS)
	$(RANLIB) $@

libesqlite.so: $(OBJECTS)
	$(RM) $@
	$(SHAREDLINK) $(LDSHAREDFLAGS) $@ $(OBJECTS) $(SHAREDLIBS)

mtesqlite.o: esqlite.c
	$(CC) -c $(MTCFLAGS) $? -o $@

mtsqlite3.o: sqlite3.c
	$(CC) -c $(MTCFLAGS) $? -o $@

libmtesqlite.a: $(MT_OBJECTS)
	$(RM) $@
	$(AR) $@ $(MT_OBJECTS)
	$(RANLIB) $@

libmtesqlite.so: $(MT_OBJECTS)
	$(RM) $@
	$(SHAREDLINK) $(LDSHAREDFLAGS) $@ $(MT_OBJECTS) $(SHAREDLIBS)

########################################################################
# Common rules for all Makefiles -- do not edit

emptyrule::

clean: local_clean
realclean: local_realclean
clobber: local_clobber

local_clean::
	$(RM) core *~ *.o *.so *.a

local_realclean:: local_clean

local_clobber:: local_realclean
	$(RM) Makefile config.sh

Makefile: Makefile.SH
	/bin/sh Makefile.SH

tags::
	$(CTAGS) -w *.[ch]
	$(CTAGS) -xw *.[ch] > tags

local_clobber::
	$(RM) tags

########################################################################
# Dependencies generated by make depend
# DO NOT DELETE THIS LINE -- make depend relies on it

# Put nothing here or make depend will gobble it up
.FORCE_DEPEND::
	@echo "You must run 'make depend' in $(TOP) first."; exit 1
!NO!SUBS!
chmod 644 Makefile
$eunicefix Makefile

