searchData={"items":[{"type":"extras","title":"Jinterface Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Jinterface Release Notes\n\nThis document describes the changes made to the Jinterface application.","ref":"notes.html"},{"type":"extras","title":"Jinterface 1.14.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-14-1"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.14 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-14"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- As announced since the release of OTP 24, support for:\n\n  - version 4 node container types in the external term format are now\n    mandatory. That is, references supporting up to 5 32-bit integer\n    identifiers, and process and port identifiers with support for 64-bit data\n    storage. The distribution flag\n    [`DFLAG_V4_NC`](`e:erts:erl_dist_protocol.md#DFLAG_V4_NC`) is therefor now\n    also mandatory. OTP has since OTP 24 supported this. Also note that the\n    external format produced by `term_to_binary()` and `term_to_iovec()` will\n    unconditionally produce pids, ports, and references supporting this larger\n    format.\n  - the [new link protocol](`e:erts:erl_dist_protocol.md#new_link_protocol`)\n    introduced in OTP 23.3 is now mandatory. The distribution flag\n    [`DFLAG_UNLINK_ID`](`e:erts:erl_dist_protocol.md#DFLAG_UNLINK_ID`) is\n    therefor now also mandatory.\n\n  Due to the above, OTP 26 nodes will refuse to connect to OTP nodes from\n  releases prior to OTP 24.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18140 Aux Id: PR-6072","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.13.2 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Accept connection setup from OTP 23 and 24 nodes that are not using epmd.\n\n  Own Id: OTP-18404 Aux Id: GH-6595, PR-6625","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.13.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-13-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Fix javadoc build error by adding option `-encoding UTF-8`.\n\n  Own Id: OTP-18215 Aux Id: PR-6154","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.13 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-13"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- The following distribution flags are now mandatory: `DFLAG_BIT_BINARIES`,\n  `DFLAG_EXPORT_PTR_TAG`, `DFLAG_MAP_TAGS`, `DFLAG_NEW_FLOATS`, and\n  `DFLAG_FUN_TAGS`. This mainly concerns libraries or application that implement\n  the distribution protocol themselves.\n\n  Own Id: OTP-17318 Aux Id: PR-4972\n\n- Removed use of node creation value zero as a wildcard. Also prevent zero from\n  being used as creation by `erl_interface` and `jinterface` nodes.\n\n  Own Id: OTP-17682 Aux Id: PR-5347\n\n- Add new abstract class `OtpGenericTransportFactory` to allow implementation of\n  any transport protocol without dependency on epmd.\n\n  Own Id: OTP-17961 Aux Id: PR-4839","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.12.2 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-12-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Fix bug in `OtpOutputStream.write_pid/4` and `write_ref/3` causing faulty\n  encodig. Bug exists since OTP 23.0.\n\n  Own Id: OTP-17887 Aux Id: ERIERL-750, PR-5640","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.12.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-12-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Fixed rare race bug that could cause NullPointerException on local close of\n  connection.\n\n  Own Id: OTP-17478 Aux Id: PR-4837","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.12 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-12"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Accept 64-bit process identifiers from external nodes. This is the first step\n  in an upgrade path toward using 64-bit pids in a future OTP release.\n\n  Own Id: OTP-16720 Aux Id: PR-2680\n\n- Accept references up to a size of 160-bits from remote nodes. This is the\n  first step in an upgrade path toward using references up to 160-bits in a\n  future OTP release.\n\n  Own Id: OTP-17005 Aux Id: OTP-16718\n\n- Accept 64-bit port identifiers from external nodes. This is the first step in\n  an upgrade path toward using 64-bit port identifiers in a future OTP release.\n\n  Own Id: OTP-17007\n\n- Make `OtpErlangExternalFun`'s fields `module`, `function` and `arity` public.\n\n  Own Id: OTP-17170 Aux Id: PR-3005","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.11.1.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-11-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Fix bug in `OtpOutputStream.write_pid/4` and `write_ref/3` causing faulty\n  encodig. Bug exists since OTP 23.0.\n\n  Own Id: OTP-17887 Aux Id: ERIERL-750, PR-5640","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.11.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-11-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- A [new link protocol](`e:erts:erl_dist_protocol.md#new_link_protocol`) has\n  been introduced which prevents links from ending up in an inconsistent state\n  where one participant considers itself linked while the other doesn't. This\n  bug has always existed in the distributed case, but has since OTP 21 also\n  existed in the node local case since the distributed link protocol then was\n  adopted also for node local links. The bug could, however, only trigger if\n  both participants operated on the link simultaneously.\n\n  Own Id: OTP-17127","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.11 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-11"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Increased size of node incarnation numbers (aka \"creation\"), from 2 bits to 32\n  bits. This will reduce the risk of pids/ports/refs, from different node\n  incarnation with the same name, being mixed up.\n\n  Own Id: OTP-15603\n\n- Improved node connection setup handshake protocol. Made possible to agree on\n  protocol version without dependence on `epmd` or other prior knowledge of peer\n  node version. Also added exchange of node incarnation (\"creation\") values and\n  expanded the distribution capability flag field from 32 to 64 bits.\n\n  Own Id: OTP-16229","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.10.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-10-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Replaced deprecated   with   in documentation.\n\n  Own Id: OTP-16050","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.10 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- All incorrect (that is, all) uses of \"can not\" has been corrected to \"cannot\"\n  in source code comments, documentation, examples, and so on.\n\n  Own Id: OTP-14282 Aux Id: PR-1891","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Added support to receive export funs (`fun M:F/A`).\n\n  Before this change, export funs sent to a jinterface node were encoded using\n  an undocumented fallback tuple format `{M,F}`. Existing jinterface\n  implementations expecting these tuples must be changed to instead use the\n  existing `OtpErlangExternalFun` class.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15774 Aux Id: OTP-15712","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.9.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.9 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-9"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Add module package name for Java 9\n\n  Own Id: OTP-14844","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.8.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.8 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-8"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Remove generation of atoms in old latin1 external format in the distribution\n  between erlang nodes, `erl_interface`, and `jinterface`. The new utf8 format\n  for atoms was introduced in OTP R16. An OTP 20 node can therefore not connect\n  to nodes older than R16.\n\n  Atoms that can be encoded using latin1 are still encoded by `term_to_binary()`\n  using latin1 encoding. Note that all atoms will by default be encoded using\n  utf8 in a future Erlang/OTP release. For more information see the\n  documentation of `erlang:term_to_binary/2`.\n\n  Own Id: OTP-14337","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.7.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-7-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Update build scripts to not make assumptions about where env, cp and perl are\n  located.\n\n  Own Id: OTP-13800","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.7 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Fix Jinterface build on Maven\n\n  Own Id: OTP-13482","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Handle terms (pids,ports and refs) from nodes with a 'creation' value larger\n  than 3. This is a preparation of the distribution protocol to allow OTP 19\n  nodes to correctly communicate with future nodes (20 or higher). The\n  'creation' value differentiates different incarnations of the same node\n  (name).\n\n  Own Id: OTP-13488","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.6.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Add missing Term tag matching switch statement that was missing an external\n  fun tag.\n\n  Own Id: OTP-13106\n\n- fixed writing small compressed values.\n\n  Own Id: OTP-13165","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.6 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Reformat the sources for JInterface uniformly and according to the standard\n  Java style guidelines. Provide description of the rules applied in Eclipse\n  format (for other editors one can check the settings against these).\n\n  In short, the formatting style is: _ indentation uses only spaces; each level\n  is 4 positions _ no trailing whitespace _ mostly default Java style formatting\n  (any difference is minor) _ always use \\{\\} blocks \\* use 'final' as much as\n  possible\n\n  Own Id: OTP-12333\n\n- Remove extra @param in javadoc as this gives an error when building the docs\n  in java 1.8\n\n  Own Id: OTP-12746","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Add basic transport factory implementation. This makes possible creating\n  connections between nodes using ssh channels for example.\n\n  Own Id: OTP-12686\n\n- Add Jinterface generic match and bind methods to provide low level interface\n  base methods sufficient for variety of higher level pattern matching/variable\n  binding implementations.\n\n  Own Id: OTP-12691\n\n- Minimal Java version is now 1.6\n\n  Own Id: OTP-12715","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.12 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- handle empty .erlang.cookie without crashing and OtpErlangList.clone must not\n  return null\n\n  Own Id: OTP-12210\n\n- This fixes all the compilation warnings in the Java code\n\n  Own Id: OTP-12211","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Added an .appup file for the application.\n\n  Own Id: OTP-12358 Aux Id: OTP-12178","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.11 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Added a `.app` file for the application.\n\n  Own Id: OTP-12178","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.5.10 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Array now show meaningful values in exceptions.\n\n  Own Id: OTP-12049\n\n- Documentation improvements.\n\n  Own Id: OTP-12050\n\n- Include the cause when raising a new IOException, which should make the reason\n  for the exception clearer.\n\n  Own Id: OTP-12075\n\n- Arrays (here: md5 and freeVars) must not be compared with equals, which is\n  broken (compares identity).\n\n  Own Id: OTP-12121","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.5.9 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-9"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Implement support for Maps\n\n  The API and implementation are simplistic, like for lists and tuples, using\n  arrays and without any connection to java.util.Map. (Thanks to Vlad\n  Dumitrescu)\n\n  Own Id: OTP-11703","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.8 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Fixed a bug in OtpErlangTuple constructor. Thanks to Vlad Dumitrescu.\n\n  Own Id: OTP-10819\n\n- Fixed finding cookie file on windows. Thanks to Vlad Dumitrescu\n\n  Own Id: OTP-10821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Don't compress external binary format if this increases the size. Thanks to\n  Nico Kruber.\n\n  Own Id: OTP-10822","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.7 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- fix reading compressed binary terms from Java (Thanks to Nico Kruber)\n\n  Own Id: OTP-10505\n\n- OtpEpmd.lokupNames() no longer hangs when badly configured (Thanks to Vlad\n  Dumitrescu)\n\n  Own Id: OTP-10579","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Limited support for unicode atoms in the external format and in the internal\n  representation of the vm. This is a preparative feature in order to support\n  communication with future releases of Erlang/OTP that may create unicode\n  atoms.\n\n  Own Id: OTP-10753","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.6 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Correct spelling of registered (Thanks to Richard Carlsson)\n\n  Own Id: OTP-9925\n\n- Java 1.5 has a bug where detecting codepoint offsets in strings that are\n  created by String.substring() gives wrong results. The new implementation uses\n  a different method, avoiding the issue. (Thanks to Vlad Dumitrescu)\n\n  Own Id: OTP-9927\n\n- Improve error message when creating a too long OtpErlangAtom. Also print the\n  value that we tried to use for the atom. (Thanks to Vlad Dumitrescu)\n\n  Own Id: OTP-9928","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.5.5 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- JInterface: improve OtpOutputStream buffer allocation\n\n  Previously, the buffer was increased linearly by 2048 bytes. I now propose to\n  use an exponential increase function (similar to Javas ArrayList, e.g. always\n  at least +50%). This significantly increases performance of e.g. doRPC for\n  large parameters. (Thanks to Nico Kruber)\n\n  Own Id: OTP-9806","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.5.4 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Some malformed distribution messages could cause VM to crash, this is now\n  corrected.\n\n  Own Id: OTP-8993","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.5.3.2 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-3-2"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- The OtpMbox class did not have a hash() method, which it should have because\n  it overrides equals().\n\n  Own Id: OTP-8854","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.3.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-3-1"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- An pom.xml file is now generated. (Thanks to Gabor Liptak.)\n\n  Own Id: OTP-8841","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.3 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-3"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- The documentation is now possible to build in an open source environment after\n  a number of bugs are fixed and some features are added in the documentation\n  build process.\n\n  \\- The arity calculation is updated.\n\n  \\- The module prefix used in the function names for bif's are removed in the\n  generated links so the links will look like\n  \"http://www.erlang.org/doc/man/erlang.html#append_element-2\" instead of\n  \"http://www.erlang.org/doc/man/erlang.html#erlang:append_element-2\".\n\n  \\- Enhanced the menu positioning in the html documentation when a new page is\n  loaded.\n\n  \\- A number of corrections in the generation of man pages (thanks to Sergei\n  Golovan)\n\n  \\- The legal notice is taken from the xml book file so OTP's build process can\n  be used for non OTP applications.\n\n  Own Id: OTP-8343","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.2 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-2"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Many Erlang classes, e.g. OtpErlangRef, was missing an implementation of the\n  hashCode() method, making it futile to put them in hash structures such as\n  HashMap. Bug and patch provided by Paul Guyot. We extended the patch to all\n  classes and improved (?) on the hash algorithm.\n\n  Own Id: OTP-7899","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- jinterface uses the new environment variable ERL_EPMD_PORT the same way that\n  erl, epmd and erl_interface do since R13A.\n\n  Own Id: OTP-7885","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.5 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-5"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- A number of fixes and improvements from the ErlIDE group; Vlad Dumitrescu and\n  Jakob Cederlund: JDK 1.5 is now a minimal requirement for building Jinterface.\n  New method: OtpEpmd.lookupNames. OtpErlangList is now iterable. Non-proper\n  lists are now allowed - you have to test if a list is proper or not.\n  Non-proper lists can also be created. New methods: isProper, getHead, getTail\n  and getNthTail. The get tail methods creates a sublist object that re-uses the\n  original list. OtpErlangPid is now Comparable. Empty atoms can now be\n  constructed, a missing feature pointed out by Sebastien Boisgerault on\n  erlang-questions.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7832","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.4.2 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-4-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- A bug when Jinterface did not detect remote node disconnects has been\n  corrected.\n\n  Own Id: OTP-7624","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.4.1 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Jinterface has been fixed to use the loopback interface when connecting to the\n  Erlang Port Mapper Daemon - epmd. This facilitates firewall configuration and\n  saves resources.\n\n  Own Id: OTP-7103\n\n- Jinterface now refuses to connect to another node that does not agree on the\n  other node's name. This has been a problem in that a connection was set up,\n  but not used on a following send, which caused a second erroneous connection\n  attempt to fail since the other (Erlang) node rejects a connection due to name\n  disagreement.\n\n  Problem reported and dissected by Alexander Lamb\n\n  Own Id: OTP-7330","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Jinterface 1.4 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-4"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Jinterface has been updated to handle compressed terms, bitstring, new (IEEE)\n  floats and bignums. This has caused a few incompatibilities.\n\n  com.ericsson.otp.erlang.OtpOutputStream now extends\n  java.io.ByteArrayOutputStream, previously java.lang.Object, and hence the\n  method size() now return the number of bytes in the stream as dictated by the\n  new parent class and not the buffer length as before. The new method length()\n  returns what the old size() did return. The method count() is deprecated as it\n  returns the same as the new size().\n\n  com.ericsson.otp.erlang.OtpErlangLong now can handle larger values than\n  64-bit. Previously when larger than 64-bit integers were sent to a Jinterface\n  node, it caused an com.ericsson.otp.erlang.OtpDecodeException. Now the integer\n  is accepted, but the return value of longValue() is silently truncated, as\n  opposed to the return value of intValue() that now and previously raises an\n  com.ericsson.otp.erlang.OtpRangeException for unrepresentable values. The new\n  methods isLong() and isULong() can be used to determine if the value fits in a\n  long.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-6809","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.3 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- `OtpMbox.receive()` and `OtpMbox.receive(long timeout)` can now throw\n  `OtpErlangDecodeException` if the received message cannot be decoded. `null`\n  is now only returned from `OtpMbox.receive(long timeout)` if a timeout occurs.\n  `OtpMbox.receive()` will never return `null`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-3932 Aux Id: seq5196\n\n- Strings longer than 65535 bytes were encoded wrong by jinterface.\n\n  Own Id: OTP-4883 Aux Id: OTP-4865\n\n- Misc bugfixes:\n\n  - A node pinging itself does no longer cause the java program to hang.\n  - `OtpMbox.close()` uses exit reason `'normal'` (atom) instead of `\"normal\"`\n    (string).\n  - Added `OtpNode.closeMbox(OtpMbox mbox, OtpErlangObject reason)`.\n  - Added `OtpMbox.exit(OtpErlangObject reason)` and\n    `OtpMbox.exit(String reason)`.\n  - Added `OtpMbox.exit(OtpErlangPid to, OtpErlangObject reason)`.\n  - `OtpMbox.exit(OtpErlangPid to, String reason)` is now equivalent to\n    `OtpMbox.exit(to, new OtpErlangAtom(reason))`.\n  - Exit signals from an Erlang node can now contain any erlang term as reason,\n    not only atoms.\n\n  Own Id: OTP-5088\n\n- For java versions 1.3.1 or later, `localStatus` was not sent to registered\n  status handler when `OtpNode.close()` was called. This is now corrected.\n\n  Own Id: OTP-5169","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Jinterface Release Notes","doc":"- Process identifiers and port identifiers have been made more unique.\n  Previously 18 bits were used as id in the internal representation of process\n  and port identifiers. Now 28 bits are used.\n\n  The maximum limit on the number of concurrently existing processes due to the\n  representation of pids has been increased to 268435456 processes. The same is\n  true for ports. This limit will at least on a 32-bit architecture be\n  impossible to reach due to memory shortage.\n\n  _NOTE:_ By default, the `ERTS`, and the `erl_interface`, `ei`, and\n  `jinterface` libraries are now only guaranteed to be compatible with other\n  Erlang/OTP components from the same release. It is possible to set each\n  component in compatibility mode of an earlier release, though. See the\n  documentation for respective component on how to set it in compatibility mode.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-4968 Aux Id: OTP-4196","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Jinterface 1.2.1.2 - Jinterface Release Notes","doc":"","ref":"notes.html#jinterface-1-2-1-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Jinterface Release Notes","doc":"- Output of Java long was truncated to 32 bits. IDL long long and unsigned long\n  long could not be used in a struct for the Java backend. All unsigned integer\n  types for the Java backend had broken marshalling for large values. These bugs\n  has now been fixed.\n\n  Own Id: OTP-4763 Aux Id: seq8024","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"The Jinterface Package","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# The Jinterface Package\n\nThe [Jinterface] package provides a set of tools for communication with Erlang processes.\nIt can also be used for communication with other Java processes using the same package,\nas well as C processes using the Erl_Interface library.\n\nThe set of classes in the package can be divided into two categories: those that\nprovide the actual communication, and those that provide a Java representation\nof the Erlang data types. The latter are all subclasses of [`OtpErlangObject`], and\nthey are identified by the `OtpErlang` prefix.\n\nSince this package provides a mechanism for communicating with Erlang, message\nrecipients can be Erlang processes or instances of\n`com.ericsson.otp.erlang.OtpMbox`, both of which are identified with pids and\npossibly registered names. When pids or mailboxes are mentioned as message\nsenders or recipients in this section, it should assumed that even Erlang\nprocesses are included, unless specified otherwise. The classes in\n[Jinterface] support the following:\n\n- manipulation of data represented as Erlang data types\n- conversion of data between Java and Erlang formats\n- encoding and decoding of Erlang data types for transmission or storage\n- communication between Java nodes and Erlang processes\n\nIn the following sections, these topics are described:\n\n- mapping of Erlang types to Java\n- encoding, decoding, and sending Erlang terms\n- connecting to a distributed Erlang node\n- using nodes, mailboxes and EPMD\n- sending and receiving Erlang messages and data\n- remote procedure calls\n- linking to remote processes\n- compiling your code for use with Jinterface\n- tracing message flow","ref":"jinterface_users_guide.html"},{"type":"extras","title":"Mapping of Basic Erlang Types to Java - The Jinterface Package","doc":"This section describes the mapping of Erlang basic types to Java.\n\n| Erlang type          | Java type          |\n| -------------------- | ------------------ |\n| atom                 | [`OtpErlangAtom`]    |\n| binary               | [`OtpErlangBinary`]  |\n| floating point types | [`OtpErlangFloat`] or [`OtpErlangDouble`], depending on the floating point value size |\n| integral types       | One of [`OtpErlangByte`], [`OtpErlangChar`], [`OtpErlangShort`], [`OtpErlangUShort`], [`OtpErlangInt`], [`OtpErlangUInt`] or [`OtpErlangLong`], depending on the integral value size and sign |\n| list                 | [`OtpErlangList`]    |\n| pid                  | [`OtpErlangPid`]     |\n| port                 | [`OtpErlangPort`]    |\n| ref                  | [`OtpErlangRef`]     |\n| tuple                | [`OtpErlangTuple`]   |\n| map                  | [`OtpErlangMap`]     |\n| term                 | [`OtpErlangObject`]  |\n\n_Table: Mapping of Erlang basic types to Java_","ref":"jinterface_users_guide.html#mapping-of-basic-erlang-types-to-java"},{"type":"extras","title":"Special Mapping Issues - The Jinterface Package","doc":"The atoms `true` and `false` are special atoms, used as boolean values. The\nclass [`OtpErlangBoolean`] can be used to represent these.\n\nLists in Erlang are also used to describe sequences of printable characters\n(strings). A convenience class [`OtpErlangString`] is provided to represent\nErlang strings.","ref":"jinterface_users_guide.html#special-mapping-issues"},{"type":"extras","title":"Nodes - The Jinterface Package","doc":"A node as defined by Erlang/OTP is an instance of the Erlang Runtime System, a\nvirtual machine roughly equivalent to a JVM. Each node has a unique name in the\nform of an identifier composed partly of the hostname on which the node is\nrunning, e.g \"gurka@sallad.com\". Several such nodes can run on the same host as\nlong as their names are unique. The class [`OtpNode`] represents an Erlang\nnode.\n\nIt is created with a name and optionally a TCP/IP socket port number on which it\nlistens for incoming connections. By default before creating an instance of\n[`OtpNode`], ensure that Epmd is running on the host machine. See the Erlang\ndocumentation for more information about [Epmd](`e:erts:epmd_cmd.md`).\n\nIn this example, the host name is appended automatically to the identifier, and\nthe port number is chosen by the underlying system:\n\n```java\nOtpNode node = new OtpNode(\"gurka\");\n```\n\nIt is also possible to use alternative communication (or distribution) protocols\nwithout Epmd by switching to a custom transport factory extending the\nOtpGenericTransportFactory abstract class, for example based on Unix Domain\nSockets instead of the default TCP/IP sockets.\n\nIn this example, the host name is appended automatically to the identifier and a\ncustom transport factory is used:\n\n```java\nOtpGenericTransportFactory customFactory = new MyCustomFactory();\nOtpNode node = new OtpNode(\"gurka\", customFactory);\n```","ref":"jinterface_users_guide.html#nodes"},{"type":"extras","title":"Mailboxes - The Jinterface Package","doc":"Erlang processes running on an Erlang node are identified by process identifiers\n(pids) and, optionally, by registered names unique within the node. Each Erlang\nprocess has an implicit mailbox that is used to receive messages; the mailbox is\nidentified with the pid of the process.\n\nJinterface provides a similar mechanism with the class [`OtpMbox`], a mailbox that can\nbe used to send and receive messages asynchronously. Each OtpMbox is identified\nwith a unique pid and , optionally, a registered name unique within the\n[`OtpNode`].\n\nApplications are free to create mailboxes as necessary. This is done as follows:\n\n```java\nOtpMbox mbox = node.createMbox();\n```\n\nThe mailbox created in the above example has no registered name, although it\ndoes have a pid. The pid can be obtained from the mailbox and included in\nmessages sent from the mailbox, so that remote processes are able to respond.\n\nAn application can register a name for a mailbox, either when the mailbox is\ninitially created:\n\n```java\nOtpMbox mbox = node.createMbox(\"server\");\n```\n\nor later on, as necessary:\n\n```java\nOtpMbox mbox = node.createMbox();\nmbox.registerName(\"server\");\n```\n\nRegistered names are usually necessary in order to start communication, since it\nis impossible to know in advance the pid of a remote process. If a well-known\nname for one of the processes is chosen in advance and known by all\ncommunicating parties within an application, each mailbox can send an initial\nmessage to the named mailbox, which then can identify the sender pid.","ref":"jinterface_users_guide.html#mailboxes"},{"type":"extras","title":"Connections - The Jinterface Package","doc":"It is not necessary to explicitly set up communication with a remote node.\nSimply sending a message to a mailbox on that node will cause the OtpNode to\ncreate a connection if one does not already exist. Once the connection is\nestablished, subsequent messages to the same node will reuse the same\nconnection.\n\nIt is possible to check for the existence of a remote node before attempting to\ncommunicate with it. Here we send a ping message to the remote node to see if it\nis alive and accepting connections:\n\n```java\nif (node.ping(\"remote\",2000)) {\n  System.out.println(\"remote is up\");\n}\nelse {\n  System.out.println(\"remote is not up\");\n}\n```\n\nIf the call to ping() succeeds, a connection to the remote node has been\nestablished. Note that it is not necessary to ping remote nodes before\ncommunicating with them, but by using ping you can determine if the remote\nexists before attempting to communicate with it.\n\nConnections are only permitted by nodes using the same security cookie. The\ncookie is a short string provided either as an argument when creating OtpNode\nobjects, or found in the user's home directory in the file `.erlang.cookie`.\nWhen a connection attempt is made, the string is used as part of the\nauthentication process. If you are having trouble getting communication to work,\nuse the trace facility (described later in this document) to show the connection\nestablishment. A likely problem is that the cookies are different.\n\nConnections are never broken explicitly. If a node fails or is closed, a\nconnection may be broken however.","ref":"jinterface_users_guide.html#connections"},{"type":"extras","title":"Transport Factory - The Jinterface Package","doc":"All necessary connections are made using methods of\n[OtpTransportFactory](assets/java/com/ericsson/otp/erlang/OtpTransportFactory.html)\ninterface. The default OtpTransportFactory implementation is based on standard\nTCP/IP Socket class and relies on epmd. User may provide custom transport\nfactory as needed. See java doc for details.\n\nFor alternative distribution protocols working without epmd, using a transport\nfactory extending the\n[OtpGenericTransportFactory](assets/java/com/ericsson/otp/erlang/OtpGenericTransportFactory.html)\nabstract class will disable the automatic epmd registration and lookup in\nJinterface.","ref":"jinterface_users_guide.html#transport-factory"},{"type":"extras","title":"Sending and Receiving Messages - The Jinterface Package","doc":"Messages sent with this package must be instances of\n[`OtpErlangObject`] or one of its subclasses. Message can be sent to processes or pids,\neither by specifying the pid of the remote, or its registered name and node.\n\nIn this example, we create a message containing our own pid so the echo process\ncan reply:\n\n```java\nOtpErlangObject[] msg = new OtpErlangObject[2];\nmsg[0] = mbox.self();\nmsg[1] = new OtpErlangAtom(\"hello, world\");\nOtpErlangTuple tuple = new OtpErlangTuple(msg);\n```\n\nWhen we send the message, a connection will be created:\n\n```java\nmbox.send(\"echo\", \"gurka@sallad.com\", tuple);\n```\n\nAnd here we receive the reply:\n\n```java\nOtpErlangObject reply = mbox.receive();\n```\n\nMessages are sent asynchronously, so the call to `send()` returns as soon as the\nmessage has been dispatched to the underlying communication layer. This means\nthat you receive no indication whether the operation completed successfully or\nthe remote even existed. If you need this kind of confirmation, you should wait\nfor a response from the remote process.\n\nThe echo server itself might look like this:\n\n```java\nOtpNode self = new OtpNode(\"gurka\");\nOtpMbox mbox = self.createMbox(\"echo\");\nOtpErlangObject o;\nOtpErlangTuple msg;\nOtpErlangPid from;\n\nwhile (true) {\n  try {\n    o = mbox.receive();\n    if (o instanceof OtpErlangTuple) {\n      msg = (OtpErlangTuple)o;\n      from = (OtpErlangPid)(msg.elementAt(0));\n      mbox.send(from,msg.elementAt(1));\n  }\n  catch (Exception e) {\n    System.out.println(\"\" + e);\n  }\n}\n```\n\nIn the examples above, only one mailbox was created on each node. however you\nare free to create as many mailboxes on each node as you like. You are also free\nto create as many nodes as you like on each JVM, however because each node uses\nsome limited system resources such as file descriptors, it is recommended that\nyou create only a small number of nodes (such as one) on each JVM.","ref":"jinterface_users_guide.html#sending-and-receiving-messages"},{"type":"extras","title":"Sending Arbitrary Data - The Jinterface Package","doc":"This package was originally intended to be used for communicating between Java\nand Erlang, and for that reason the send and receive methods all use Java\nrepresentations of Erlang data types.\n\nHowever it is possible to use the package to communicate with remote processes\nwritten in Java as well, and in these cases it may be desirable to send other\ndata types.\n\nThe simplest way to do this is to encapsulate arbitrary data in messages of type\n[`OtpErlangBinary`](assets/java/com/ericsson/otp/erlang/OtpErlangBinary.html). The\nOtpErlangBinary class can be created from arbitrary Java objects that implement\nthe Serializable or Externalizable interface:\n\n```java\no = new MyClass(foo);\nmbox.send(remote,new OtpErlangBinary(o));\n```\n\nThe example above will cause the object to be serialized and encapsulated in an\nOtpErlangBinary before being sent. The recipient will receive an OtpErlangBinary\nbut can extract the original object from it:\n\n```java\nmsg = mbox.receive();\nif (msg instanceof OtpErlangBinary) {\n  OtpErlangBinary b = (OtpErlangBinary)msg;\n  MyClass o = (MyClass)(b.getObject());\n}\n```","ref":"jinterface_users_guide.html#sending-arbitrary-data"},{"type":"extras","title":"Linking to Remote Processes - The Jinterface Package","doc":"Erlang defines a concept known as linked processes. A link is an implicit\nconnection between two processes that causes an exception to be raised in one of\nthe processes if the other process terminates for any reason. Links are\nbidirectional: it does not matter which of the two processes created the link or\nwhich of the linked processes eventually terminates; an exception will be raised\nin the remaining process. Links are also idempotent: at most one link can exist\nbetween two given processes, only one operation is necessary to remove the link.\n\nJinterface provides a similar mechanism. Also here, no distinction is made\nbetween mailboxes and Erlang processes. A link can be created to a remote\nmailbox or process when its pid is known:\n\n```java\nmbox.link(remote);\n```\n\nThe link can be removed by either of the processes in a similar manner:\n\n```java\nmbox.unlink(remote);\n```\n\nIf the remote process terminates while the link is still in place, an exception\nwill be raised on a subsequent call to receive():\n\n```java\ntry {\n  msg = mbox.receive();\n}\ncatch (OtpErlangExit e) {\n  System.out.println(\"Remote pid \" + e.pid() + \" has terminated\");\n}\ncatch (OtpErlangDecodeException f) {\n  System.out.println(\"Received message could not be decoded: \" + f);\n}\n```\n\nWhen a mailbox is explicitly closed, exit messages will be sent in order to\nbreak any outstanding links. If a mailbox is never closed but instead goes out\nof scope, the objects `finalize()` method will call `close()`. However since\nJava provides no guarantees about when or even if finalize() will be called, it\nis important that your application explicitly closes mailboxes when they are no\nlonger needed if you want links to work in a timely manner.","ref":"jinterface_users_guide.html#linking-to-remote-processes"},{"type":"extras","title":"Using EPMD - The Jinterface Package","doc":"Epmd is the Erlang Port Mapper Daemon. By default distributed Erlang nodes\nregister with epmd on the localhost to indicate to other nodes that they exist\nand can accept connections. Epmd maintains a register of node and socket port\nnumber information, and when a node wishes to connect to another node, it first\ncontacts epmd in order to find out the correct socket port number to connect to.\nIt is also possible to use alternative distribution protocols which don't need\nepmd at all.\n\nThe basic interaction with EPMD is done through instances of\n[OtpEpmd](assets/java/com/ericsson/otp/erlang/OtpEpmd.html) class. Nodes wishing\nto contact other nodes must first request information from Epmd before a\nconnection can be set up, however this is done automatically by\n[OtpSelf.connect()](assets/java/com/ericsson/otp/erlang/OtpSelf.html#connect%28com.ericsson.otp.erlang.OtpPeer%29)\nwhen necessary.\n\nWhen you use\n[OtpSelf.connect()](assets/java/com/ericsson/otp/erlang/OtpSelf.html#connect%28com.ericsson.otp.erlang.OtpPeer%29)\nto connect to an Erlang node, a connection is first made to epmd and, if the\nnode is known, a connection is then made to the Erlang node.\n\nJava nodes can also register themselves with epmd if they want other nodes in\nthe system to be able to find and connect to them. This is done by call to\nmethod\n[OtpEpmd.publishPort()](assets/java/com/ericsson/otp/erlang/OtpEpmd.html#publishPort%28com.ericsson.otp.erlang.OtpLocalNode%29).\n\nBe aware that on some systems a failed node will not be detected by this\nmechanism since the operating system does not automatically close descriptors\nthat were left open when the node failed. If a node has failed in this way, epmd\nwill prevent you from registering a new node with the old name, since it thinks\nthat the old name is still in use. In this case, you must unregister the name\nexplicitly, by using\n[OtpEpmd.unPublishPort()](assets/java/com/ericsson/otp/erlang/OtpEpmd.html#unPublishPort%28com.ericsson.otp.erlang.OtpLocalNode%29)\n\nThis will cause epmd to close the connection from the far end. Note that if the\nname was in fact still in use by a node, the results of this operation are\nunpredictable. Also, doing this does not cause the local end of the connection\nto close, so resources may be consumed.","ref":"jinterface_users_guide.html#using-epmd"},{"type":"extras","title":"Remote Procedure Calls - The Jinterface Package","doc":"An Erlang node acting as a client to another Erlang node typically sends a\nrequest and waits for a reply. Such a request is included in a function call at\na remote node and is called a remote procedure call. Remote procedure calls are\nsupported through the class [`OtpConnection`]. The following example shows how the\n[`OtpConnection`] class is used for remote procedure calls:\n\n```java\nOtpSelf self = new OtpSelf(\"client\", \"hejsan\" );\nOtpPeer other  = new OtpPeer(\"server@balin\");\nOtpConnection connection = self.connect(other);\n\nconnection.sendRPC(\"erlang\",\"date\",new OtpErlangList());\nOtpErlangObject received = connection.receiveRPC();\n```\n\n`erlang:date/0` is just called to get the date tuple from a remote host.","ref":"jinterface_users_guide.html#remote-procedure-calls"},{"type":"extras","title":"Compiling and Loading Your Code - The Jinterface Package","doc":"In order to use any of the\n[Jinterface] classes,\ninclude the following line in your code:\n\n```java\nimport com.ericsson.otp.erlang.*;\n```\n\nDetermine where the top directory of your OTP installation is. You can find this\nout by starting Erlang and entering the following command at the Eshell prompt:\n\n```text\nEshell V4.9.1.2  (abort with ^G)\n1> code:root_dir().\n/usr/local/otp\n```\n\nTo compile your code, make sure that your Java compiler knows where to find the\nfile `OtpErlang.jar` which contains the package. This is done by specifying an\nappropriate `-classpath` argument on the command line, or by adding it to the\n`CLASSPATH` definition in your `Makefile`. The correct value for this path is\n`$OTPROOT/lib/jinterface`_Vsn_`/priv/OtpErlang.jar`, where `$OTPROOT` is the\npath reported by `code:root_dir/0` in the above example and _Vsn_ is the version\nof Jinterface, for example `jinterface-1.2`\n\n```text\n$ javac -classpath \".:/usr/local/otp/lib/jinterface-1.2/priv/OtpErlang.jar\"\n                myclass.java\n```\n\nWhen running your program, you will also need to specify the path to\n`OtpErlang.jar` in a similar way.\n\n```text\n$ java \".:/usr/local/otp/lib/jinterface-1.2/priv/OtpErlang.jar\" myclass\n```","ref":"jinterface_users_guide.html#compiling-and-loading-your-code"},{"type":"extras","title":"Tracing - The Jinterface Package","doc":"Communication between nodes can be traced by setting a system property before\nthe communication classes in this package are initialized. The value system\nproperty \"OtpConnection.trace\" is the default trace level for all connections.\nNormally the default trace level is zero, i.e. no tracing is performed. By\nsetting OtpConnection.trace to some non-zero value, the communication protocol\ncan be shown in more or less detail. The valid values are:\n\n- 0: no tracing is performed\n- 1: only ordinary send and reg-send messages are shown\n- 2: control messages such as link, unlink and exit are shown\n- 3: connection setup (handshake) is shown\n- 4: epmd requests are shown\n\nEach level also includes the information shown by all lower levels.\n\n[`OtpErlangAtom`]: assets/java/com/ericsson/otp/erlang/OtpErlangAtom.html\n[`OtpErlangBinary`]: assets/java/com/ericsson/otp/erlang/OtpErlangBinary.html\n[`OtpErlangBoolean`]: assets/java/com/ericsson/otp/erlang/OtpErlangBoolean.html\n[`OtpErlangFloat`]: assets/java/com/ericsson/otp/erlang/OtpErlangFloat.html\n[`OtpErlangDouble`]: assets/java/com/ericsson/otp/erlang/OtpErlangDouble.html\n[`OtpErlangByte`]: assets/java/com/ericsson/otp/erlang/OtpErlangByte.html\n[`OtpErlangChar`]: assets/java/com/ericsson/otp/erlang/OtpErlangChar.html\n[`OtpErlangShort`]: assets/java/com/ericsson/otp/erlang/OtpErlangShort.html\n[`OtpErlangString`]: assets/java/com/ericsson/otp/erlang/OtpErlangString.html\n[`OtpErlangUShort`]: assets/java/com/ericsson/otp/erlang/OtpErlangUShort.html\n[`OtpErlangInt`]: assets/java/com/ericsson/otp/erlang/OtpErlangInt.html\n[`OtpErlangUInt`]: assets/java/com/ericsson/otp/erlang/OtpErlangUInt.html\n[`OtpErlangLong`]: assets/java/com/ericsson/otp/erlang/OtpErlangLong.html\n[`OtpErlangList`]: assets/java/com/ericsson/otp/erlang/OtpErlangList.html\n[`OtpErlangPid`]: assets/java/com/ericsson/otp/erlang/OtpErlangPid.html\n[`OtpErlangPort`]: assets/java/com/ericsson/otp/erlang/OtpErlangPort.html\n[`OtpErlangRef`]: assets/java/com/ericsson/otp/erlang/OtpErlangRef.html\n[`OtpErlangTuple`]: assets/java/com/ericsson/otp/erlang/OtpErlangTuple.html\n[`OtpErlangMap`]: assets/java/com/ericsson/otp/erlang/OtpErlangMap.html\n[`OtpErlangObject`]: assets/java/com/ericsson/otp/erlang/OtpErlangObject.html\n[`OtpMbox`]: assets/java/com/ericsson/otp/erlang/OtpMbox.html\n[`OtpNode`]: assets/java/com/ericsson/otp/erlang/OtpNode.html\n[`OtpConnection`]: assets/java/com/ericsson/otp/erlang/OtpConnection.html\n[Jinterface]: assets/java/com/ericsson/otp/erlang/package-summary.html","ref":"jinterface_users_guide.html#tracing"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.3"}}