searchData={"items":[{"type":"extras","title":"Erlang/OTP 28.1.1","doc":"# Erlang/OTP 28.1.1\n\nWelcome to Erlang/OTP, a complete development environment for concurrent programming.\n\nThe Erlang language is described in the [Erlang Reference Manual](`e:system:reference_manual.md`). An Erlang tutorial can be found in [Getting Started With Erlang](`e:system:getting_started.md`).\n\nIn addition to the documentation here Erlang is described in several books like:\n\n* [\"Introducing Erlang\"][1] from O'Reilly.\n* [\"Learn You Some Erlang for Great Good!\"][2] from No Starch Press.\n* [\"Erlang Programming\"][3] from O'Reilly.\n* [\"Programming Erlang\"][4] from Pragmatic.\n* [\"Erlang and OTP in Action\"][5] from Manning.\n* [\"Designing for Scalability with Erlang/OTP\"][6] from O'Reilly.\n\nThese books are highly recommended as a start for learning Erlang.\n\nMore information about learning resources, editors and other tools can be found on our [official Erlang web site](https://erlang.org/community).\n\n* Erlang/OTP is divided into a number of [OTP applications](`m:application`). An application normally contains Erlang modules. Some OTP applications, such as the C interface [erl\\_interface](`e:erl_interface:index.html`), are written in other languages and have no Erlang modules.\n\n* When developing with Erlang/OTP you usually test your programs from the interactive shell (see [Getting Started With Erlang](`e:system:getting_started.md`)) where you can call individual functions. There is also a number of tools available, such as the graphical [Debugger](`e:debugger:index.html`) and the [Observer tool](`e:observer:index.html`) for inspection of system information, ets and mnesia tables etc.\n* For questions and discussions about Erlang we recommend [ErlangForums](https://erlangforums.com).\n* There is also the [Frequently Asked Questions](https://www.erlang.org/faq/faq.html) which can be of interest.\n* Additional information and links of interest for Erlang programmers can be found on the Erlang Open Source site https://www.erlang.org.\n\n[1]: https://www.oreilly.com/library/view/introducing-erlang-2nd/9781491973363\n[2]: https://www.nostarch.com/erlang\n[3]: https://www.oreilly.com/library/view/erlang-programming/9780596803940\n[4]: https://www.pragprog.com/titles/jaerlang2/programming-erlang-2nd-edition/\n[5]: https://www.manning.com/logan\n[6]: https://shop.oreilly.com/product/0636920024149.do","ref":"readme.html"},{"type":"extras","title":"Module Index","doc":"# Module Index\n\n\n|  Module name | Description | Application |\n|--------------|-------------|-------------|\n|  `m:alarm_handler` | An Alarm Handling Process. | [sasl-4.3](`e:sasl:index.html`) |\n|  `m:application` | Generic OTP application functions. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:argparse` | Command line arguments parser. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:array` | Functional, extendible arrays. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:asn1ct` | ASN.1 compiler and compile-time support functions. | [asn1-5.4.2](`e:asn1:index.html`) |\n|  `m:atomics` | Atomic Functions. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:auth` | Erlang network authentication server. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:base64` | Provides base64 encode and decode, see. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:beam_lib` | This module provides an interface to files created by the BEAM Compiler (\"BEAM. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:binary` | Library for handling binary data. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:c` | Command line interface module. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:calendar` | Local and universal time, day of the week, date and time conversions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:cerl` | Core Erlang abstract syntax trees. | [compiler-9.0.2](`e:compiler:index.html`) |\n|  `m:cerl_clauses` | Utility functions for Core Erlang case/receive clauses. | [compiler-9.0.2](`e:compiler:index.html`) |\n|  `m:cerl_trees` | Basic functions on Core Erlang abstract syntax trees. | [compiler-9.0.2](`e:compiler:index.html`) |\n|  `m:code` | Interface to the Erlang code server process. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:compile` | Erlang Compiler. | [compiler-9.0.2](`e:compiler:index.html`) |\n|  `m:counters` | Counter Functions. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:cover` | A Coverage Analysis Tool for Erlang. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:cprof` | A simple Call Count Profiling Tool using breakpoints for minimal runtime. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:cpu_sup` | A CPU Load and CPU Utilization Supervisor Process. | [os_mon-2.11.1](`e:os_mon:index.html`) |\n|  `m:crashdump_viewer` | A WxWidgets based tool for browsing Erlang crashdumps. | [observer-2.18.1](`e:observer:index.html`) |\n|  `m:crypto` | Crypto Functions. | [crypto-5.7](`e:crypto:index.html`) |\n|  `m:ct` | Main user interface for the `Common Test` framework. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_cover` | `Common Test` framework code coverage support module. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_ftp` | FTP client module (based on the `ftp` application). | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_hooks` | A callback interface on top of Common Test. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_master` | Distributed test execution control for `Common Test`. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_netconfc` | NETCONF client module. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_property_test` | Support in Common Test for running property-based tests. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_rpc` | `Common Test` specific layer on Erlang/OTP `rpc`. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_slave` | `Common Test` framework functions for starting and stopping nodes for. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_snmp` | `Common Test` user interface module for the `SNMP` application. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_ssh` | SSH/SFTP client module. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_suite` | The following section describes the mandatory and optional test suite functions. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_telnet` | `Common Test` specific layer on top of Telnet client `ct_telnet_client.erl`. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:ct_testspec` | Parsing of test specifications for `Common Test`. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:dbg` | The Text Based Trace Facility. | [runtime_tools-2.3](`e:runtime_tools:index.html`) |\n|  `m:debugger` | The Erlang Debugger for debugging and testing of Erlang programs. | [debugger-6.0.3](`e:debugger:index.html`) |\n|  `m:dets` | A disk-based term storage. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:dialyzer` | Dialyzer is a **DI**screpancy **A**na**LYZ**er for **ER**lang programs. | [dialyzer-5.4](`e:dialyzer:index.html`) |\n|  `m:diameter` | Main API of the diameter application. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:diameter_app` | Callback module of a Diameter application. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:diameter_codec` | Decode and encode of Diameter messages. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:diameter_make` | Diameter dictionary compilation. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:diameter_sctp` | Diameter transport over SCTP. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:diameter_tcp` | Diameter transport over TCP. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:diameter_transport` | Diameter transport interface. | [diameter-2.5.2](`e:diameter:index.html`) |\n|  `m:dict` | A Key-value dictionary. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:digraph` | This module provides a version of labeled directed graphs (\"digraphs\"). | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:digraph_utils` | This module provides algorithms based on depth-first traversal of directed. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:disk_log` | `disk_log` is a disk-based term logger that enables efficient logging of items. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:disksup` | A Disk Supervisor Process. | [os_mon-2.11.1](`e:os_mon:index.html`) |\n|  `m:dyntrace` | Interface to dynamic tracing. | [runtime_tools-2.3](`e:runtime_tools:index.html`) |\n|  `m:edlin` | Line and input interpretter for the erlang shell. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:edlin_expand` | Shell expansion and formatting of expansion suggestions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:edoc` | EDoc - the Erlang program documentation generator. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_doclet` | Standard doclet module for EDoc. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_doclet_chunks` | Doclet generating standalone EEP-48 doc chunk files. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_doclet_markdown` | Doclet converting an edoc application to use EEP-59 and Markdown. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_extract` | EDoc documentation extraction. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_html_to_markdown` | This module can convert application/html+erlang style documentation to markdown. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_layout` | The standard HTML layout module for EDoc. See the edoc module for details on usage. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_layout_chunks` | Convert EDoc module documentation to an EEP-48docs_v1 chunk. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_lib` | Utility functions for EDoc. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:edoc_run` | Interface for calling EDoc from Erlang startup options. | [edoc-1.4.1](`e:edoc:index.html`) |\n|  `m:eldap` | LDAP Client. | [eldap-1.2.16](`e:eldap:index.html`) |\n|  `m:epp` | An Erlang code preprocessor. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:epp_dodger` | Bypassing the Erlang preprocessor. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:eprof` | A Time Profiling Tool for Erlang. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:erl_anno` | Abstract datatype for the annotations of the Erlang Compiler. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_boot_server` | Boot server for other Erlang machines. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:erl_comment_scan` | Functions for reading comment lines from Erlang source code. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:erl_ddll` | Dynamic driver loader and linker. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:erl_debugger` | Erlang debugger support (EXPERIMENTAL). | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:erl_epmd` | Erlang interface towards epmd. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:erl_error` | This module provides functions for pretty-printing errors and exceptions. It is. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_eval` | The Erlang meta interpreter. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_expand_records` | This module expands records in a module. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_features` | This module contains functions for supporting features that can be. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_id_trans` | This module performs an identity parse transformation of Erlang code. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_internal` | Internal Erlang definitions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_lint` | The Erlang code linter. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_parse` | This module is the basic Erlang parser that converts tokens into the abstract. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_pp` | The Erlang pretty printer. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_prettypr` | Pretty printing of abstract Erlang syntax trees. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:erl_prim_loader` | The low-level Erlang loader. This module is used to load all Erlang modules into. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:erl_recomment` | Inserting comments into abstract Erlang syntax trees. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:erl_scan` | The Erlang token scanner. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_syntax` | Abstract Erlang syntax trees. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:erl_syntax_lib` | Support library for abstract Erlang syntax trees. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:erl_tar` | Unix 'tar' utility for reading and writing tar archives. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:erl_tracer` | Erlang tracer behavior. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:erlang` | The Erlang BIFs and predefined types. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:erpc` | Enhanced Remote Procedure Call. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:error_handler` | Default system error handler. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:error_logger` | Erlang error logger. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:escript` | This module provides functions to create and inspect escripts. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:et` | Main API of the Event Trace (ET) application. | [et-1.7.2](`e:et:index.html`) |\n|  `m:et_collector` | Collect trace events and provide a backing storage appropriate for iteration. | [et-1.7.2](`e:et:index.html`) |\n|  `m:et_selector` | Define event transforms and trace patterns. | [et-1.7.2](`e:et:index.html`) |\n|  `m:et_viewer` | Displays a sequence chart for trace events (messages/actions). | [et-1.7.2](`e:et:index.html`) |\n|  `m:etop` | Erlang Top is a tool for presenting information about Erlang processes similar. | [observer-2.18.1](`e:observer:index.html`) |\n|  `m:ets` | Built-in term storage. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:eunit` | This module is the main EUnit user interface. | [eunit-2.10](`e:eunit:index.html`) |\n|  `m:eunit_surefire` | Surefire reports for EUnit (Format used by Maven and Atlassian Bamboo for. | [eunit-2.10](`e:eunit:index.html`) |\n|  `m:file` | File interface module. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:file_sorter` | File sorter. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:filelib` | File utilities, such as wildcard matching of filenames. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:filename` | Filename manipulation functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:fprof` | A Time Profiling Tool using trace to file for minimal runtime performance. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:ftp` | A File Transfer Protocol client. | [ftp-1.2.4](`e:ftp:index.html`) |\n|  `m:gb_sets` | Sets represented by general balanced trees. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:gb_trees` | General balanced trees. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:gen_event` | Generic event handling behavior. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:gen_fsm` | Deprecated and replaced by `m:gen_statem` in OTP 20. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:gen_sctp` | Interface to SCTP sockets. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:gen_server` | Generic server behavior. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:gen_statem` | Generic state machine behavior. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:gen_tcp` | Interface to TCP/IP sockets. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:gen_udp` | Interface to UDP sockets. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:gl` | Erlang wrapper functions for OpenGL. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:global` | A global name registration facility. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:global_group` | Grouping nodes to global name registration groups. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:glu` | Erlang wrapper functions for OpenGL. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:heart` | Heartbeat monitoring of an Erlang runtime system. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:http_uri` | Old URI utility module, use uri_string instead. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:httpc` | An HTTP/1.1 client. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:httpd` | HTTP server API. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:httpd_custom_api` | Behaviour with optional callbacks to customize the inets HTTP server. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:httpd_socket` | Communication utility functions to be used by the Erlang web server API. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:httpd_util` | Miscellaneous utility functions to be used when implementing Erlang web server. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:i` | Debugger/Interpreter Interface. | [debugger-6.0.3](`e:debugger:index.html`) |\n|  `m:inet` | Access to Network protocols. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:inet_res` | A rudimentary DNS client. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:inets` | The Inets services API. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:init` | Coordination of system startup. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:instrument` | Analysis and Utility Functions for Instrumentation. | [runtime_tools-2.3](`e:runtime_tools:index.html`) |\n|  `m:int` | Interpreter Interface. | [debugger-6.0.3](`e:debugger:index.html`) |\n|  `m:io` | Standard I/O server interface functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:io_lib` | I/O library functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:json` | A library for encoding and decoding JSON. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:lcnt` | A runtime system Lock Profiling tool. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:leex` | Lexical analyzer generator for Erlang. | [parsetools-2.7](`e:parsetools:index.html`) |\n|  `m:lists` | List processing functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:log_mf_h` | An event handler that logs events to disk. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:logger` | API module for Logger, the standard logging facility in Erlang/OTP. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:logger_disk_log_h` | A disk_log based handler for Logger. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:logger_filters` | Filters to use with Logger. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:logger_formatter` | Default formatter for Logger. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:logger_handler` | logger_handler behavior module. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:logger_std_h` | Standard handler for Logger. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:make` | A Make Utility for Erlang. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:maps` | Maps processing functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:math` | Mathematical functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:megaco` | Main API of the Megaco application. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_codec_meas` | This module implements a simple megaco codec measurement tool. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_codec_mstone1` | This module implements a simple megaco codec-based performance tool. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_codec_mstone2` | This module implements a simple megaco codec-based performance tool. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_codec_transform` | Megaco message transformation utility. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_digit_map` | Digit Map utility module. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_edist_compress` | Megaco erlang dist compress behaviour. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_encoder` | Megaco encoder behaviour. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_flex_scanner` | Interface module to the flex scanner linked in driver. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_sdp` | SDP utility module. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_tcp` | Interface module to TPKT transport protocol for Megaco/H.248. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_transport` | Megaco transport behaviour. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_udp` | Interface module to UDP transport protocol for Megaco/H.248. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:megaco_user` | Callback module for users of the Megaco application. | [megaco-4.8.1](`e:megaco:index.html`) |\n|  `m:memsup` | A Memory Supervisor Process. | [os_mon-2.11.1](`e:os_mon:index.html`) |\n|  `m:merl` | Metaprogramming in Erlang. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:merl_transform` | Parse transform for merl. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:mnesia` | A distributed key-value DBMS. | [mnesia-4.24.1](`e:mnesia:index.html`) |\n|  `m:mnesia_frag_hash` | Defines mnesia_frag_hash callback behavior. | [mnesia-4.24.1](`e:mnesia:index.html`) |\n|  `m:mnesia_registry` | This module is deprecated and the functions should not be used. | [mnesia-4.24.1](`e:mnesia:index.html`) |\n|  `m:mod_alias` | URL aliasing. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:mod_auth` | User authentication using text files, Dets, or Mnesia database. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:mod_esi` | Erlang Server Interface. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:mod_security` | Security Audit and Trailing Functionality. | [inets-9.4.2](`e:inets:index.html`) |\n|  `m:ms_transform` | <!--. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:msacc` | Convenience functions for microstate accounting. | [runtime_tools-2.3](`e:runtime_tools:index.html`) |\n|  `m:net` | Network interface. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:net_adm` | Various Erlang net administration routines. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:net_kernel` | Erlang networking kernel. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:nteventlog` | Interface to Windows Event Log. | [os_mon-2.11.1](`e:os_mon:index.html`) |\n|  `m:observer` | A GUI tool for observing an Erlang system. | [observer-2.18.1](`e:observer:index.html`) |\n|  `m:odbc` | Erlang ODBC application. | [odbc-2.16](`e:odbc:index.html`) |\n|  `m:orddict` | Key-value dictionary as ordered list. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:ordsets` | Functions for manipulating sets as ordered lists. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:os` | Operating system-specific functions. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:os_sup` | Interface to OS System Messages. | [os_mon-2.11.1](`e:os_mon:index.html`) |\n|  `m:peer` | <!--. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:persistent_term` | Persistent terms. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:pg` | Distributed named process groups. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:pool` | Load distribution facility. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:prettypr` | A generic pretty printer library. | [syntax_tools-4.0.1](`e:syntax_tools:index.html`) |\n|  `m:proc_lib` | Functions for asynchronous and synchronous start of processes adhering to the. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:proplists` | Support functions for property lists. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:public_key` | API module for public-key infrastructure. | [public_key-1.18.3](`e:public_key:index.html`) |\n|  `m:qlc` | <!--. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:queue` | Abstract data type for FIFO queues. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:rand` | Pseudo random number generation. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:random` | Pseudo-random number generation. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:rb` | The Report Browser Tool. | [sasl-4.3](`e:sasl:index.html`) |\n|  `m:re` | <!--. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:release_handler` | Unpacking and Installation of Release Packages. | [sasl-4.3](`e:sasl:index.html`) |\n|  `m:reltool` | Main API of the Reltool application. | [reltool-1.0.2](`e:reltool:index.html`) |\n|  `m:rpc` | Remote Procedure Call services. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:scheduler` | Measure scheduler utilization. | [runtime_tools-2.3](`e:runtime_tools:index.html`) |\n|  `m:seq_trace` | Sequential tracing of information transfers. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:sets` | Sets are collections of elements with no duplicate elements. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:shell` | <!--. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:shell_default` | Customizing the Erlang environment. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:shell_docs` | Functions used to render [EEP-48](`e:kernel:eep48_chapter.md`) style documentation for a shell. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:slave` | This module provides functions for starting Erlang slave nodes. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:snmp` | Interface functions to the SNMP toolkit. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_community_mib` | Instrumentation Functions for SNMP-COMMUNITY-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_framework_mib` | Instrumentation Functions for SNMP-FRAMEWORK-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_generic` | Generic Functions for Implementing SNMP Objects in a Database. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_index` | Abstract Data Type for SNMP Indexing. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_notification_mib` | Instrumentation Functions for SNMP-NOTIFICATION-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_pdus` | Encode and Decode Functions for SNMP PDUs. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_standard_mib` | Instrumentation Functions for STANDARD-MIB and SNMPv2-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_target_mib` | Instrumentation Functions for SNMP-TARGET-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_user_based_sm_mib` | Instrumentation Functions for SNMP-USER-BASED-SM-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmp_view_based_acm_mib` | Instrumentation Functions for SNMP-VIEW-BASED-ACM-MIB. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa` | Interface Functions to the SNMP toolkit agent. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_conf` | Utility functions for handling the agent config files. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_discovery_handler` | Behaviour module for the SNMP agent discovery handler. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_error` | Functions for Reporting SNMP Errors. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_error_io` | Functions for Reporting SNMP Errors on stdio. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_error_logger` | Functions for Reporting SNMP Errors through the error_logger. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_error_report` | Behaviour module for reporting SNMP agent errors. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_local_db` | The SNMP built-in database. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_mib_data` | Behaviour module for the SNMP agent mib-server data module. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_mib_storage` | Behaviour module for the SNMP agent mib storage. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_mpd` | Message Processing and Dispatch module for the SNMP agent. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_network_interface` | Behaviour module for the SNMP agent network interface. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_network_interface_filter` | Behaviour module for the SNMP agent network-interface filter. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_notification_delivery_info_receiver` | Behaviour module for the SNMP agent notification delivery information receiver. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_notification_filter` | Behaviour module for the SNMP agent notification filters. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpa_supervisor` | A supervisor for the SNMP agent Processes. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpc` | Interface Functions to the SNMP toolkit MIB compiler. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpm` | Interface functions to the SNMP toolkit manager. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpm_conf` | Utility functions for handling the manager config files. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpm_mpd` | Message Processing and Dispatch module for the SNMP manager. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpm_network_interface` | Behaviour module for the SNMP manager network interface. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpm_network_interface_filter` | Behaviour module for the SNMP manager network-interface filter. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:snmpm_user` | Behaviour module for the SNMP manager user. | [snmp-5.19.1](`e:snmp:index.html`) |\n|  `m:socket` | Socket interface. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:sofs` | <!--. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:ssh` | Main API of the ssh application. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_agent` | Callback module for using an SSH agent instead of the default ssh_file callback. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_client_channel` | SSH services (clients and servers) are implemented as channels that are. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_client_key_api` | \\-behaviour(ssh_client_key_api). | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_connection` | This module provides API functions to send SSH Connection Protocol events to the. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_file` | Default callback module for the client's and server's database operations in the. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_server_channel` | \\-behaviour(ssh_server_channel). (Replaces ssh_daemon_channel). | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_server_key_api` | \\-behaviour(ssh_server_key_api). | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_sftp` | SFTP client. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssh_sftpd` | Specifies the channel process to handle an SFTP subsystem. | [ssh-5.3.3](`e:ssh:index.html`) |\n|  `m:ssl` | Interface functions for TLS (Transport Layer Security). | [ssl-11.4.1](`e:ssl:index.html`) |\n|  `m:ssl_crl_cache` | CRL cache. | [ssl-11.4.1](`e:ssl:index.html`) |\n|  `m:ssl_crl_cache_api` | API for a TLS CRL (Certificate Revocation List) cache. | [ssl-11.4.1](`e:ssl:index.html`) |\n|  `m:ssl_session_cache_api` | TLS session cache API. | [ssl-11.4.1](`e:ssl:index.html`) |\n|  `m:string` | String processing functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:supervisor` | Generic supervisor behavior. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:supervisor_bridge` | Generic supervisor bridge behavior. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:sys` | A functional interface to system messages. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:system_information` | System Information. | [runtime_tools-2.3](`e:runtime_tools:index.html`) |\n|  `m:systools` | A Set of Release Handling Tools. | [sasl-4.3](`e:sasl:index.html`) |\n|  `m:tags` | Generate Emacs TAGS file from Erlang source files. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:tftp` | Trivial FTP. | [tftp-1.2.3](`e:tftp:index.html`) |\n|  `m:tftp_logger` | Trivial FTP logger. | [tftp-1.2.3](`e:tftp:index.html`) |\n|  `m:timer` | Timer functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:tprof` | Process Tracing Profiling Tool. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:trace` | The Erlang trace interface. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:ttb` | A base for building trace tools for distributed systems. | [observer-2.18.1](`e:observer:index.html`) |\n|  `m:unicode` | Functions for converting Unicode characters. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:unix_telnet` | Callback module for `m:ct_telnet`, for connecting to a Telnet server on a UNIX. | [common_test-1.29](`e:common_test:index.html`) |\n|  `m:uri_string` | URI processing functions. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:win32reg` | Provides access to the registry on Windows. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:wrap_log_reader` | A service to read internally formatted wrap disk logs. | [kernel-10.4.1](`e:kernel:index.html`) |\n|  `m:wx` | A port of [wxWidgets](http://www.wxwidgets.org/). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAcceleratorEntry` | An object used by an application wishing to create an accelerator table (see `m:wxAcceleratorTable`). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAcceleratorTable` | An accelerator table allows the application to specify a table of keyboard shortcuts for. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxActivateEvent` | An activate event is sent when a window or application is being activated or deactivated. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxArtProvider` | `m:wxArtProvider` class is used to customize the look of wxWidgets application. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiDockArt` | `m:wxAuiDockArt` is part of the wxAUI class framework. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiManager` | `m:wxAuiManager` is the central class of the wxAUI class framework. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiManagerEvent` | Event used to indicate various actions taken with `m:wxAuiManager`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiNotebook` | `m:wxAuiNotebook` is part of the wxAUI class framework, which represents a notebook. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiNotebookEvent` | This class is used by the events generated by `m:wxAuiNotebook`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiPaneInfo` | `m:wxAuiPaneInfo` is part of the wxAUI class framework. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiSimpleTabArt` | Another standard tab art provider for `m:wxAuiNotebook`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxAuiTabArt` | Tab art provider defines all the drawing functions used by `m:wxAuiNotebook`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBitmap` | This class encapsulates the concept of a platform-dependent bitmap, either monochrome or. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBitmapButton` | A bitmap button is a control that contains a bitmap. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBitmapDataObject` | `m:wxBitmapDataObject` is a specialization of `m:wxDataObject` for bitmap data. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBookCtrlBase` | A book control is a convenient way of displaying multiple pages of information, displayed. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBookCtrlEvent` | This class represents the events generated by book controls (`m:wxNotebook`, `m:wxListbook`, `m:wxChoicebook`, `m:wxTreebook`, `m:wxAuiNotebook`). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBoxSizer` | The basic idea behind a box sizer is that windows will most often be laid out in rather. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBrush` | A brush is a drawing tool for filling in areas. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBufferedDC` | This class provides a simple way to avoid flicker: when drawing on it, everything is in. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxBufferedPaintDC` | This is a subclass of `m:wxBufferedDC` which can be used inside of an `EVT\\_PAINT()`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxButton` | A button is a control that contains a text string, and is one of the most common elements. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCalendarCtrl` | The calendar control allows the user to pick a date. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCalendarDateAttr` | `m:wxCalendarDateAttr` is a custom attributes for a calendar date. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCalendarEvent` | The `m:wxCalendarEvent` class is used together with `m:wxCalendarCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCaret` | A caret is a blinking cursor showing the position where the typed text will appear. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCheckBox` | A checkbox is a labelled box which by default is either on (checkmark is visible) or off. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCheckListBox` | A `m:wxCheckListBox` is like a `m:wxListBox`, but allows items to be checked or. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxChildFocusEvent` | A child focus event is sent to a (parent-)window when one of its child windows gains. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxChoice` | A choice item is used to select one of a list of strings. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxChoicebook` | `m:wxChoicebook` is a class similar to `m:wxNotebook`, but uses a `m:wxChoice` control to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxClientDC` | `m:wxClientDC` is primarily useful for obtaining information about the window from. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxClipboard` | A class for manipulating the clipboard. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxClipboardTextEvent` | This class represents the events generated by a control (typically a `m:wxTextCtrl` but. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCloseEvent` | This event class contains information about window and session close events. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxColourData` | This class holds a variety of information related to colour dialogs. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxColourDialog` | This class represents the colour chooser dialog. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxColourPickerCtrl` | This control allows the user to select a colour. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxColourPickerEvent` | This event class is used for the events generated by `m:wxColourPickerCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxComboBox` | A combobox is like a combination of an edit control and a listbox. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCommandEvent` | This event class contains information about command events, which originate from a. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxContextMenuEvent` | This class is used for context menu events, sent to give the application a chance to show. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxControl` | This is the base class for a control or \"widget\". | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxControlWithItems` | This is convenience class that derives from both `m:wxControl` and `wxItemContainer` (not. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxCursor` | A cursor is a small bitmap usually used for denoting where the mouse pointer is, with a. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDC` | A `m:wxDC` is a `\"device context\"` onto which graphics and text can be drawn. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDCOverlay` | Connects an overlay with a drawing DC. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDataObject` | A `m:wxDataObject` represents data that can be copied to or from the clipboard, or. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDateEvent` | This event class holds information about a date change and is used together with `m:wxDatePickerCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDatePickerCtrl` | This control allows the user to select a date. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDialog` | A dialog box is a window with a title bar and sometimes a system menu, which can be moved. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDirDialog` | This class represents the directory chooser dialog. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDirPickerCtrl` | This control allows the user to select a directory. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDisplay` | Determines the sizes and locations of displays connected to the system. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDisplayChangedEvent` | A display changed event is sent to top-level windows when the display resolution has. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxDropFilesEvent` | This class is used for drop files events, that is, when files have been dropped onto the. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxEraseEvent` | An erase event is sent when a window's background needs to be repainted. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxEvent` | An event is a structure holding information about an event passed to a callback or member. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxEvtHandler` | The Event handler. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFileDataObject` | `m:wxFileDataObject` is a specialization of `m:wxDataObject` for file names. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFileDialog` | This class represents the file chooser dialog. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFileDirPickerEvent` | This event class is used for the events generated by `m:wxFilePickerCtrl` and by `m:wxDirPickerCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFilePickerCtrl` | This control allows the user to select a file. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFindReplaceData` | `m:wxFindReplaceData` holds the data for `m:wxFindReplaceDialog`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFindReplaceDialog` | `m:wxFindReplaceDialog` is a standard modeless dialog which is used to allow the user to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFlexGridSizer` | A flex grid sizer is a sizer which lays out its children in a two-dimensional table with. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFocusEvent` | A focus event is sent when a window's focus changes. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFont` | A font is an object which determines the appearance of text. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFontData` | This class holds a variety of information related to font dialogs. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFontDialog` | This class represents the font chooser dialog. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFontPickerCtrl` | This control allows the user to select a font. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFontPickerEvent` | This event class is used for the events generated by `m:wxFontPickerCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxFrame` | A frame is a window whose size and position can (usually) be changed by the user. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGBSizerItem` | The `m:wxGBSizerItem` class is used by the `m:wxGridBagSizer` for tracking the items in. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGCDC` | `m:wxGCDC` is a device context that draws on a `m:wxGraphicsContext`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGLCanvas` | `m:wxGLCanvas` is a class for displaying OpenGL graphics. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGLContext` | An instance of a `m:wxGLContext` represents the state of an OpenGL state machine and the. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGauge` | A gauge is a horizontal or vertical bar which shows a quantity (often time). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGenericDirCtrl` | This control can be used to place a directory listing (with optional files) on an. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsBrush` | A `m:wxGraphicsBrush` is a native representation of a brush. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsContext` | A `m:wxGraphicsContext` instance is the object that is drawn upon. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsFont` | A `m:wxGraphicsFont` is a native representation of a font. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsGradientStops` | Represents a collection of wxGraphicGradientStop values for use with. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsMatrix` | A `m:wxGraphicsMatrix` is a native representation of an affine matrix. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsObject` | This class is the superclass of native graphics objects like pens etc. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsPath` | A `m:wxGraphicsPath` is a native representation of a geometric path. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsPen` | A `m:wxGraphicsPen` is a native representation of a pen. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGraphicsRenderer` | A `m:wxGraphicsRenderer` is the instance corresponding to the rendering engine used. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGrid` | `m:wxGrid` and its related classes are used for displaying and editing tabular data. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridBagSizer` | A `m:wxSizer` that can lay out items in a virtual grid like a `m:wxFlexGridSizer` but in. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellAttr` | This class can be used to alter the cells' appearance in the grid by changing their. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellBoolEditor` | Grid cell editor for boolean data. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellBoolRenderer` | This class may be used to format boolean data in a cell. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellChoiceEditor` | Grid cell editor for string data providing the user a choice from a list of strings. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellEditor` | This class is responsible for providing and manipulating the in-place edit controls for. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellFloatEditor` | The editor for floating point numbers data. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellFloatRenderer` | This class may be used to format floating point data in a cell. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellNumberEditor` | Grid cell editor for numeric integer data. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellNumberRenderer` | This class may be used to format integer data in a cell. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellRenderer` | This class is responsible for actually drawing the cell in the grid. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellStringRenderer` | This class may be used to format string data in a cell; it is the default for string. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridCellTextEditor` | Grid cell editor for string/text data. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridEvent` | This event class contains information about various grid events. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxGridSizer` | A grid sizer is a sizer which lays out its children in a two-dimensional table with all. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxHelpEvent` | A help event is sent when the user has requested context-sensitive help. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxHtmlEasyPrinting` | This class provides very simple interface to printing architecture. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxHtmlLinkEvent` | This event class is used for the events generated by `m:wxHtmlWindow`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxHtmlWindow` | `m:wxHtmlWindow` is probably the only class you will directly use unless you want to do. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxIcon` | An icon is a small rectangular bitmap usually used for denoting a minimized application. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxIconBundle` | This class contains multiple copies of an icon in different sizes. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxIconizeEvent` | An event being sent when the frame is iconized (minimized) or restored. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxIdleEvent` | This class is used for idle events, which are generated when the system becomes idle. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxImage` | This class encapsulates a platform-independent image. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxImageList` | A `m:wxImageList` contains a list of images, which are stored in an unspecified form. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxInitDialogEvent` | A `m:wxInitDialogEvent` is sent as a dialog or panel is being initialised. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxJoystickEvent` | This event class contains information about joystick events, particularly events received. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxKeyEvent` | This event class contains information about key press and release events. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxLayoutAlgorithm` | `m:wxLayoutAlgorithm` implements layout of subwindows in MDI or SDI frames. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListBox` | A listbox is used to select one or more of a list of strings. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListCtrl` | A list control presents lists in a number of formats: list view, report view, icon view. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListEvent` | A list event holds information about events associated with `m:wxListCtrl` objects. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListItem` | This class stores information about a `m:wxListCtrl` item or column. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListItemAttr` | Functions for wxListItemAttr class. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListView` | This class currently simply presents a simpler to use interface for the `m:wxListCtrl` --. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxListbook` | `m:wxListbook` is a class similar to `m:wxNotebook` but which uses a `m:wxListCtrl` to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxLocale` | `m:wxLocale` class encapsulates all language-dependent settings and is a generalization. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxLogNull` | This class allows you to temporarily suspend logging. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMDIChildFrame` | An MDI child frame is a frame that can only exist inside a `m:wxMDIClientWindow`, which. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMDIClientWindow` | An MDI client window is a child of `m:wxMDIParentFrame`, and manages zero or more `m:wxMDIChildFrame`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMDIParentFrame` | An MDI (Multiple Document Interface) parent frame is a window which can contain MDI child. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMask` | This class encapsulates a monochrome mask bitmap, where the masked area is black and the. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMaximizeEvent` | An event being sent when a top level window is maximized. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMemoryDC` | A memory device context provides a means to draw graphics onto a bitmap. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMenu` | A menu is a popup (or pull down) list of items, one of which may be selected before the. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMenuBar` | A menu bar is a series of menus accessible from the top of a frame. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMenuEvent` | This class is used for a variety of menu-related events. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMenuItem` | A menu item represents an item in a menu. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMessageDialog` | This class represents a dialog that shows a single or multi-line message, with a choice. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMiniFrame` | A miniframe is a frame with a small title bar. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMirrorDC` | `m:wxMirrorDC` is a simple wrapper class which is always associated with a real `m:wxDC`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMouseCaptureChangedEvent` | An mouse capture changed event is sent to a window that loses its mouse capture. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMouseCaptureLostEvent` | A mouse capture lost event is sent to a window that had obtained mouse capture, which was. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMouseEvent` | This event class contains information about the events generated by the mouse: they. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMoveEvent` | A move event holds information about window position change. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxMultiChoiceDialog` | This class represents a dialog that shows a list of strings, and allows the user to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxNavigationKeyEvent` | This event class contains information about navigation events, generated by navigation. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxNotebook` | This class represents a notebook control, which manages multiple windows with associated. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxNotificationMessage` | This class allows showing the user a message non intrusively. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxNotifyEvent` | This class is not used by the event handlers by itself, but is a base class for other. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxOverlay` | Creates an overlay over an existing window, allowing for manipulations like. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPageSetupDialog` | This class represents the page setup common dialog. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPageSetupDialogData` | This class holds a variety of information related to `m:wxPageSetupDialog`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPaintDC` | A `m:wxPaintDC` must be constructed if an application wishes to paint on the client area. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPaintEvent` | A paint event is sent when a window's contents needs to be repainted. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPalette` | A palette is a table that maps pixel values to RGB colours. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPaletteChangedEvent` | Functions for wxPaletteChangedEvent class. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPanel` | A panel is a window on which controls are placed. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPasswordEntryDialog` | This class represents a dialog that requests a one-line password string from the user. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPen` | A pen is a drawing tool for drawing outlines. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPickerBase` | Base abstract class for all pickers which support an auxiliary text control. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPopupTransientWindow` | A `m:wxPopupWindow` which disappears automatically when the user clicks mouse outside it. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPopupWindow` | A special kind of top level window used for popup menus, combobox popups and such. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPostScriptDC` | This defines the wxWidgets Encapsulated PostScript device context, which can write. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPreviewCanvas` | A preview canvas is the default canvas used by the print preview system to display the. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPreviewControlBar` | This is the default implementation of the preview control bar, a panel with buttons and a. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPreviewFrame` | This class provides the default method of managing the print preview interface. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPrintData` | This class holds a variety of information related to printers and printer device. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPrintDialog` | This class represents the print and print setup common dialogs. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPrintDialogData` | This class holds information related to the visual characteristics of `m:wxPrintDialog`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPrintPreview` | Objects of this class manage the print preview process. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPrinter` | This class represents the Windows or PostScript printer, and is the vehicle through which. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxPrintout` | This class encapsulates the functionality of printing out an application document. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxProgressDialog` | If supported by the platform this class will provide the platform's native progress. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxQueryNewPaletteEvent` | Functions for wxQueryNewPaletteEvent class. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxRadioBox` | A radio box item is used to select one of number of mutually exclusive choices. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxRadioButton` | A radio button item is a button which usually denotes one of several mutually exclusive. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxRegion` | A `m:wxRegion` represents a simple or complex region on a device context or window. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSashEvent` | A sash event is sent when the sash of a `m:wxSashWindow` has been dragged by the user. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSashLayoutWindow` | `m:wxSashLayoutWindow` responds to OnCalculateLayout events generated by `m:wxLayoutAlgorithm`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSashWindow` | `m:wxSashWindow` allows any of its edges to have a sash which can be dragged to resize. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxScreenDC` | A `m:wxScreenDC` can be used to paint on the screen. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxScrollBar` | A `m:wxScrollBar` is a control that represents a horizontal or vertical scrollbar. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxScrollEvent` | A scroll event holds information about events sent from stand-alone scrollbars (see `m:wxScrollBar`). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxScrollWinEvent` | A scroll event holds information about events sent from scrolling windows. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxScrolledWindow` | The `wxScrolled` (not implemented in wx) class manages scrolling for its client area,. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSetCursorEvent` | A `m:wxSetCursorEvent` is generated from `m:wxWindow` when the mouse cursor is about to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxShowEvent` | An event being sent when the window is shown or hidden. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSingleChoiceDialog` | This class represents a dialog that shows a list of strings, and allows the user to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSizeEvent` | A size event holds information about size change events of `m:wxWindow`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSizer` | `m:wxSizer` is the abstract base class used for laying out subwindows in a window. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSizerFlags` | Container for sizer items flags providing readable names for them. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSizerItem` | The `m:wxSizerItem` class is used to track the position, size and other attributes of. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSlider` | A slider is a control with a handle which can be pulled back and forth to change the. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSpinButton` | A `m:wxSpinButton` has two small up and down (or left and right) arrow buttons. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSpinCtrl` | `m:wxSpinCtrl` combines `m:wxTextCtrl` and `m:wxSpinButton` in one control. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSpinEvent` | This event class is used for the events generated by `m:wxSpinButton` and `m:wxSpinCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSplashScreen` | `m:wxSplashScreen` shows a window with a thin border, displaying a bitmap describing your. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSplitterEvent` | This class represents the events generated by a splitter control. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSplitterWindow` | This class manages up to two subwindows. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStaticBitmap` | A static bitmap control displays a bitmap. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStaticBox` | A static box is a rectangle drawn around other windows to denote a logical grouping of. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStaticBoxSizer` | `m:wxStaticBoxSizer` is a sizer derived from `m:wxBoxSizer` but adds a static box around. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStaticLine` | A static line is just a line which may be used in a dialog to separate the groups of. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStaticText` | A static text control displays one or more lines of read-only text. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStatusBar` | A status bar is a narrow window that can be placed along the bottom of a frame to give. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStdDialogButtonSizer` | This class creates button layouts which conform to the standard button spacing and. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStyledTextCtrl` | A wxWidgets implementation of the Scintilla source code editing component. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxStyledTextEvent` | The type of events sent from `m:wxStyledTextCtrl`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSysColourChangedEvent` | This class is used for system colour change events, which are generated when the user. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSystemOptions` | `m:wxSystemOptions` stores option/value pairs that wxWidgets itself or applications can. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxSystemSettings` | `m:wxSystemSettings` allows the application to ask for details about the system. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTaskBarIcon` | This class represents a taskbar icon. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTaskBarIconEvent` | The event class used by `m:wxTaskBarIcon`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTextAttr` | `m:wxTextAttr` represents the character and paragraph attributes, or style, for a range. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTextCtrl` | A text control allows text to be displayed and edited. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTextDataObject` | `m:wxTextDataObject` is a specialization of `wxDataObjectSimple` (not implemented in wx). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTextEntryDialog` | This class represents a dialog that requests a one-line text string from the user. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxToggleButton` | `m:wxToggleButton` is a button that stays pressed when clicked by the user. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxToolBar` | A toolbar is a bar of buttons and/or other controls usually placed below the menu bar in. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxToolTip` | This class holds information about a tooltip associated with a window (see `wxWindow:setToolTip/2`). | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxToolbook` | `m:wxToolbook` is a class similar to `m:wxNotebook` but which uses a `m:wxToolBar` to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTopLevelWindow` | `m:wxTopLevelWindow` is a common base class for `m:wxDialog` and `m:wxFrame`. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTreeCtrl` | A tree control presents information as a hierarchy, with items that may be expanded to. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTreeEvent` | A tree event holds information about events associated with `m:wxTreeCtrl` objects. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxTreebook` | This class is an extension of the `m:wxNotebook` class that allows a tree structured set. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxUpdateUIEvent` | This class is used for pseudo-events which are called by wxWidgets to give an application. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxWebView` | This control may be used to render web (HTML / CSS / javascript) documents. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxWebViewEvent` | A navigation event holds information about events associated with `m:wxWebView` objects. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxWindow` | `m:wxWindow` is the base class for all windows and represents any visible object on. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxWindowCreateEvent` | This event is sent just after the actual window associated with a `m:wxWindow` object has. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxWindowDC` | A `m:wxWindowDC` must be constructed if an application wishes to paint on the whole area. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxWindowDestroyEvent` | This event is sent as early as possible during the window destruction process. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wxXmlResource` | This is the main class for interacting with the XML-based resource system. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wx_misc` | Miscellaneous functions. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:wx_object` | wx_object - Generic wx object behaviour. | [wx-2.5.2](`e:wx:index.html`) |\n|  `m:xmerl` | Functions for exporting XML data to an external format. | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xmerl_eventp` | Simple event-based processors (front-ends to `m:xmerl_scan`). | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xmerl_sax_parser` | XML SAX parser API. | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xmerl_scan` | Single pass XML scanner. | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xmerl_xpath` | Xpath 1.0 search implementation. | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xmerl_xs` | XSLT-like XML document transformations. | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xmerl_xsd` | Interface module for XML Schema validation. | [xmerl-2.1.7](`e:xmerl:index.html`) |\n|  `m:xref` | A Cross Reference Tool for analyzing dependencies between functions, modules,. | [tools-4.1.3](`e:tools:index.html`) |\n|  `m:yecc` | LALR-1 Parser Generator. | [parsetools-2.7](`e:parsetools:index.html`) |\n|  `m:zip` | Utility for reading and creating 'zip' archives. | [stdlib-7.1](`e:stdlib:index.html`) |\n|  `m:zlib` | zlib compression interface. | [erts-16.1.1](`e:erts:index.html`) |\n|  `m:zstd` | Zstandard compression interface. | [stdlib-7.1](`e:stdlib:index.html`) |\n\n\n\n\n<!-- Generated by otp_man_index -->","ref":"man_index.html"},{"type":"extras","title":"Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# Deprecations","ref":"deprecations.html"},{"type":"extras","title":"Introduction - Deprecations","doc":"This document lists all deprecated functionality in Erlang/OTP. For more\ninformation regarding the strategy regarding deprecations see the documentation\nof\n[Support, Compatibility, Deprecations, and Removal](`e:system:misc.md#deprecation`).","ref":"deprecations.html#introduction"},{"type":"extras","title":"OTP 28 - Deprecations","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2025. All Rights Reserved.\n\n%CopyrightEnd%\n-->","ref":"deprecations.html#otp-28"},{"type":"extras","title":"Distribution Control Messages - Deprecations","doc":"#### `ALIAS_SEND` and `ALIAS_SEND_TT`\n\nThe [`ALIAS_SEND`](`e:erts:erl_dist_protocol.md#ALIAS_SEND`) and\n[`ALIAS_SEND_TT`](`e:erts:erl_dist_protocol.md#ALIAS_SEND_TT`) distribution\ncontrol messages are as of OTP 28 deprecated and have been scheduled for removal in\nOTP 30. The support for these control messages are indicated by the\n[`DFLAG_ALIAS`](`e:erts:erl_dist_protocol.md#DFLAG_ALIAS`) distribution flag.\n\nThe `ALIAS_SEND` and `ALIAS_SEND_TT` control messages are as of OTP 28 replaced\nby the [`ALTACT_SIG_SEND`](`e:erts:erl_dist_protocol.md#ALTACT_SIG_SEND`)\ncontrol message. Support for the `ALTACT_SIG_SEND` control message is indicated\nby the [`DFLAG_ALTACT_SIG`](`e:erts:erl_dist_protocol.md#DFLAG_ALTACT_SIG`)\ndistribution flag.","ref":"deprecations.html#distribution-control-messages"},{"type":"extras","title":"Functions Deprecated in OTP 28 - Deprecations","doc":"-   `crypto:enable_fips_mode/1`  (use config parameter fips_mode)\n-   `crypto:start/0`  (use application:start(crypto) instead)\n-   `crypto:stop/0`  (use application:stop(crypto) instead)","ref":"deprecations.html#functions-deprecated-in-otp-28"},{"type":"extras","title":"OTP 27 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2024-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-27"},{"type":"extras","title":"Archives - Deprecations","doc":"The following features for archives are deprecated:\n\n* Using archives for packaging a single application or parts of a\n  single application into an archive file that is included in the code\n  path.\n\n* All functionality to handle archives in module\n  [`erl_prim_loader`](https://www.erlang.org/doc/man/erl_prim_loader).\n\n* The `-code_path_choice` flag for `erl`.\n\nUsing a single archive file for holding BEAM files and other data\nfiles in an Escript is **not** deprecated. However, to access files in\nthe archive the `escript:extract/2` function has to be used.","ref":"deprecations.html#archives"},{"type":"extras","title":"erl flags - Deprecations","doc":"The following erl flags are deprecated:\n\n* `-epmd_module Module` - deprecated in favour of the `kernel` application\n  parameter `epmd_module`.\n\n* `-erl_epmd_port Port` - deprecated in favour of the `kernel` application\n  parameter `erl_epmd_node_listen_port`.","ref":"deprecations.html#erl-flags"},{"type":"extras","title":"Functions Deprecated in OTP 27 - Deprecations","doc":"-   `code:lib_dir/2`  (this functionality will be removed in a future release)\n-   `mnesia_registry:create_table/_`  (use mnesia:create_table/2 instead)\n-   `ssl:prf/5`  (Use export_key_materials/4 instead. Note that in OTP 28 the 'testing' way of calling this function will no longer be supported.)","ref":"deprecations.html#functions-deprecated-in-otp-27"},{"type":"extras","title":"OTP 26 - Deprecations","doc":"","ref":"deprecations.html#otp-26"},{"type":"extras","title":"Functions Deprecated in OTP 26 - Deprecations","doc":"-   `dbg:stop_clear/0`  (use dbg:stop/0 instead)\n-   `disk_log:inc_wrap_file/1`  (use disk_log:next_file/1 instead)","ref":"deprecations.html#functions-deprecated-in-otp-26"},{"type":"extras","title":"OTP 25 - Deprecations","doc":"","ref":"deprecations.html#otp-25"},{"type":"extras","title":"Functions Deprecated in OTP 25 - Deprecations","doc":"-   `ct_slave:_/_`  (use ?CT_PEER(), or the 'peer' module instead)\n-   `slave:_/_`  (use the 'peer' module instead)","ref":"deprecations.html#functions-deprecated-in-otp-25"},{"type":"extras","title":"OTP 24 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-24"},{"type":"extras","title":"Erlang Distribution Without Large Node Container Support - Deprecations","doc":"Communication over the Erlang distribution without support for large\n[node container data types (version 4)](`e:erts:erl_dist_protocol.md#DFLAG_V4_NC`)\nis as of OTP 24 deprecated and is scheduled for removal in OTP 26. That is, as\nof OTP 26, support for large node container data types will become mandatory.","ref":"deprecations.html#erlang-distribution-without-large-node-container-support"},{"type":"extras","title":"Old Link Protocol - Deprecations","doc":"The old link protocol used when communicating over the Erlang distribution is as\nof OTP 24 deprecated and support for it is scheduled for removal in OTP 26. As\nof OTP 26, the\n[new link protocol](`e:erts:erl_dist_protocol.md#new_link_protocol`) will become\nmandatory. That is, Erlang nodes will then refuse to connect to nodes not\nimplementing the new link protocol. If you implement the Erlang distribution\nyourself, you are, however, encouraged to implement the new link protocol as\nsoon as possible since the old protocol can cause links to enter an inconsistent\nstate.\n\n### ?NO_APP macro\n\nThe ?NO_APP macro in the edoc include file `edoc_doclet.hrl` has been\ndeprecated.","ref":"deprecations.html#old-link-protocol"},{"type":"extras","title":"Functions Deprecated in OTP 24 - Deprecations","doc":"-   `erlang:phash/2` (use erlang:phash2/2 instead)\n-   `zlib:adler32/2` (use erlang:adler32/1 instead)\n-   `zlib:adler32/3` (use erlang:adler32/2 instead)\n-   `zlib:adler32_combine/4` (use erlang:adler_combine/3 instead)\n-   `zlib:crc32/1` (use erlang:crc32/1 on the uncompressed data instead)\n-   `zlib:crc32/2` (use erlang:crc32/1 instead)\n-   `zlib:crc32/3` (use erlang:crc32/2 instead)\n-   `zlib:crc32_combine/4` (use erlang:crc32_combine/3 instead)\n-   `zlib:getBufSize/1` (this function will be removed in a future release)\n-   `zlib:inflateChunk/1` (use safeInflate/2 instead)\n-   `zlib:inflateChunk/2` (use safeInflate/2 instead)\n-   `zlib:setBufSize/2` (this function will be removed in a future release)","ref":"deprecations.html#functions-deprecated-in-otp-24"},{"type":"extras","title":"Functions Deprecated in OTP 24 - Deprecations","doc":"-   `erlang:phash/2`  (use erlang:phash2/2 instead)","ref":"deprecations.html#functions-deprecated-in-otp-24-1"},{"type":"extras","title":"OTP 23 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-23"},{"type":"extras","title":"Crypto Old API - Deprecations","doc":"The [Old API](`e:crypto:new_api.md#the-old-api`) is deprecated as of OTP 23 and\nhas been [removed in OTP 24](removed.md#otp-24).\n\nFor replacement functions see the [New API](`e:crypto:new_api.md#the-new-api`).","ref":"deprecations.html#crypto-old-api"},{"type":"extras","title":"http_uri - Deprecations","doc":"Since OTP 21 the recommended module to handle URIs is `m:uri_string`. The module\nhttp_uri does not provide a implementation that satisfies the RFC.","ref":"deprecations.html#http_uri"},{"type":"extras","title":"ssh - Deprecations","doc":"The public key algorithm `'ssh-rsa` is regarded as insecure due to its usage of\nSHA1, and is therefore deprecated. It will not be available by default from\nOTP-24.\n\nThe public key algorithm `'ssh-dss` is regarded as insecure due to its usage of\nSHA1 and its short key length, and is therefore deprecated. It is not available\nby default from OTP-23.","ref":"deprecations.html#ssh"},{"type":"extras","title":"Distributed Disk Logs - Deprecations","doc":"As of OTP 23, the distributed `m:disk_log` feature has been deprecated and it\nhas also been [removed in OTP 24](removed.md#otp-24).","ref":"deprecations.html#distributed-disk-logs"},{"type":"extras","title":"erl_interface registry - Deprecations","doc":"As of OTP 23, the `registry` functionality part of `erl_interface` has been\ndeprecated and it has also been [removed in OTP 24](removed.md#otp-24).","ref":"deprecations.html#erl_interface-registry"},{"type":"extras","title":"Functions Deprecated in OTP 23 - Deprecations","doc":"-   `http_uri:decode/1` (use uri_string:unquote function instead)\n-   `http_uri:encode/1` (use uri_string:quote function instead)\n-   `httpd:parse_query/1` (use uri_string:dissect_query/1 instead)","ref":"deprecations.html#functions-deprecated-in-otp-23"},{"type":"extras","title":"Functions Deprecated in OTP 23 - Deprecations","doc":"-   `http_uri:decode/1`  (use uri_string:unquote function instead)\n-   `http_uri:encode/1`  (use uri_string:quote function instead)\n-   `httpd:parse_query/1`  (use uri_string:dissect_query/1 instead)","ref":"deprecations.html#functions-deprecated-in-otp-23-1"},{"type":"extras","title":"OTP 22 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-22"},{"type":"extras","title":"VxWorks Support - Deprecations","doc":"Some parts of OTP has had limited VxWorks support, such as for example\n[`erl_interface`](`e:erl_interface:index.html`). This support is as of OTP 22\nformally deprecated and has also been [removed in OTP 23](removed.md#otp-23).","ref":"deprecations.html#vxworks-support"},{"type":"extras","title":"Legacy parts of erl_interface - Deprecations","doc":"The old legacy [`erl_interface`](`e:erl_interface:index.html`) library\n(functions with prefix `erl_`) is deprecated as of OTP 22. These parts of\n`erl_interface` has been informally deprecated for a very long time. You\ntypically want to replace the usage of the `erl_interface` library with the use\nof the `ei` library which also is part of the `erl_interface` application. The\nold legacy [`erl_interface`](`e:erl_interface:index.html`) library has also been\n[removed in OTP 23](removed.md#otp-23).","ref":"deprecations.html#legacy-parts-of-erl_interface"},{"type":"extras","title":"System Events - Deprecations","doc":"The format of \"System Events\" as defined in the man page for `m:sys` has been\nclarified and cleaned up. Due to this, code that relied on the internal badly\ndocumented previous (before this change) format of OTP's \"System Events\", needs\nto be changed.\n\nIn the wake of this the function `sys:get_debug/3` that returns data with\nundocumented and internal format (and therefore is practically useless) has been\ndeprecated, and a new function `sys:get_log/1` has been added, that hopefully\ndoes what the deprecated function was intended for.","ref":"deprecations.html#system-events"},{"type":"extras","title":"Functions Deprecated in OTP 22 - Deprecations","doc":"-   `net:broadcast/3` (use rpc:eval_everywhere/3 instead)\n-   `net:call/4` (use rpc:call/4 instead)\n-   `net:cast/4` (use rpc:cast/4 instead)\n-   `net:ping/1` (use net_adm:ping/1 instead)\n-   `net:sleep/1` (use 'receive after T -> ok end' instead)\n-   `sys:get_debug/3` (incorrectly documented and only for internal use. Can\n    often be replaced with sys:get_log/1)","ref":"deprecations.html#functions-deprecated-in-otp-22"},{"type":"extras","title":"Functions Deprecated in OTP 22 - Deprecations","doc":"-   `net:broadcast/3`  (use rpc:eval_everywhere/3 instead)\n-   `net:call/4`  (use rpc:call/4 instead)\n-   `net:cast/4`  (use rpc:cast/4 instead)\n-   `net:ping/1`  (use net_adm:ping/1 instead)\n-   `net:sleep/1`  (use 'receive after T -> ok end' instead)\n-   `sys:get_debug/3`  (incorrectly documented and only for internal use. Can often be replaced with sys:get_log/1)","ref":"deprecations.html#functions-deprecated-in-otp-22-1"},{"type":"extras","title":"OTP 20 - Deprecations","doc":"","ref":"deprecations.html#otp-20"},{"type":"extras","title":"Functions Deprecated in OTP 20 - Deprecations","doc":"-   `crypto:rand_uniform/2`  (use rand:uniform/1 instead)\n-   `gen_fsm:_/_`  (use the 'gen_statem' module instead)","ref":"deprecations.html#functions-deprecated-in-otp-20"},{"type":"extras","title":"OTP 19 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-19"},{"type":"extras","title":"SSL/TLS - Deprecations","doc":"For security reasons SSL-3.0 is no longer supported by default, but can be\nconfigured.","ref":"deprecations.html#ssl-tls"},{"type":"extras","title":"Functions Deprecated in OTP 19 - Deprecations","doc":"-   `queue:lait/1`  (use queue:liat/1 instead)\n-   `random:_/_`  (use the 'rand' module instead)","ref":"deprecations.html#functions-deprecated-in-otp-19"},{"type":"extras","title":"OTP 18 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-18"},{"type":"extras","title":"erlang:now/0 - Deprecations","doc":"New time functionality and a new time API was introduced. For more information\nsee the [Time and Time Correction](`e:erts:time_correction.md`) chapter in the\nERTS User's guide and specifically the\n[Dos and Donts](`e:erts:time_correction.md#Dos_and_Donts`) section on how to\nreplace usage of `erlang:now/0`.","ref":"deprecations.html#erlang-now-0"},{"type":"extras","title":"httpd_conf module - Deprecations","doc":"API functions in the module `httpd_conf` was deprecated in favor of standard\nmodules such as `lists`, `string`, `filelib`, and `erlang`.","ref":"deprecations.html#httpd_conf-module"},{"type":"extras","title":"Functions Deprecated in OTP 18 - Deprecations","doc":"-   `erlang:now/0`  (see the \"Time and Time Correction in Erlang\" chapter of the ERTS User's Guide for more information)","ref":"deprecations.html#functions-deprecated-in-otp-18"},{"type":"extras","title":"OTP 16 - Deprecations","doc":"","ref":"deprecations.html#otp-16"},{"type":"extras","title":"Functions Deprecated in OTP 16 - Deprecations","doc":"-   `wxCalendarCtrl:enableYearChange/1`  (not available in wxWidgets-2.9 and later)\n-   `wxCalendarCtrl:enableYearChange/2`  (not available in wxWidgets-2.9 and later)","ref":"deprecations.html#functions-deprecated-in-otp-16"},{"type":"extras","title":"OTP 12 - Deprecations","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"deprecations.html#otp-12"},{"type":"extras","title":"inets - httpd Apache config files - Deprecations","doc":"A new config file format was introduced.","ref":"deprecations.html#inets-httpd-apache-config-files"},{"type":"extras","title":"Functions Deprecated in OTP 12 - Deprecations","doc":"-   `auth:cookie/0`  (use erlang:get_cookie/0 instead)\n-   `auth:cookie/1`  (use erlang:set_cookie/2 instead)\n-   `auth:is_auth/1`  (use net_adm:ping/1 instead)\n-   `auth:node_cookie/_`  (use erlang:set_cookie/2 and net_adm:ping/1 instead)\n-   `calendar:local_time_to_universal_time/1`  (use calendar:local_time_to_universal_time_dst/1 instead)","ref":"deprecations.html#functions-deprecated-in-otp-12"},{"type":"extras","title":"Removed Functionality","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# Removed Functionality","ref":"removed.html"},{"type":"extras","title":"Introduction - Removed Functionality","doc":"This document lists all removed functionality in Erlang/OTP. For more\ninformation regarding the strategy regarding removals see the documentation of\n[Support, Compatibility, Deprecations, and Removal](`e:system:misc.md#removal`).","ref":"removed.html#introduction"},{"type":"extras","title":"OTP 27 - Removed Functionality","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2024-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"removed.html#otp-27"},{"type":"extras","title":"Vanilla Driver - Removed Functionality","doc":"The obsolete and undocumented support for opening a port to an external\nresource by passing an atom (or a string) as first argument to\n[`open_port()`](`erlang:open_port/2`), implemented by the vanilla driver,\nhas been removed. This feature has been scheduled for removal in OTP 27\nsince the release of OTP 26.","ref":"removed.html#vanilla-driver"},{"type":"extras","title":"Functions Removed in OTP 27 - Removed Functionality","doc":"-   `crypto:crypto_dyn_iv_init/3`  (not supported, use crypto:crypto_init/4)\n-   `crypto:crypto_dyn_iv_update/3`  (not supported, use crypto:crypto_update/2)\n-   `file:pid2name/1`  (this functionality is no longer supported)\n-   `zlib:adler32/2`  (use erlang:adler32/1 instead)\n-   `zlib:adler32/3`  (use erlang:adler32/2 instead)\n-   `zlib:adler32_combine/4`  (use erlang:adler_combine/3 instead)\n-   `zlib:crc32/1`  (use erlang:crc32/1 on the uncompressed data instead)\n-   `zlib:crc32/2`  (use erlang:crc32/1 instead)\n-   `zlib:crc32/3`  (use erlang:crc32/2 instead)\n-   `zlib:crc32_combine/4`  (use erlang:crc32_combine/3 instead)\n-   `zlib:getBufSize/1`  (this function has been removed)\n-   `zlib:inflateChunk/1`  (use zlib:safeInflate/2 instead)\n-   `zlib:inflateChunk/2`  (use zlib:safeInflate/2 instead)\n-   `zlib:setBufSize/2`  (this function has been removed)","ref":"removed.html#functions-removed-in-otp-27"},{"type":"extras","title":"OTP 26 - Removed Functionality","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"removed.html#otp-26"},{"type":"extras","title":"Erlang Distribution Without Large Node Container Support - Removed Functionality","doc":"Communication over the Erlang distribution without support for large\n[node container data types (version 4)](`e:erts:erl_dist_protocol.md#DFLAG_V4_NC`)\nwas as of [OTP 24 deprecated](deprecations.md#otp-24) and support for it was\nscheduled for removal in OTP 26. That is, as of OTP 26, support for large node\ncontainer data types will become mandatory. This also includes external term\nformat produced by `term_to_binary()`/`term_to_iovec()`.","ref":"removed.html#erlang-distribution-without-large-node-container-support"},{"type":"extras","title":"Old Link Protocol - Removed Functionality","doc":"The old link protocol used when communicating over the Erlang distribution was\nas of [OTP 24 deprecated](deprecations.md#otp-24) and support for it was\nscheduled for removal in OTP 26. As of OTP 26 the\n[new link protocol](`e:erts:erl_dist_protocol.md#new_link_protocol`) became\nmandatory. That is, Erlang nodes will refuse to connect to nodes not\nimplementing the new link protocol.","ref":"removed.html#old-link-protocol"},{"type":"extras","title":"Functions Removed in OTP 26 - Removed Functionality","doc":"-   `code:is_module_native/1` (HiPE has been removed)\n-   `code:rehash/0` (the code path cache feature has been removed)\n-   `disk_log:accessible_logs/0` (use disk_log:all/0 instead)\n-   `disk_log:lclose/1` (use disk_log:close/1 instead)\n-   `disk_log:lclose/2` (use disk_log:close/1 instead)\n-   `erts_alloc_config:_/_` (this module has as of OTP 26.0 been removed)\n-   `ftp:start_service/1` (use ftp:open/2 instead)\n-   `ftp:stop_service/1` (use ftp:close/1 instead)\n-   `httpd_util:decode_hex/1` (use uri_string:unquote function instead)\n-   `httpd_util:encode_hex/1` (use uri_string:quote function instead)\n-   `httpd_util:flatlength/1` (use erlang:iolist_size/1 instead)\n-   `httpd_util:hexlist_to_integer/1` (use erlang:list_to_integer/2 with base 16\n    instead)\n-   `httpd_util:integer_to_hexlist/1` (use erlang:integer_to_list/2 with base 16\n    instead)\n-   `httpd_util:strip/1` (use string:trim/1 instead)\n-   `httpd_util:suffix/1` (use filename:extension/1 and string:trim/2 instead)","ref":"removed.html#functions-removed-in-otp-26"},{"type":"extras","title":"Functions Removed in OTP 26 - Removed Functionality","doc":"-   `code:is_module_native/1`  (HiPE has been removed)\n-   `code:rehash/0`  (the code path cache feature has been removed)\n-   `disk_log:accessible_logs/0`  (use disk_log:all/0 instead)\n-   `disk_log:lclose/1`  (use disk_log:close/1 instead)\n-   `disk_log:lclose/2`  (use disk_log:close/1 instead)\n-   `erts_alloc_config:_/_`  (this module has as of OTP 26.0 been removed)\n-   `ftp:start_service/1`  (use ftp:open/2 instead)\n-   `ftp:stop_service/1`  (use ftp:close/1 instead)\n-   `httpd_util:decode_hex/1`  (use uri_string:unquote function instead)\n-   `httpd_util:encode_hex/1`  (use uri_string:quote function instead)\n-   `httpd_util:flatlength/1`  (use erlang:iolist_size/1 instead)\n-   `httpd_util:hexlist_to_integer/1`  (use erlang:list_to_integer/2 with base 16 instead)\n-   `httpd_util:integer_to_hexlist/1`  (use erlang:integer_to_list/2 with base 16 instead)\n-   `httpd_util:strip/1`  (use string:trim/1 instead)\n-   `httpd_util:suffix/1`  (use filename:extension/1 and string:trim/2 instead)","ref":"removed.html#functions-removed-in-otp-26-1"},{"type":"extras","title":"OTP 25 - Removed Functionality","doc":"","ref":"removed.html#otp-25"},{"type":"extras","title":"Functions Removed in OTP 25 - Removed Functionality","doc":"-   `filename:safe_relative_path/1`  (use filelib:safe_relative_path/2 instead)\n-   `http_uri:parse/1`  (use uri_string functions instead)\n-   `http_uri:parse/2`  (use uri_string functions instead)\n-   `http_uri:scheme_defaults/0`  (use uri_string functions instead)\n-   `public_key:ssh_decode/2`  (use ssh_file:decode/2 instead)\n-   `public_key:ssh_encode/2`  (use ssh_file:encode/2 instead)\n-   `public_key:ssh_hostkey_fingerprint/1`  (use ssh:hostkey_fingerprint/1 instead)\n-   `public_key:ssh_hostkey_fingerprint/2`  (use ssh:hostkey_fingerprint/2 instead)","ref":"removed.html#functions-removed-in-otp-25"},{"type":"extras","title":"OTP 24 - Removed Functionality","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"removed.html#otp-24"},{"type":"extras","title":"erl_interface registry - Removed Functionality","doc":"The `registry` functionality part of `erl_interface` was as of\n[OTP 23 deprecated](deprecations.md#otp-23) and was removed in OTP 24.","ref":"removed.html#erl_interface-registry"},{"type":"extras","title":"Compilation of Latin-1 Encoded Erlang Files - Removed Functionality","doc":"The Erlang compiler now refuses to compile source files encoded in Latin-1\nwithout a `%% coding: latin-1` comment at the beginning of the file.","ref":"removed.html#compilation-of-latin-1-encoded-erlang-files"},{"type":"extras","title":"igor and erl_tidy modules in syntax_tools - Removed Functionality","doc":"The `igor` and `erl_tidy` modules have been removed from OTP and is now\nmaintained by their original author Richard Carlsson. They can be found at\n[github.com/richcarl/igor](https://github.com/richcarl/igor) and\n[github.com/richcarl/erl_tidy](https://github.com/richcarl/erl_tidy),\nrespectively.","ref":"removed.html#igor-and-erl_tidy-modules-in-syntax_tools"},{"type":"extras","title":"Distributed Disk Logs - Removed Functionality","doc":"The distributed `m:disk_log` feature was as of\n[OTP 23 deprecated](deprecations.md#otp-23) and was removed in OTP 24.","ref":"removed.html#distributed-disk-logs"},{"type":"extras","title":"Old Crypto API - Removed Functionality","doc":"The [Old API](`e:crypto:new_api.md#the-old-api`) was removed in OTP 24. The\nsupport was formally deprecated as of OTP 23.\n\nFor replacement functions see the [New API](`e:crypto:new_api.md#the-new-api`).","ref":"removed.html#old-crypto-api"},{"type":"extras","title":"Megaco version 3 encoding config - Removed Functionality","doc":"The pre-release version 3 encoding configs; `prev3a`, `prev3b` and `prev3c` was\nremoved in OTP 24. Use the full version instead.\n\nThe (encoding) config option for the full version, `{version3, 3}`, will still\nbe supported, even though its no longer necessary to specify it this way.","ref":"removed.html#megaco-version-3-encoding-config"},{"type":"extras","title":"Functions Removed in OTP 24 - Removed Functionality","doc":"-   `crypto:block_decrypt/3`  (use crypto:crypto_one_time/4 or crypto:crypto_init/3 + crypto:crypto_update/2 + crypto:crypto_final/1 instead)\n-   `crypto:block_decrypt/4`  (use crypto:crypto_one_time/5, crypto:crypto_one_time_aead/6,7 or crypto:crypto_init + crypto:crypto_update + crypto:crypto_final instead)\n-   `crypto:block_encrypt/3`  (use crypto:crypto_one_time/4 or crypto:crypto_init/3 + crypto:crypto_update/2 + crypto:crypto_final/1 instead)\n-   `crypto:block_encrypt/4`  (use crypto:crypto_one_time/5, crypto:crypto_one_time_aead/6,7 or crypto:crypto_init + crypto:crypto_update + crypto:crypto_final instead)\n-   `crypto:cmac/3`  (use crypto:mac/4 instead)\n-   `crypto:cmac/4`  (use crypto:macN/5 instead)\n-   `crypto:hmac/3`  (use crypto:mac/4 instead)\n-   `crypto:hmac/4`  (use crypto:macN/5 instead)\n-   `crypto:hmac_final/1`  (use crypto:mac_final/1 instead)\n-   `crypto:hmac_final_n/2`  (use crypto:mac_finalN/2 instead)\n-   `crypto:hmac_init/2`  (use crypto:mac_init/3 instead)\n-   `crypto:hmac_update/2`  (use crypto:mac_update/2 instead)\n-   `crypto:next_iv/_`  (see the 'New and Old API' chapter of the CRYPTO User's guide)\n-   `crypto:poly1305/2`  (use crypto:mac/3 instead)\n-   `crypto:stream_decrypt/2`  (use crypto:crypto_update/2 instead)\n-   `crypto:stream_encrypt/2`  (use crypto:crypto_update/2 instead)\n-   `crypto:stream_init/_`  (use crypto:crypto_init/3 + crypto:crypto_update/2 + crypto:crypto_final/1 or crypto:crypto_one_time/4 instead)\n-   `filename:find_src/_`  (use filelib:find_source/1,3 instead)\n-   `pg2:_/_`  (this module was removed in OTP 24. Use 'pg' instead)\n-   `ssl:cipher_suites/0`  (use ssl:cipher_suites/2,3 instead)\n-   `ssl:cipher_suites/1`  (use ssl:cipher_suites/2,3 instead)\n-   `ssl:ssl_accept/_`  (use ssl:handshake/1,2,3 instead)","ref":"removed.html#functions-removed-in-otp-24"},{"type":"extras","title":"OTP 23 - Removed Functionality","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"removed.html#otp-23"},{"type":"extras","title":"VxWorks Support - Removed Functionality","doc":"Some parts of OTP has had limited VxWorks support, such as\n[`erl_interface`](`e:erl_interface:index.html`). This support was removed in\nOTP 23. This limited support was formally deprecated as of OTP 22.","ref":"removed.html#vxworks-support"},{"type":"extras","title":"Legacy parts of erl_interface - Removed Functionality","doc":"The old legacy [`erl_interface`](`e:erl_interface:index.html`) library\n(functions with prefix `erl_`) was removed in OTP 23. These parts of\n`erl_interface` has been informally deprecated for a very long time, and was\nformally deprecated in OTP 22. You typically want to replace the usage of the\n`erl_interface` library with the use of the `ei` library which also is part of\nthe `erl_interface` application.","ref":"removed.html#legacy-parts-of-erl_interface"},{"type":"extras","title":"httpd_conf module - Removed Functionality","doc":"API functions in the module called `httpd_conf` was deprecated in favor of\nstandard modules such as `lists`, `string`, `filelib`, and `erlang`. Formally\ndeprecated as of OTP 18.","ref":"removed.html#httpd_conf-module"},{"type":"extras","title":"inets - httpd Apache config files - Removed Functionality","doc":"Support for the Apache-compatible config files was removed in OTP 23. A new\nconfig file format was introduced in OTP 12.","ref":"removed.html#inets-httpd-apache-config-files"},{"type":"extras","title":"SSL/TLS - Removed Functionality","doc":"For security reasons SSL-3.0 is no longer supported at all.","ref":"removed.html#ssl-tls"},{"type":"extras","title":"Functions Removed in OTP 23 - Removed Functionality","doc":"-   `erlang:get_stacktrace/0`  (use the new try/catch syntax for retrieving the stack backtrace)\n-   `httpd_conf:check_enum/2`  (use lists:member/2 instead)\n-   `httpd_conf:clean/1`  (use string:strip/1 instead or possibly the re module)\n-   `httpd_conf:custom_clean/3`  (use string:strip/1 instead or possibly the re module)\n-   `httpd_conf:is_directory/1`  (use filelib:is_dir/1 instead)\n-   `httpd_conf:is_file/1`  (use filelib:is_file/1 instead)\n-   `httpd_conf:make_integer/1`  (use erlang:list_to_integer/1 instead)","ref":"removed.html#functions-removed-in-otp-23"},{"type":"extras","title":"OTP 22 - Removed Functionality","doc":"","ref":"removed.html#otp-22"},{"type":"extras","title":"Functions Removed in OTP 22 - Removed Functionality","doc":"-   `os_mon_mib:_/_`  (this module was removed in OTP 22.0)","ref":"removed.html#functions-removed-in-otp-22"},{"type":"extras","title":"OTP 20 - Removed Functionality","doc":"","ref":"removed.html#otp-20"},{"type":"extras","title":"Functions Removed in OTP 20 - Removed Functionality","doc":"-   `asn1ct:decode/_`  (use Mod:decode/2 instead)\n-   `asn1ct:encode/_`  (use Mod:encode/2 instead)\n-   `erlang:hash/2`  (use erlang:phash2/2 instead)\n-   `ssl:connection_info/1`  (use ssl:connection_information/1,2 instead)\n-   `ssl:negotiated_next_protocol/1`  (use ssl:negotiated_protocol/1 instead)","ref":"removed.html#functions-removed-in-otp-20"},{"type":"extras","title":"OTP 19 - Removed Functionality","doc":"","ref":"removed.html#otp-19"},{"type":"extras","title":"Functions Removed in OTP 19 - Removed Functionality","doc":"-   `core_lib:get_anno/1`  (use cerl:get_ann/1 instead)\n-   `core_lib:is_literal/1`  (use cerl:is_literal/1 instead)\n-   `core_lib:is_literal_list/1`  (use cerl:is_literal_list/1 instead)\n-   `core_lib:literal_value/1`  (use cerl:concrete/1 instead)\n-   `core_lib:set_anno/2`  (use cerl:set_ann/2 instead)\n-   `erl_lint:modify_line/2`  (use erl_parse:map_anno/2 instead)\n-   `erl_parse:get_attribute/2`  (erl_anno:{column,line,location,text}/1 instead)\n-   `erl_parse:get_attributes/1`  (erl_anno:{column,line,location,text}/1 instead)\n-   `erl_parse:set_line/2`  (use erl_anno:set_line/2)\n-   `erl_scan:attributes_info/_`  (use erl_anno:{column,line,location,text}/1 instead)\n-   `erl_scan:set_attribute/3`  (use erl_anno:set_line/2 instead)\n-   `erl_scan:token_info/_`  (use erl_scan:{category,column,line,location,symbol,text}/1 instead)\n-   `rpc:safe_multi_server_call/2`  (use rpc:multi_server_call/2 instead)\n-   `rpc:safe_multi_server_call/3`  (use rpc:multi_server_call/3 instead)","ref":"removed.html#functions-removed-in-otp-19"},{"type":"extras","title":"Scheduled for Removal","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2023-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->\n# Scheduled for Removal","ref":"scheduled_for_removal.html"},{"type":"extras","title":"Introduction - Scheduled for Removal","doc":"This document list all functionality in Erlang/OTP that currently are scheduled\nfor removal. For more information regarding the strategy regarding removal of\nfunctionality see the documentation of\n[Support, Compatibility, Deprecations, and Removal](`e:system:misc.md#removal`).","ref":"scheduled_for_removal.html#introduction"},{"type":"extras","title":"OTP 30 - Scheduled for Removal","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2025. All Rights Reserved.\n\n%CopyrightEnd%\n-->","ref":"scheduled_for_removal.html#otp-30"},{"type":"extras","title":"Distribution Control Messages - Scheduled for Removal","doc":"#### `ALIAS_SEND` and `ALIAS_SEND_TT`\n\nThe [`ALIAS_SEND`](`e:erts:erl_dist_protocol.md#ALIAS_SEND`) and\n[`ALIAS_SEND_TT`](`e:erts:erl_dist_protocol.md#ALIAS_SEND_TT`) distribution\ncontrol messages are as of OTP 28 deprecated and have been scheduled for removal in\nOTP 30. The support for these control messages are indicated by the\n[`DFLAG_ALIAS`](`e:erts:erl_dist_protocol.md#DFLAG_ALIAS`) distribution flag.\n\nThe `ALIAS_SEND` and `ALIAS_SEND_TT` control messages are as of OTP 28 replaced\nby the [`ALTACT_SIG_SEND`](`e:erts:erl_dist_protocol.md#ALTACT_SIG_SEND`)\ncontrol message. Support for the `ALTACT_SIG_SEND` control message is indicated\nby the [`DFLAG_ALTACT_SIG`](`e:erts:erl_dist_protocol.md#DFLAG_ALTACT_SIG`)\ndistribution flag.","ref":"scheduled_for_removal.html#distribution-control-messages"},{"type":"extras","title":"OTP 29 - Scheduled for Removal","doc":"","ref":"scheduled_for_removal.html#otp-29"},{"type":"extras","title":"Functions Scheduled for Removal in OTP 29 - Scheduled for Removal","doc":"-   `ct_slave:_/_`  (use ?CT_PEER(), or the 'peer' module instead)\n-   `slave:_/_`  (use the 'peer' module instead)","ref":"scheduled_for_removal.html#functions-scheduled-for-removal-in-otp-29"},{"type":"extras","title":"OTP 28 - Scheduled for Removal","doc":"<!--\n%% %CopyrightBegin%\n%%\n%% SPDX-License-Identifier: Apache-2.0\n%%\n%% Copyright Ericsson AB 2024-2025. All Rights Reserved.\n%%\n%% Licensed under the Apache License, Version 2.0 (the \"License\");\n%% you may not use this file except in compliance with the License.\n%% You may obtain a copy of the License at\n%%\n%%     http://www.apache.org/licenses/LICENSE-2.0\n%%\n%% Unless required by applicable law or agreed to in writing, software\n%% distributed under the License is distributed on an \"AS IS\" BASIS,\n%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n%% See the License for the specific language governing permissions and\n%% limitations under the License.\n%%\n%% %CopyrightEnd%\n-->","ref":"scheduled_for_removal.html#otp-28"},{"type":"extras","title":"Archives - Scheduled for Removal","doc":"The following features of archives will be removed:\n\n* Using archives for packaging a single application or parts of a single application\n  into an archive file that is included in the code path.\n\n* All functionality to handle archives in module `m:erl_prim_loader`.\n\n* The `-code_path_choice` flag for `erl`.\n\nThe functionality to use a single archive file in Escripts is **not**\ndeprecated and will continue to work.  However, to access files in the\narchive, the `escript:extract/2` function has to be used.","ref":"scheduled_for_removal.html#archives"},{"type":"extras","title":"Functions Scheduled for Removal in OTP 28 - Scheduled for Removal","doc":"-   `disk_log:inc_wrap_file/1`  (use disk_log:next_file/1 instead)\n-   `mnesia_registry:create_table/_`  (use mnesia:create_table/2 instead)","ref":"scheduled_for_removal.html#functions-scheduled-for-removal-in-otp-28"},{"type":"extras","title":"OTP 27 - Scheduled for Removal","doc":"","ref":"scheduled_for_removal.html#otp-27"},{"type":"extras","title":"Functions Scheduled for Removal in OTP 27 - Scheduled for Removal","doc":"-   `dbg:stop_clear/0`  (use dbg:stop/0 instead)","ref":"scheduled_for_removal.html#functions-scheduled-for-removal-in-otp-27"},{"type":"extras","title":"Upcoming Potential Incompatibilities","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Upcoming Potential Incompatibilities","ref":"upcoming_incompatibilities.html"},{"type":"extras","title":"Introduction - Upcoming Potential Incompatibilities","doc":"This document lists planned upcoming potential incompatibilities in Erlang/OTP.","ref":"upcoming_incompatibilities.html#introduction"},{"type":"extras","title":"OTP 27 - Upcoming Potential Incompatibilities","doc":"","ref":"upcoming_incompatibilities.html#otp-27"},{"type":"extras","title":"Fun creator pid will always be local init process - Upcoming Potential Incompatibilities","doc":"As of OTP 27, the functions [`erlang:fun_info/1,2`](`erlang:fun_info/1`) will\nalways say that the local `init` process created all funs, regardless of which\nprocess or node the fun was originally created on.\n\nIn OTP 28, the `{pid,_}`element will be removed altogether.\n\n[](){: #maybe_expr }","ref":"upcoming_incompatibilities.html#fun-creator-pid-will-always-be-local-init-process"},{"type":"extras","title":"Feature maybe_expr will be enabled by default - Upcoming Potential Incompatibilities","doc":"As of OTP 27, the `maybe_expr` feature will be approved and enabled by default.\nThat means that code that uses the unquoted atom `maybe` will fail to compile.\nAll uses of `maybe` as an atom will need to be quoted. Alternatively, as a\nshort-term solution, the `maybe_expr` feature can be disabled.\n\nIt is recommend to quote all uses of the atom `maybe` as soon as possible. The\ncompiler option `warn_keywords` can be used to emit warnings about all\noccurrences of `maybe` without quotes.\n\n[](){: #float_matching }","ref":"upcoming_incompatibilities.html#feature-maybe_expr-will-be-enabled-by-default"},{"type":"extras","title":"0.0 and -0.0 will no longer be exactly equal - Upcoming Potential Incompatibilities","doc":"Currently, the floating point numbers `0.0` and `-0.0` have distinct internal\nrepresentations. That can be seen if they are converted to binaries:\n\n```erlang\n1> <<0.0/float>>.\n<<0,0,0,0,0,0,0,0>>\n2> <<-0.0/float>>.\n<<128,0,0,0,0,0,0,0>>\n```\n\nHowever, when they are matched against each other or compared using the `=:=`\noperator, they are considered to be equal. Thus, `0.0 =:= -0.0` currently\nreturns `true`.\n\nIn Erlang/OTP 27, `0.0 =:= -0.0` will return `false`, and matching `0.0` against\n`-0.0` will fail. When used as map keys, `0.0` and `-0.0` will be considered to\nbe distinct.\n\nThe `==` operator will continue to return `true` for `0.0 == -0.0`.\n\nTo help to find code that might need to be revised, in OTP 27 there will be a\nnew compiler warning when matching against `0.0` or comparing to that value\nusing the `=:=` operator. The warning can be suppressed by matching against\n`+0.0` instead of `0.0`.\n\nWe plan to introduce the same warning in OTP 26.1, but by default it will be\ndisabled.\n\n[](){: #singleton_typevars }","ref":"upcoming_incompatibilities.html#0-0-and-0-0-will-no-longer-be-exactly-equal"},{"type":"extras","title":"Singleton type variables will become a compile-time error - Upcoming Potential Incompatibilities","doc":"Before Erlang/OTP 26, the compiler would silenty accept the following spec:\n\n```erlang\n-spec f(Opts) -> term() when\n    Opts :: {ok, Unknown} | {error, Unknown}.\nf(_) -> error.\n```\n\nIn OTP 26, the compiler emits a warning pointing out that the type variable\n`Unknown` is unbound:\n\n```erlang\nt.erl:6:18: Warning: type variable 'Unknown' is only used once (is unbound)\n%    6|     Opts :: {ok, Unknown} | {error, Unknown}.\n%     |                  ^\n```\n\nIn OTP 27, that warning will become an error.\n\n[](){: #escripts_will_be_compiled }","ref":"upcoming_incompatibilities.html#singleton-type-variables-will-become-a-compile-time-error"},{"type":"extras","title":"Escripts will be compiled by default - Upcoming Potential Incompatibilities","doc":"Escripts will be compiled by default instead of interpreted. That means that the\n`compiler` application must be available.\n\nThe old behavior of interpreting escripts can be restored by adding the\nfollowing line to the script file:\n\n```erlang\n-mode(interpret).\n```\n\nIn OTP 28, support for interpreting an escript will be removed.\n\n### \\-code_path_choice will default to strict\n\nThis command line option controls if paths given in the command line, boot\nscripts, and the code server should be interpreted as is strict or relaxed.\n\nOTP 26 and earlier defaults to `relaxed`, which means `-pa myapp/ebin` would\nattempt to load `-pa myapp/ebin` and `-pa myapp/myapp/ebin`. The option will\ndefault to strict in OTP 27.","ref":"upcoming_incompatibilities.html#escripts-will-be-compiled-by-default"},{"type":"extras","title":"Archive fallbacks will be removed - Upcoming Potential Incompatibilities","doc":"OTP 26 and earlier allows an application to have part of its directories as\nregular folders and others as archives. This functionality was previously used\nby reltool but it is no longer the case from OTP 26. Support for archive\nfallbacks will be removed from the code server in OTP 27.\n\n[](){: #triple_quoted_strings }","ref":"upcoming_incompatibilities.html#archive-fallbacks-will-be-removed"},{"type":"extras","title":"Triple-Quoted Strings - Upcoming Potential Incompatibilities","doc":"Before Erlang/OTP 27 a sequence of 3 or more double-quote characters was grouped\nin pairs each meaning the empty string and if there was an odd number the last\ncharacter was the start of a string. The empty strings were then concatenated\nand effectively disappeared.\n\nIn Erlang/OTP 27; 3 or more double-quote characters are interpreted as the start\nof a \"Triple-Quoted String\". See [EEP 64](https://www.erlang.org/eeps/eep-0064).\n\nHere follows some examples of code that would change meaning. Note that all\nthese examples before Erlang/OTP 27.0 was strange since there was no sensible\nreason to write like that.\n\n```erlang\n\"\"\"String Content\"\"\"\n%% Was interpreted as\n\"\" \"String Content\" \"\"\n%% Which becomes\n\"String Content\"\n%%\n%% In OTP 27 it is instead a syntax error since no text is allowed\n%% on the line after an opening triple-quote\n```\n\n```text\n\"\"\"\nString Content\n\"\"\"\n%% Was interpreted as\n\"\" \"\nString Content\n\" \"\"\n%% Which becomes\n\"\nString Content\n\"\n%%\n%% In OTP 27 it is instead interpreted as a\n%% Triple-Quoted String equivalent to\n\"String Content\"\n```\n\n```erlang\n\"\"\"\"\n++ foo() ++\n\"\"\"\"\n%% Became\n\"\" ++ foo() ++ \"\"\n%%\n%% In OTP 27 it is instead interpreted as a\n%% Triple-Quoted String (triple-or-more) equivalent to\n\"++ foo() ++\"\n```\n\nFrom Erlang/OTP 26.1 up to 27.0 the compiler issues a warning for a sequence of\n3 or more double-quote characters since that is almost certainly a mistake or\nsomething like a result of bad automatic code generation. If a users gets that\nwarning, the code should be corrected for example by inserting appropriate\nspaces between the empty strings, or removing the redundant ones alltogether,\nwhich will have the same meaning before and after Erlang/OTP 27.","ref":"upcoming_incompatibilities.html#triple-quoted-strings"},{"type":"extras","title":"OTP 28 - Upcoming Potential Incompatibilities","doc":"[](){: #new_re_engine }","ref":"upcoming_incompatibilities.html#otp-28"},{"type":"extras","title":"The re module will use a different regular expression engine - Upcoming Potential Incompatibilities","doc":"The functionality of module `m:re` is currently provided by the PCRE library,\nwhich is no longer actively maintained. Therefore, in OTP 28, we will switch to\na different regular expression library.\n\nThe source code for PCRE used by the `re` module has been modified by the OTP\nteam to ensure that a regular expression match would yield when matching huge\ninput binaries and/or when using demanding (back-tracking) regular expressions.\nBecause of the those modifications, moving to a new version of PCRE has always\nbeen a time-consuming process because all of the modifications had to be applied\nby hand again to the updated PCRE source code.\n\nMost likely, the new regular expression library will be\n[RE2](https://github.com/google/re2). RE2 guarantees that the match time is\nlinear in the length of input string, and it also eschews recursion to avoid\nstack overflow. That should make it possible to use RE2 without modifying its\nsource code. For more information about why RE2 is a good choice, see\n[WhyRE2](https://github.com/google/re2/wiki/WhyRE2).\n\nSome of implications of this change are:\n\n- We expect that the functions in the `re` module will continue to be supported,\n  although some of the options are likely to be dis-continued.\n- It is likely that only pattern matching of UTF8-encoded binaries will be\n  supported (not Latin1-encoded binaries).\n- In order to guarantee the linear-time performance, RE2 does not support all\n  the constructs in regular expression patterns that PCRE do. For example,\n  backreferences and look-around assertions are not supported. See\n  [Syntax](https://github.com/google/re2/wiki/Syntax) for a description of what\n  RE2 supports.\n- Compiling a regular expression is likely to be slower, and thus more can be\n  gained by explicitly compiling the regular expression before matching with it.\n\n[](){: #fun_creator_pid }","ref":"upcoming_incompatibilities.html#the-re-module-will-use-a-different-regular-expression-engine"},{"type":"extras","title":"Fun creator pid will be removed - Upcoming Potential Incompatibilities","doc":"As of OTP 28, the function `erlang:fun_info/1` will not include the `{pid,_}`\nelement and the function `erlang:fun_info/2` will no longer accept `pid` as the\nsecond argument.\n\n[](){: #escript_interpret_mode_removed }","ref":"upcoming_incompatibilities.html#fun-creator-pid-will-be-removed"},{"type":"extras","title":"Support for interpreting escripts will be removed - Upcoming Potential Incompatibilities","doc":"Escripts will be compiled, and it will no longer be possible to force an escript\nto be interpreted by using the directive `-mode(interpret)`.","ref":"upcoming_incompatibilities.html#support-for-interpreting-escripts-will-be-removed"},{"type":"extras","title":"OTP 29 - Upcoming Potential Incompatibilities","doc":"","ref":"upcoming_incompatibilities.html#otp-29"},{"type":"extras","title":"It will no longer be possible to disable feature maybe_expr - Upcoming Potential Incompatibilities","doc":"As of OTP 29, the `maybe_expr` feature will become permanent and no longer\npossible to disable. All uses of `maybe` as an atom will need to be quoted.\n\nIt is recommend to quote all uses of the atom `maybe` as soon as possible. The\ncompiler option `warn_keywords` can be used to emit warnings about all\noccurrences of `maybe` without quotes.","ref":"upcoming_incompatibilities.html#it-will-no-longer-be-possible-to-disable-feature-maybe_expr"},{"type":"extras","title":"cprof and eprof will be replaced by tprof - Upcoming Potential Incompatibilities","doc":"As of OTP 29, the `cprof` and `eprof` will be removed in favor of `m:tprof`\nadded in OTP 27.","ref":"upcoming_incompatibilities.html#cprof-and-eprof-will-be-replaced-by-tprof"},{"type":"extras","title":"Installation Guide","doc":"# Installation Guide","ref":"installation_guide.html"},{"type":"extras","title":"Getting Started With Erlang","doc":"# Getting Started With Erlang","ref":"getting_started.html"},{"type":"extras","title":"System Principles","doc":"# System Principles","ref":"system_principles.html"},{"type":"extras","title":"OTP Design Principles","doc":"# OTP Design Principles","ref":"design_principles.html"},{"type":"extras","title":"Programming Examples","doc":"# Programming Examples","ref":"programming_examples.html"},{"type":"extras","title":"Erlang Reference Manual","doc":"# Erlang Reference Manual","ref":"reference_manual.html"},{"type":"extras","title":"Efficiency Guide","doc":"# Efficiency Guide","ref":"efficiency_guide.html"},{"type":"extras","title":"Interoperability Tutorial","doc":"# Interoperability Tutorial","ref":"tutorial.html"},{"type":"extras","title":"Embedded Systems User's Guide","doc":"# Embedded Systems User's Guide","ref":"embedded.html"},{"type":"extras","title":"compiler","doc":"# compiler\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"compiler.html"},{"type":"extras","title":"erts","doc":"# erts","ref":"erts.html"},{"type":"extras","title":"kernel","doc":"# kernel\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"kernel.html"},{"type":"extras","title":"sasl","doc":"# sasl\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"sasl.html"},{"type":"extras","title":"stdlib","doc":"# stdlib\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"stdlib.html"},{"type":"extras","title":"mnesia","doc":"# mnesia\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"mnesia.html"},{"type":"extras","title":"odbc","doc":"# odbc\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"odbc.html"},{"type":"extras","title":"os_mon","doc":"# os_mon\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"os_mon.html"},{"type":"extras","title":"snmp","doc":"# snmp\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"snmp.html"},{"type":"extras","title":"asn1","doc":"# asn1\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"asn1.html"},{"type":"extras","title":"crypto","doc":"# crypto\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"crypto.html"},{"type":"extras","title":"diameter","doc":"# diameter\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"diameter.html"},{"type":"extras","title":"eldap","doc":"# eldap\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"eldap.html"},{"type":"extras","title":"erl_interface","doc":"# erl_interface\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"erl_interface.html"},{"type":"extras","title":"ftp","doc":"# ftp\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"ftp.html"},{"type":"extras","title":"inets","doc":"# inets\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"inets.html"},{"type":"extras","title":"jinterface","doc":"# jinterface\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"jinterface.html"},{"type":"extras","title":"megaco","doc":"# megaco\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"megaco.html"},{"type":"extras","title":"public_key","doc":"# public_key\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"public_key.html"},{"type":"extras","title":"ssh","doc":"# ssh\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"ssh.html"},{"type":"extras","title":"ssl","doc":"# ssl\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"ssl.html"},{"type":"extras","title":"tftp","doc":"# tftp\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"tftp.html"},{"type":"extras","title":"wx","doc":"# wx\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"wx.html"},{"type":"extras","title":"xmerl","doc":"# xmerl\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"xmerl.html"},{"type":"extras","title":"debugger","doc":"# debugger\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"debugger.html"},{"type":"extras","title":"dialyzer","doc":"# dialyzer\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"dialyzer.html"},{"type":"extras","title":"et","doc":"# et\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"et.html"},{"type":"extras","title":"observer","doc":"# observer\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"observer.html"},{"type":"extras","title":"parsetools","doc":"# parsetools\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"parsetools.html"},{"type":"extras","title":"reltool","doc":"# reltool\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"reltool.html"},{"type":"extras","title":"runtime_tools","doc":"# runtime_tools\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"runtime_tools.html"},{"type":"extras","title":"syntax_tools","doc":"# syntax_tools\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"syntax_tools.html"},{"type":"extras","title":"tools","doc":"# tools\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"tools.html"},{"type":"extras","title":"common_test","doc":"# common_test\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"common_test.html"},{"type":"extras","title":"eunit","doc":"# eunit\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"eunit.html"},{"type":"extras","title":"edoc","doc":"# edoc\n\nThe documentation for this application was not generated because the application was skipped during the source build.","ref":"edoc.html"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}