#ifndef ARGINC
#define ARGINC
#ifdef __cplusplus
extern "C" {
#endif

#include "arg_err.h"
#include "status.h"

#define ARG_SDS -1
#define ARG_STRING -2
#define ARG_STRING2 -3

/*
 *   Is const acceptable on this machine.
 */
#if defined(__cplusplus) || defined(__STDC__) || defined (VAXC)
#     define ARGCONST const
#else
#     define ARGCONST  /* */
#endif


/*
 * Under Windows, we may need to export or import the functions, depending
 * on if we are building the DLL or linking against it.
 */
#ifdef WIN32
#ifdef DRAMA_DLL  /* Am building DRAMA DLL */
#define ARGEXTERN __declspec(dllexport)
#elif defined(DRAMA_STATIC) /* Building a static library */
#define ARGEXTERN extern
#else           /* Am building application with DLL */
#define ARGEXTERN __declspec(dllimport)
#endif

#else
#define ARGEXTERN extern
#endif


ARGEXTERN void ArgNew(SdsIdType *id, StatusType * ARGCONST status);
ARGEXTERN void ArgPutc(SdsIdType id, ARGCONST char *name, char value, 
			   StatusType * ARGCONST status);
ARGEXTERN void ArgPuts(SdsIdType id, ARGCONST char *name, short value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgPutus(SdsIdType id, ARGCONST char *name, unsigned short value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgPuti(SdsIdType id, ARGCONST char *name, long value, 
			   StatusType * ARGCONST status);
ARGEXTERN void ArgPuti64(SdsIdType id, ARGCONST char *name, INT64 value, 
			   StatusType * ARGCONST status);

ARGEXTERN void ArgPutu(SdsIdType id, ARGCONST char *name, unsigned long value, 
			   StatusType * ARGCONST status);

ARGEXTERN void ArgPutu64(SdsIdType id, ARGCONST char *name, UINT64 value,
			   StatusType * ARGCONST status);

ARGEXTERN void ArgPutf(SdsIdType id, ARGCONST char *name, float value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgPutd(SdsIdType id, ARGCONST char *name, double value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgPutString(SdsIdType id, ARGCONST char *name, ARGCONST char *value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGetc(SdsIdType id, ARGCONST char *name, char *value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGets(SdsIdType id, ARGCONST char *name, short *value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGetus(SdsIdType id, ARGCONST char *name, unsigned short *value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGeti(SdsIdType id, ARGCONST char *name, long *value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGeti64(SdsIdType id, ARGCONST char *name, INT64 *value,
			   StatusType * ARGCONST status);

ARGEXTERN void ArgGetu(SdsIdType id, ARGCONST char *name, unsigned long *value,
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGetu64(SdsIdType id, ARGCONST char *name, UINT64 *value,
			    StatusType * ARGCONST status);

ARGEXTERN void ArgGetf(SdsIdType id, ARGCONST char *name, float *value, 
			   StatusType * ARGCONST status);
ARGEXTERN void ArgGetd(SdsIdType id, ARGCONST char *name, double *value, 
			  StatusType * ARGCONST status);
ARGEXTERN void ArgGetString(SdsIdType id, ARGCONST char *name, long len, char *value, 
			  StatusType * ARGCONST status);
ARGEXTERN void ArgDelete(SdsIdType id, StatusType * ARGCONST status);


ARGEXTERN void ArgCvt (ARGCONST void * SrcAddr, SdsCodeType SrcType,  SdsCodeType DstType,
	     void * DstAddr, unsigned long int DstLen , 
			  StatusType  * ARGCONST status);
ARGEXTERN void ArgLook (char *SrcAddr, int USFlag, int MinFlag, SdsCodeType *DstType, 
			  StatusType * ARGCONST status);


ARGEXTERN void ArgToString (SdsIdType id,int maxlen,int *length,char *string,
			  StatusType * ARGCONST status);

typedef void (*ArgListFuncType)(
			void *client_data,
			ARGCONST char *line,			
                        StatusType * status);
ARGEXTERN void ArgSdsList(SdsIdType id, unsigned buflen, char *buffer, 
		 ArgListFuncType func, void * client_data,
		 StatusType * ARGCONST status);


ARGEXTERN void ArgFind(SdsIdType parent_id, ARGCONST char *name, 
                       SdsIdType *id, 
                       StatusType * ARGCONST status);


#ifdef __cplusplus
} /* extern "C" */


/*
 * C++ only section.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Here is the a C++ interface to ARG.  No object modifications required since
 *  all code is inline.
 */
class Arg : public SdsId {
    private:
        /* Assignment and Copy operators, made private to avoid misuse */
        Arg& operator=(const Arg&); /* Assignment */
        Arg(const Arg&); /* Copy */
     public:
	Arg (const SdsIdType item=0, const bool free=false, 
    	     const bool del = false, const readfree = false) : 
    	     		SdsId(item,free,del,readfree) {
	};
	/* Create a new arg item.  Note, the first argument is just used
	    to make this constructors argument list different from the
	    above one when trialing arguments are defaulted.
	 */
	Arg (const bool , StatusType * const status, 
			const char * const name = "ArgStructure") : 
	    SdsId(name, SDS_STRUCT,status) {
	}
	
	/* Create a new arg structure. We use the ShallowCopy to copy the id */
	/* to this id */
	void New (StatusType * const status) {
	    Arg tid(true,status);
	    ShallowCopy(tid,true);
	};

        /* Constructor which returns an id to a named item of another item */
        /* This is confusing since what we really want is to do is SdsFind */
        /* but we want the ErsRep reporting facilities of ArgFind, so we   */
        /* must create this item as a null item, call ArgFind using the    */
        /* arguments and then use ShallowCopy to copy the SdsIdType to this */
        /* item */
        Arg(const SdsId& source, const char * const name,
                StatusType * const status) :
                SdsId(0,false,false,false) {
            SdsIdType tid;
            ArgFind(source,name,&tid,status);
            ShallowCopy(tid,true,false,false);
        }

	void ToString(int maxlen, int *length, char *string, 
				StatusType * const status)
	{
	    ArgToString(*this,maxlen,length,string,status);
	}

#       ifndef CPP_NOBOOL
        void Put (const char *name, bool value, StatusType * const status) {
            unsigned short v = (int)value;
	    ArgPutus(*this,name,v,status);
	};
#	endif
        void Put (const char *name, char value, StatusType * const status) {
	    ArgPutc(*this,name,value,status);
	};
        void Put (const char *name, short value, StatusType * const status) {
	    ArgPuts(*this,name,value,status);
	};
        void Put (const char *name, unsigned short value, 
					   StatusType * const status) {
	    ArgPutus(*this,name,value,status);
	};
        void Put (const char *name, long value, StatusType * const status) {
	    ArgPuti(*this,name,value,status);
	};
        void Put (const char *name, unsigned long value, StatusType * const status) {
	    ArgPutu(*this,name,value,status);
	};
#       ifdef LONG__64
	/* Machine has 64 bit longs, we need an interface for 32 bit longs */
	/* its just a simple cast */
        void Put (const char *name, INT32 value, StatusType * const status) {
	    ArgPuti(*this,name,value,status);
	};
        void Put (const char *name, UINT32 value, StatusType * const status) {
	    ArgPutu(*this,name,value,status);
	};
#	else
	/* Machine has 32 bit values, we need an interface for 64 bit longs */
        void Put (const char *name, INT64 value, StatusType * const status) {
	    ArgPuti64(*this,name,value,status);
	};
        void Put (const char *name, UINT64 value, StatusType * const status) {
	    ArgPutu64(*this,name,value,status);
	};
#	endif
        void Put (const char *name, float value, StatusType * const status) {
	    ArgPutf(*this,name,value,status);
	};
        void Put (const char *name, double value, StatusType * const status) {
	    ArgPutd(*this,name,value,status);
	};
        void Put (const char *name, const char *value, StatusType * const status) {
	    ArgPutString(*this,name,value,status);
	};


#       ifndef CPP_NOBOOL
	void Get (const char *name, bool * value, 
					      StatusType * const status) {
	    unsigned short v;
	    ArgGetus(*this,name,&v,status);
	    *value =  v ? true : false;
	}
#	endif

	void Get (const char *name, char * value, StatusType * const status) {
	    ArgGetc(*this,name,value,status);
	}
	void Get (const char *name, short * value, StatusType * const status) {
	    ArgGets(*this,name,value,status);
	}
	void Get (const char *name, unsigned short * value, 
					      StatusType * const status) {
	    ArgGetus(*this,name,value,status);
	}
	void Get (const char *name, long int * value, StatusType * const status){
	    ArgGeti(*this,name,value,status);
	}
	void Get (const char *name, unsigned long * value, 
						StatusType * const status) {
	    ArgGetu(*this,name,value,status);
	}
#       ifdef LONG__64
	/* On machines with 64 bit longs, we need an interface to get 32 bit
 		values.  Note, we don't check for overflows */
	void Get (const char *name, INT32 * value, StatusType * const status){
	    long int val;
	    ArgGeti(*this,name,&val,status);
	    *value = val;
	}
	void Get (const char *name, UINT32 * value, StatusType * const status){
	    unsigned long int val;
	    ArgGetu(*this,name,&val,status);
	    *value = val;
	}
#	else
	/* Machine has 32bit longs, we need an interface for 64 bit values */
	void Get (const char *name, INT64 * value, StatusType * const status){
	    ArgGeti64(*this,name,value,status);
	}
	void Get (const char *name, UINT64 * value, StatusType * const status){
	    ArgGetu64(*this,name,value,status);
	}
#	endif

	void Get (const char *name, float * value, StatusType * const status) {
	    ArgGetf(*this,name,value,status);
	}
	void Get (const char *name, double * value, StatusType * const status) {
	    ArgGetd(*this,name,value,status);
	}
	void Get (const char *name, long len, char * value,  
                                               StatusType * const status) {
	    ArgGetString(*this,name,len,value,status);
	}	
	static void List(const SdsId & id, unsigned buflen, char *buffer, 
		 ArgListFuncType func, void * client_data,
		 StatusType * ARGCONST status) {
	    ArgSdsList(id,buflen,buffer,func,client_data,status);
	}

/*
 *  
 *   	Arg hids some Sds functions, so we redeclare them here.
 */
        void List(StatusType * const status) const {
            SdsList(*this,status);
        }
        void Get(const unsigned long length,
        	 void * const data,
        	 StatusType * const status,
        	 unsigned long *actlen = 0,
        	 const unsigned long offset=0) const {
            SdsId::Get(length,data,status,actlen,offset);
	}
        	                                     
        void Put(const unsigned long length,
        	 void * const data,
        	 StatusType * const status,
        	 const unsigned long offset=0)
        {
            SdsId::Put(length,data,status,offset);
        }
         	                                     
        	     
       

}; /* class */


#endif
#endif
