
/*  SDS Test program  */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "status.h"
#include "sds.h"

typedef struct block
  {
    char c1;
    double d1;
    char c2;
    float f1;
    char c3;
    INT32 l1;
    short s1;
    UINT32 ul1;
    char c4;
    unsigned short us1;
  } block;

 


void SdsTestPut(SdsIdType topid, StatusType *status)

{
  SdsIdType charid1,charid2;
  SdsIdType byteid1,byteid2;
  SdsIdType ubyteid1,ubyteid2;
  SdsIdType shortid1,shortid2;
  SdsIdType ushortid1,ushortid2;
  SdsIdType intid1,intid2;
  SdsIdType uintid1,uintid2;
  SdsIdType i64id1,i64id2;
  SdsIdType ui64id1,ui64id2;
  SdsIdType floatid1,floatid2;
  SdsIdType doubleid1,doubleid2;
  SdsIdType sid;
  int i,j;
  char cdata[260];
  char bdata[128];
  unsigned char ubdata[512];
  short sdata[256];
  unsigned short usdata[660];
  INT32 idata[256];
  UINT32 uidata[40];
  INT64 i64data[100];
  UINT64 ui64data[100];
  float fdata[256];
  double ddata[20];
  /*char cdatas;*/
  static block block1 = {'A', 1.234567890, 'B', 3.1415926, 'q', 99999999, -32767, 
      4000000000, 'z', 65535 };


/*  Put Data test  */

  SdsFind(topid,"Char",&charid1,status);
  SdsFind(topid,"Chars",&charid2,status);
  SdsFind(topid,"Byte",&byteid1,status);
  SdsFind(topid,"Bytes",&byteid2,status);
  SdsFind(topid,"Ubyte",&ubyteid1,status);
  SdsFind(topid,"Ubytes",&ubyteid2,status);
  SdsFind(topid,"Short",&shortid1,status);
  SdsFind(topid,"Shorts",&shortid2,status);
  SdsFind(topid,"Ushort",&ushortid1,status);
  SdsFind(topid,"Ushorts",&ushortid2,status);
  SdsFind(topid,"Int",&intid1,status);
  SdsFind(topid,"Ints",&intid2,status);
  SdsFind(topid,"Uint",&uintid1,status);
  SdsFind(topid,"Uints",&uintid2,status);
  SdsFind(topid,"I64",&i64id1,status);
  SdsFind(topid,"I64s",&i64id2,status);
  SdsFind(topid,"UI64",&ui64id1,status);
  SdsFind(topid,"UI64s",&ui64id2,status);
  SdsFind(topid,"Float",&floatid1,status);
  SdsFind(topid,"Floats",&floatid2,status);
  SdsFind(topid,"Double",&doubleid1,status);
  SdsFind(topid,"Doubles",&doubleid2,status);
  SdsFind(topid,"Structure",&sid,status);
  if (*status != SDS__OK)
    {
      printf("Structure navigation error in TestPut %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  SdsPutExtra(sid,10,"Changed!!!",status);
  if (*status != SDS__OK) 
    {
      printf("Error putting extra information field %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  SdsPut(charid1,1,0,"Q",status);
  if (*status != SDS__OK) 
    {
      printf("Error putting char scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<260;i+=26)
    for (j=0;j<26;j++)
      cdata[i+j] = 'a'+j;
  SdsPut(charid2,256,0,cdata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting char array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  bdata[0]= -127;
  SdsPut(byteid1,1,0,bdata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting byte scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<128;i++)
    bdata[i]=i;
  SdsPut(byteid2,128,0,bdata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting byte array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  ubdata[0]= 255;
  SdsPut(ubyteid1,1,0,ubdata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting ubyte scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<512;i++)
    ubdata[i]=i % 256;
  SdsPut(ubyteid2,512,0,ubdata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting ubyte array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  sdata[0]= -32767;
  SdsPut(shortid1,2,0,sdata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting short scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<256;i++)
    sdata[i]=i*111;
  SdsPut(shortid2,256*2,0,sdata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting short array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  usdata[0]= 65535;
  SdsPut(ushortid1,2,0,usdata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting ushort scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<660;i++)
    usdata[i]=i*11;
  SdsPut(ushortid2,660*2,0,usdata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting ushort array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  idata[0]= -2147483647;
  SdsPut(intid1,4,0,idata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting int scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<256;i++)
    idata[i]= -i*111111;
  SdsPut(intid2,256*4,0,idata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting int array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  uidata[0]= 4294967295;
  SdsPut(uintid1,4,0,uidata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting uint scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<40;i++)
    uidata[i]= i*111111;
  SdsPut(uintid2,40*4,0,uidata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting uint array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  i64data[0] = SdsSetI64(-100,0);
  SdsPut(i64id1,8,0,i64data,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting ui64 scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }    ui64data[0]= SdsSetUI64(100,0);
  SdsPut(ui64id1,8,0,ui64data,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting ui64 scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }  
  fdata[0]= 3.1415926;
  SdsPut(floatid1,4,0,fdata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting float scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<256;i++)
    fdata[i]= i*1.23456789;
  SdsPut(floatid2,256*4,0,fdata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting float array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  ddata[0]= 3.141592653589793238462643;
  SdsPut(doubleid1,8,0,ddata,status);
  if (*status != SDS__OK) 
    {
      printf("Error putting double scalar %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<20;i++)
    ddata[i]= i;
  SdsPut(doubleid2,20*8,0,ddata,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting double array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  SdsPut(sid,sizeof(block),0,&block1,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting structure %d\n",*status);
      printf("Test aborting\n");
      return;
    }
}   



void SdsTestGet(SdsIdType topid, StatusType *status)

{
  SdsIdType charid1,charid2;
  SdsIdType byteid1,byteid2;
  SdsIdType ubyteid1,ubyteid2;
  SdsIdType shortid1,shortid2;
  SdsIdType ushortid1,ushortid2;
  SdsIdType intid1,intid2;
  SdsIdType uintid1,uintid2;
  SdsIdType floatid1,floatid2;
  SdsIdType doubleid1,doubleid2;
  SdsIdType sid;
  int i,j;
  char cdata[260];
  char bdata[128];
  unsigned char ubdata[512];
  short sdata[256];
  unsigned short usdata[660];
  INT32 idata[256];
  UINT32 uidata[40];
  float fdata[256];
  double ddata[20];
  char cdatas;
  unsigned long actlen;
  block block1;
  INT32 *ptr;
  void *vptr;
  char cext[11];

/*  Get Data test  */

  if (*status != SDS__OK) return;
  SdsFind(topid,"junk",&charid1,status);
  if (*status != SDS__NOITEM)
    printf("SdsFind - failed to get NOITEM error %d\n",*status);
  *status = SDS__OK;
  SdsFind(topid,"Char",&charid1,status);
  SdsFind(charid1,"junk",&charid2,status);
  if (*status != SDS__NOTSTRUCT)
    printf("SdsFind - failed to get NOTSTRUCT error %d\n",*status);
  *status = SDS__OK;
  SdsFind(topid,"Chars",&charid2,status);
  SdsFind(topid,"Byte",&byteid1,status);
  SdsFind(topid,"Bytes",&byteid2,status);
  SdsFind(topid,"Ubyte",&ubyteid1,status);
  SdsFind(topid,"Ubytes",&ubyteid2,status);
  SdsFind(topid,"Short",&shortid1,status);
  SdsFind(topid,"Shorts",&shortid2,status);
  SdsFind(topid,"Ushort",&ushortid1,status);
  SdsFind(topid,"Ushorts",&ushortid2,status);
  SdsFind(topid,"Int",&intid1,status);
  SdsFind(topid,"Ints",&intid2,status);
  SdsFind(topid,"Uint",&uintid1,status);
  SdsFind(topid,"Uints",&uintid2,status);
  SdsFind(topid,"Float",&floatid1,status);
  SdsFind(topid,"Floats",&floatid2,status);
  SdsFind(topid,"Double",&doubleid1,status);
  SdsFind(topid,"Doubles",&doubleid2,status);
  SdsFind(topid,"Structure",&sid,status);
  if (*status != SDS__OK)
    {
      printf("Structure navigation error in TestGet %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  SdsGetExtra(sid,10,cext,&actlen,status);
  cext[10] = 0;
  if ((*status != SDS__OK) || (strcmp(cext,"Changed!!!") != 0)) 
    {
      printf("Error getting extra information field %d\n",*status);
      printf(cext); printf("\n");
      *status = 2;
      printf("Test aborting\n");
      return;
    }

  SdsGet(charid1,1,0,&cdatas,&actlen,status);
  if ((*status != SDS__OK) || (cdatas != 'Q')) 
    {
      printf("Error getting char scalar %d %c\n",*status,cdatas);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<256;i++) cdata[i]=' ';
  SdsGet(charid2,256,0,cdata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting char array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<260;i+=26)
    for (j=0;j<26;j++)
      {
        if ((cdata[i+j] != ('a'+j)) && ((i+j) < 256))
          {
            printf("Error getting char array %c %d\n",cdata[i+j],i+j);
            printf("Test aborting\n");
            *status = 2;
            return;
          }
      }
  bdata[0]= 0;
  SdsGet(byteid1,1,0,bdata,&actlen,status);
  if ((*status != SDS__OK) || (bdata[0] != -127)) 
    {
      printf("Error getting byte scalar %d %d\n",bdata[0],*status);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<128;i++)
    bdata[i]=0;
  SdsGet(byteid2,128,0,bdata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting byte array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<128;i++)
    if (bdata[i] != i)
      {
        printf("Error getting byte array %d %d\n",i,bdata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  ubdata[0]= 0;
  SdsGet(ubyteid1,1,0,ubdata,&actlen,status);
  if ((*status != SDS__OK) || (ubdata[0] != 255)) 
    {
      printf("Error getting ubyte scalar %d %u\n",status,ubdata[0]);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<512;i++)
    ubdata[i]=0;
  SdsGet(ubyteid2,512,0,ubdata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting ubyte array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<512;i++)
    if (ubdata[i] != (i % 256))
      {
        printf("Error getting ubyte array %d %d\n",i,ubdata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  sdata[0]= 0;
  SdsGet(shortid1,2,0,sdata,&actlen,status);
  if ((*status != SDS__OK) || (sdata[0] != -32767)) 
    {
      printf("Error putting short scalar %d %d\n",sdata[0],*status);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<256;i++)
    sdata[i]=0;
  SdsGet(shortid2,256*2,0,sdata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting short array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<256;i++)
    if (sdata[i] != i*111)
      {
        printf("Error putting short array %d %d\n",i,sdata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  usdata[0]= 65535;
  SdsGet(ushortid1,2,0,usdata,&actlen,status);
  if ((*status != SDS__OK) || (usdata[0] != 65535)) 
    {
      printf("Error getting ushort scalar %d %u\n",status,usdata[0]);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<660;i++)
    usdata[i]=0;
  SdsGet(ushortid2,660*2,0,usdata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting ushort array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<660;i++)
    if (usdata[i] != i*11)
      {
        printf("Error getting ushort array %d %u\n",i,usdata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  idata[0]= 0;
  SdsGet(intid1,4,0,idata,&actlen,status);
  if ((*status != SDS__OK) || (idata[0] != -2147483647)) 
    {
      printf("Error getting int scalar %d %d\n",idata[0],*status);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  SdsPointer(intid1,&vptr,&actlen,status);
  ptr = (INT32*)vptr;
  if ((*ptr != -2147483647) || (*status != SDS__OK))
    {
      printf("Error getting int scalar via pointer %d %d\n",*ptr,*status);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  SdsFlush(intid1,status);
  for (i=0;i<256;i++)
    idata[i]= 0;
  SdsGet(intid2,256*4,0,idata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting int array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<256;i++)
    if (idata[i] != -i*111111)
      {
        printf("Error getting int array %d %d\n",i,idata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  uidata[0]= 0;
  SdsGet(uintid1,4,0,uidata,&actlen,status);
  if ((*status != SDS__OK) || uidata[0] != 4294967295) 
    {
      printf("Error getting uint scalar %d %d\n",uidata[0],*status);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<40;i++)
    uidata[i]= i*111111;
  SdsGet(uintid2,40*4,0,uidata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting uint array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<40;i++)
    if (uidata[i] != i*111111)
      {
        printf("Error putting uint array %d %u\n",i,uidata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  fdata[0]= 3.1415926;
  SdsGet(floatid1,4,0,fdata,&actlen,status);
  if ((*status != SDS__OK) || (fdata[0]>3.141593) || (fdata[0]<3.141592)) 
    {
      printf("Error getting float scalar %d %g\n",*status,fdata[0]);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<256;i++)
    fdata[i]= 0.0;
  SdsGet(floatid2,256*4,0,fdata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting float array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<256;i++)
    if ((fdata[i] > i*1.2345685) || (fdata[i] < i*1.234567))
      {
        printf("Error getting float array %d %g\n",i,fdata[i]);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  ddata[0]= 0.0;
  SdsGet(doubleid1,8,0,ddata,&actlen,status);
  if ((*status != SDS__OK) || (ddata[0] > 3.141592653590) ||
    (ddata[0] < 3.141592653589)) 
    {
      printf("Error getting double scalar %d %g\n",*status,ddata[i]);
      printf("Test aborting\n");
      *status = 2;
      return;
    }
  for (i=0;i<20;i++)
    ddata[i]= i;
  SdsGet(doubleid2,20*8,0,ddata,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error putting double array %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  for (i=0;i<20;i++)
    if ((ddata[i] > (i + 1e-10)) || (ddata[i] < (i - 1e-10)))
      {
        printf("Error putting double array %d\n",*status);
        printf("Test aborting\n");
        *status = 2;
        return;
      }
  SdsGet(sid,sizeof(block),0,&block1,&actlen,status);      
  if (*status != SDS__OK) 
    {
      printf("Error getting structure %d\n",*status);
      printf("Test aborting\n");
      return;
    }
  if ((block1.c1 != 'A') || (block1.d1 > 1.234567891) || (block1.d1 <
     1.234567889) || (block1.c2 != 'B') || (block1.f1 < 3.141592) ||
     (block1.f1 > 3.141593) || (block1.c3 != 'q') || (block1.l1 != 99999999)
     || (block1.s1 != -32767) || (block1.ul1 != 4000000000) ||
     (block1.c4 != 'z') || (block1.us1 != 65535))     
    {
      printf("Error getting structure %d\n",*status);
      printf("Test aborting\n");
      *status = 2;
      return;
    }

}






int main()


{
  SdsIdType topid,id1,id2,id3,id4,id5,pid,idc,ide;
  SdsIdType charid1,charid2;
  SdsIdType byteid1,byteid2;
  SdsIdType ubyteid1,ubyteid2;
  SdsIdType shortid1,shortid2;
  SdsIdType ushortid1,ushortid2;
  SdsIdType intid1,intid2;
  SdsIdType uintid1,uintid2;
  SdsIdType floatid1,floatid2;
  SdsIdType doubleid1,doubleid2;
  SdsIdType i64id1,i64id2;
  SdsIdType ui64id1,ui64id2;
  SdsIdType sid,tid;
  StatusType status;
  unsigned long dims[8];
/*
  int i,j;
  unsigned long actlen;
 */
  unsigned long size;
  void *buffer,*buffer2;
  void *junk;
  unsigned long osize;

  status = SDS__OK;
  SdsNew(-1,"Top",0,NULL,SDS_STRUCT,0,NULL,&topid,&status);
  if (status != SDS__BADID)
    printf("SdsNew - Failed to get BADID error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"12345678901234567890",0,NULL,SDS_STRUCT,0,NULL,&topid,&status);
  if (status != SDS__LONGNAME)
    printf("SdsNew - Failed to get LONGNAME error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"Top",129,NULL,SDS_STRUCT,0,NULL,&topid,&status);
  if (status != SDS__EXTRA)
    printf("SdsNew - Failed to get EXTRA error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"Top",0,NULL,999,0,NULL,&topid,&status);
  if (status != SDS__INVCODE)
    printf("SdsNew - Failed to get INVCODE error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"Top",0,NULL,SDS_STRUCT,8,NULL,&topid,&status);
  if (status != SDS__INVDIMS)
    printf("SdsNew - Failed to get INVDIMS error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"Top",0,NULL,SDS_STRUCT,-1,NULL,&topid,&status);
  if (status != SDS__INVDIMS)
    printf("SdsNew - Failed to get INVDIMS error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"Top",0,NULL,SDS_INT,0,NULL,&pid,&status);
  if (status != SDS__OK)
    printf("SdsNew - Failure on primitive creation %d\n",status);
  status = SDS__OK;
  SdsNew(pid,"Top",0,NULL,SDS_INT,0,NULL,&id1,&status);
  if (status != SDS__NOTSTRUCT)
    printf("SdsNew - Failure to get NOTSTRUCT error %d\n",status);
  status = SDS__OK;
  SdsNew(0,"Top",0,NULL,SDS_STRUCT,0,NULL,&topid,&status);
  if (status != SDS__OK)
    {
      printf("SdsNew - Failure on structure creation %d\n",status);
      printf("Test aborting\n",status);
      return(-1);
    }
  else
    printf("Structure creation test completed \n");
 
/*  Primitive creation as elements of a structure  */

  SdsNew(topid,"Char",0,NULL,SDS_CHAR,0,NULL,&charid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating character scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 256;
  SdsNew(topid,"Chars",0,NULL,SDS_CHAR,1,dims,&charid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating character array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Byte",0,NULL,SDS_BYTE,0,NULL,&byteid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating byte scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 2;
  dims[1] = 2;
  dims[2] = 2;
  dims[3] = 2;
  dims[4] = 2;
  dims[5] = 2;
  dims[6] = 2;
  SdsNew(topid,"Bytes",0,NULL,SDS_BYTE,7,dims,&byteid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating byte array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Ubyte",0,NULL,SDS_UBYTE,0,NULL,&ubyteid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating ubyte scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 256;
  dims[1] = 2;
  SdsNew(topid,"Ubytes",0,NULL,SDS_UBYTE,2,dims,&ubyteid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating ubyte array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Short",0,NULL,SDS_SHORT,0,NULL,&shortid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating short scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 256;
  SdsNew(topid,"Shorts",0,NULL,SDS_SHORT,1,dims,&shortid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating short array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Ushort",0,NULL,SDS_USHORT,0,NULL,&ushortid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating ushort scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 20;
  dims[1] = 11;
  dims[2] = 3;
  SdsNew(topid,"Ushorts",0,NULL,SDS_USHORT,3,dims,&ushortid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating ushort array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Int",0,NULL,SDS_INT,0,NULL,&intid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating int scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 256;
  SdsNew(topid,"Ints",0,NULL,SDS_INT,1,dims,&intid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating int array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Uint",0,NULL,SDS_UINT,0,NULL,&uintid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating uint scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 4;
  dims[1] = 1;
  dims[2] = 5;
  dims[3] = 2;
  SdsNew(topid,"Uints",0,NULL,SDS_UINT,4,dims,&uintid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating uint array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"I64",0,NULL,SDS_I64,0,NULL,&i64id1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating int64 scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 128;
  SdsNew(topid,"I64s",0,NULL,SDS_I64,1,dims,&i64id2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating int64 array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"UI64",0,NULL,SDS_UI64,0,NULL,&ui64id1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating uint64 scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 4;
  dims[1] = 2;
  SdsNew(topid,"UI64s",0,NULL,SDS_UI64,2,dims,&ui64id2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating ui64 array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Float",0,NULL,SDS_FLOAT,0,NULL,&floatid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating float scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 256;
  SdsNew(topid,"Floats",0,NULL,SDS_FLOAT,1,dims,&floatid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating float array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsNew(topid,"Double",0,NULL,SDS_DOUBLE,0,NULL,&doubleid1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating double scalar %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0] = 20;
  SdsNew(topid,"Doubles",0,NULL,SDS_DOUBLE,1,dims,&doubleid2,&status);
  if (status != SDS__OK)
    {
      printf("Error creating double array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }

  SdsNew(topid,"Structure",10,"Extra Text",SDS_STRUCT,0,NULL,&sid,&status);
  SdsNew(sid,"c1",0,NULL,SDS_CHAR,0,NULL,&tid,&status);
  SdsNew(sid,"d1",0,NULL,SDS_DOUBLE,0,NULL,&tid,&status);
  SdsNew(sid,"c2",0,NULL,SDS_CHAR,0,NULL,&tid,&status);
  SdsNew(sid,"f1",0,NULL,SDS_FLOAT,0,NULL,&tid,&status);
  SdsNew(sid,"c3",0,NULL,SDS_CHAR,0,NULL,&tid,&status);
  SdsNew(sid,"l1",0,NULL,SDS_INT,0,NULL,&tid,&status);
  SdsNew(sid,"s1",0,NULL,SDS_SHORT,0,NULL,&tid,&status);
  SdsNew(sid,"ul1",0,NULL,SDS_UINT,0,NULL,&tid,&status);
  SdsNew(sid,"c4",0,NULL,SDS_CHAR,0,NULL,&tid,&status);
  SdsNew(sid,"us1",0,NULL,SDS_USHORT,0,NULL,&tid,&status);
  if (status != SDS__OK)
    {
      printf("Error creating structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }

 
  printf("Primitive creation test completed\n");

/*  Structure array creation test  */

  dims[0]=2;
  dims[1]=3;
  SdsNew(topid,"Strarray",0,NULL,SDS_STRUCT,2,dims,&id1,&status);
  if (status != SDS__OK)
    {
      printf("Error creating structure array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsCell(topid,2,dims,&id2,&status);
  if (status != SDS__NOTARRAY)
    printf("SdsCell - Failed to get NOTARRAY error %d\n",status);
  status = SDS__OK;
  SdsCell(id1,3,dims,&id2,&status);
  if (status != SDS__INDEXERR)
    printf("SdsCell - Failed to get INDEXERR error %d\n",status);
  status = SDS__OK;
  SdsCell(id1,2,dims,&id2,&status);
  if (status != SDS__OK)
    {
      printf("Error in Sds Cell %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  status = SDS__OK;

  printf("Structure array creation test completed\n");

  SdsTestPut(topid,&status);
  if (status != SDS__OK) return(-1);
  
  SdsTestGet(topid,&status);
  if (status != SDS__OK) return(-1);

  printf("Put and Get test completed\n");

  SdsCopy(topid,&id3,&status);
  if (status != SDS__OK)
    {
      printf("Error Copying an SDS object %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }

  SdsInsert(id2,id3,&status);
  if (status != SDS__OK)
    {
      printf("Error Inserting into a structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }

  SdsExtract(id2,&status);
  if (status != SDS__ILLDEL)
    printf("SdsExtract - failed to get ILLDEL error %d\n",status);
  status = SDS__OK;

  SdsExtract(id3,&status);
  if (status != SDS__OK)
    {
      printf("Error Extracting from a structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }


  SdsInsert(id2,id3,&status);

  SdsTestGet(id3,&status);
  if (status != SDS__OK) return(-1);

  printf("Copy and Insert test completed\n");

  SdsSize(topid,&size,&status);
  osize = size;
  buffer = (void*)malloc(size);
  SdsExport(topid,size,buffer,&status);
  if (status != SDS__OK)
    {
      printf("Error Exporting a structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }

  junk = (void*)malloc(20);
  SdsAccess(junk,&id4,&status);
  if ((status != SDS__NOTSDS) && (status != SDS__VERSION))
    printf("SdsAccess - failed to get NOTSDS or VERSION status %d\n",status);
  status = SDS__OK;

  SdsAccess(buffer,&id4,&status);
  if (status != SDS__OK)
    {
      printf("Error Accessing a structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsTestGet(id4,&status);
  if (status != SDS__OK) return(-1);

  printf("Export and Access test completed\n");

  SdsSize(id4,&size,&status);
  if (status != SDS__OK)
    {
      printf("Error with external SdsSize %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  if (size != osize)
    {
      printf("Error in external SdsSize %d\n",size);
      printf("Test aborting\n");
      return(-1);
    }
  buffer2 = (void*)malloc(size);
  SdsExport(id4,size,buffer2,&status);
  if (status != SDS__OK)
    {
      printf("Error Exporting an external structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsAccess(buffer2,&ide,&status);
  if (status != SDS__OK)
    {
      printf("Error Accessing a structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsTestGet(ide,&status);
  if (status != SDS__OK) return(-1);

  SdsFind(id4,"Chars",&idc,&status);
  SdsSize(idc,&size,&status);
  SdsFind(topid,"Chars",&idc,&status);
  SdsSize(idc,&osize,&status);
  if (status != SDS__OK)
    {
      printf("Error with external SdsSize %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  if (size != osize)
    {
      printf("Error in external SdsSize %d\n",size);
      printf("Test aborting\n");
      return(-1);
    }


  SdsFind(id4,"Structure",&idc,&status);
  SdsSize(idc,&size,&status);
  SdsFind(topid,"Structure",&idc,&status);
  SdsSize(idc,&osize,&status);
  if (status != SDS__OK)
    {
      printf("Error with external SdsSize for structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  if (size != osize)
    {
      printf("Error in external SdsSize for structure %d %d\n",size,osize);
      printf("Test aborting\n");
      return(-1);
    }


  SdsFind(id4,"Strarray",&idc,&status);
  SdsSize(idc,&size,&status);
  SdsFind(topid,"Strarray",&idc,&status);
  SdsSize(idc,&osize,&status);
  if (status != SDS__OK)
    {
      printf("Error with external SdsSize for structure array %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  if (size != osize)
    {
      printf("Error in external SdsSize for structure array %d %d\n",size,osize);
      printf("Test aborting\n");
      return(-1);
    }

  SdsImport(buffer,&id5,&status);
  if (status != SDS__OK)
    {
      printf("Error Importing a structure %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsTestGet(id5,&status);
  if (status != SDS__OK) return(-1);
  printf("Import test completed\n");

  SdsDelete(id4,&status);
  if (status != SDS__EXTERN)
    printf("SdsDelete - failed to get EXTERN error %d\n",status);
  status = SDS__OK;

  SdsDelete(id2,&status);
  if (status != SDS__ILLDEL)
    printf("SdsDelete - failed to get ILLDEL error %d\n",status);
  status = SDS__OK;

  SdsDelete(id3,&status);
  if (status != SDS__OK)
    {
      printf("Error in SdsDelete %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  dims[0]=4;
  SdsResize(id3,1,dims,&status);
  if (status != SDS__BADID)
    printf("SdsResize - failed to get BADID error %d\n",status);
  status = SDS__OK;
  SdsResize(id1,1,dims,&status);
  if (status != SDS__OK)
    {
      printf("Error in SdsResize %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsRename(id1,"Renamed",&status);
  if (status != SDS__OK)
    {
      printf("Error in SdsRename %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }

  SdsWrite(topid,"test.sds",&status);
  if (status != SDS__OK)
    {
      printf("Error in SdsWrite %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  SdsList(topid,&status);
  if (status != SDS__OK)
    {
      printf("Error in SdsList %d\n",status);
      printf("Test aborting\n");
      return(-1);
    }
  return(0);
}
  

  
