#ifndef _SIXDFFPIL_INC
#define _SIXDFFPIL_INC
#ifdef __cplusplus
extern "C" {
#endif

/*
 *+			S I X D F F P I L

 * Include File name:
      sixdffpil

 * Function:
      Include file for sixdFcollision.c and ? modules.

 * Description:
      Contains extern definitions from sixdFfpilMin.c and sixdFfpilFull.c
      and internal prototypes of sixdFcollision.c routines used by 
      ?

 * Language:
      C


 * Support: Tony Farrell, AAO

 *-


 * Sccs Id:     sixdffpil.h, Release 1.2, 02/24/00

 * History:
     13-Dec-1999 - TJF - Original version
     24-Feb-2000 - TJF - Remove RCS header items and add Sccs Id.
 */

/*
 *  Include files
 */
#include "fpil.h"


/*
 *   This structure represents the telescope parameters which must
 *   be passed to FpilModelCvtInit() as it's tel argument when
 *   using the 2dF instrument model.
 *
 *   
 */
typedef struct {
    double ma;        /* Azimuth   misalignment of polar axis (arcsec) */
    double me;        /* Elevation misalignment of polar axis (arcsec) */
    double np;        /* Non perpendicularity of axes (arcsec)         */
    double ch;        /* Collimation error in HA (arcsec)              */
    double hf;        /* Horseshoe flexure coefficent (arcsec)         */
    double zgt;       /* Z-gear transducer reading                     */
} sixdfFpilTelParams;
/*
 * exported function prototypes
 */
extern void  sixdfFpil___SetupMinStructs(
    FpilCollisionChecksType *routines,
    FpilInstParamsType      *params);

extern void sixdfFpilMinInit(FpilType *inst);
extern void sixdfFpilFullInit(FpilType *inst);


/*
 *  Temp only, needs to be replaced.
 */
#define SIXDFFPIL__MALLOCERR 10

#ifdef __cplusplus
}
#endif
#endif
