/*+                 T D F C O N V E R T

 *  Module name:
      tdFconvertSds

 *  Function:
      Convert the C structure to an sds structure.

 *  Description:

 *  Language:
      C

 *  Support: James Wilcox, AAO

 *-

 *  History:
      05-Nov-93  JW  Original version
      18-Jun-99  TJF Free id's we no longer need.  (Does not clean up correctly
                 on errors, but is ok when there is no error).
      07-Aug-01  KS  Now creates an allocSky and allocGui item in the fieldData
                 section, and an allocObj.
      30-Aug-02  KS  pId structure should have been an array of shorts
                     not of ints. Now fixed.
      {@change entry@}

 *  Sccs Id: tdFconvertSds.c, Release 1.3, 09/10/02 (mm/dd/yy)
 */

#include <stdio.h>
#include <string.h>
#include "status.h"
#include "sds.h"
#include "conf_err.h"
#include "tdFconvert.h"

void tdFconvertToSds (
    char          *fieldName,
    tdFfieldType  *field,
    short         options,
    SdsIdType     *fileId,
    StatusType     *status)
{
    SdsIdType      fId = 0,     ugId = 0,
                   uoId = 0,    tmpId = 0,
                   nameId = 0,  commentId = 0,
                   raId = 0,    decId = 0,
                   xId = 0,     yId = 0,
                   typeId = 0,  priorityId = 0,
                   magId = 0,   pId = 0,
                   dhdxId = 0,    dddxId = 0,
                   dhdyId = 0,    dddyId = 0,
                   spectId = 0;
    unsigned long  dims[2];
    objectType     *tmpObj;
    unsigned long i;
    StatusType ignore = STATUS__OK;
    short zero = 0;

    if (*status != STATUS__OK) return;

    /*
     *  Create structure for sds file.
     */
    SdsNew(0,fieldName,0,NULL,SDS_STRUCT,0,NULL,fileId,status);
    SdsNew(*fileId,"fieldData",0,NULL,SDS_STRUCT,0,NULL,&fId,status);
    SdsNew(*fileId,"unallocGuide",0,NULL,SDS_STRUCT,0,NULL,&ugId,status);
    SdsNew(*fileId,"unallocObject",0,NULL,SDS_STRUCT,0,NULL,&uoId,status);

    /*
     *  Store field details.
     */
    SdsNew(fId,"cenRa",0,NULL,SDS_DOUBLE,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(double),0,&field->fieldData.cenRa,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"cenDec",0,NULL,SDS_DOUBLE,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(double),0,&field->fieldData.cenDec,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"appRa",0,NULL,SDS_DOUBLE,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(double),0,&field->fieldData.appRa,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"appDec",0,NULL,SDS_DOUBLE,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(double),0,&field->fieldData.appDec,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"appEpoch",0,NULL,SDS_DOUBLE,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(double),0,&field->fieldData.appEpoch,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"configMjd",0,NULL,SDS_DOUBLE,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(double),0,&field->fieldData.configMjd,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"unallocObj",0,NULL,SDS_SHORT,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(short),0,&field->fieldData.unallocObj,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"unallocGui",0,NULL,SDS_SHORT,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(short),0,&field->fieldData.unallocGui,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"unallocSky",0,NULL,SDS_SHORT,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(short),0,&field->fieldData.unallocSky,status);
    SdsFreeId(tmpId,status);
    dims[0] = COMMENT_LENGTH;
    SdsNew(fId,"label",0,NULL,SDS_CHAR,1,dims,&tmpId,status);
    SdsPut(tmpId,dims[0]*sizeof(char),0,field->fieldData.label,status);
    SdsFreeId(tmpId,status);
    dims[0] = ID_LENGTH;
    SdsNew(fId,"progId",0,NULL,SDS_CHAR,1,dims,&tmpId,status);
    SdsPut(tmpId,dims[0]*sizeof(char),0,field->fieldData.progId,status);
    SdsFreeId(tmpId,status);
    dims[0] = MODE_LENGTH;
    SdsNew(fId,"mode",0,NULL,SDS_CHAR,1,dims,&tmpId,status);
    SdsPut(tmpId,dims[0]*sizeof(char),0,field->fieldData.mode,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"allocSky",0,NULL,SDS_SHORT,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(short),0,&zero,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"allocGui",0,NULL,SDS_SHORT,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(short),0,&zero,status);
    SdsFreeId(tmpId,status);
    SdsNew(fId,"allocObj",0,NULL,SDS_SHORT,0,NULL,&tmpId,status);
    SdsPut(tmpId,sizeof(short),0,&zero,status);
    SdsFreeId(tmpId,status);

    /*
     *  Create unallocated objects structure.
     */
    dims[1] = field->fieldData.unallocObj + field->fieldData.unallocSky;
    dims[0] = NAME_LENGTH;
    SdsNew(uoId,"name",0,NULL,SDS_CHAR,2,dims,&nameId,status);
    SdsNew(uoId,"ra",0,NULL,SDS_DOUBLE,1,&dims[1],&raId,status);
    SdsNew(uoId,"dec",0,NULL,SDS_DOUBLE,1,&dims[1],&decId,status);
    SdsNew(uoId,"x",0,NULL,SDS_INT,1,&dims[1],&xId,status);
    SdsNew(uoId,"y",0,NULL,SDS_INT,1,&dims[1],&yId,status);
    SdsNew(uoId,"type",0,NULL,SDS_CHAR,1,&dims[1],&typeId,status);
    SdsNew(uoId,"spectrograph",0,NULL,SDS_CHAR,1,&dims[1],&spectId,status);
    if (options & PRIORITY)
        SdsNew(uoId,"priority",0,NULL,SDS_SHORT,1,&dims[1],&priorityId,status);
    if (options & MAGNITUDE)
        SdsNew(uoId,"magnitude",0,NULL,SDS_DOUBLE,1,&dims[1],&magId,status);
    if (options & PROG_ID)
        SdsNew(uoId,"pId",0,NULL,SDS_SHORT,1,&dims[1],&pId,status);
    dims[0] = COMMENT_LENGTH;
    if (options & COMMENT)
        SdsNew(uoId,"comment",0,NULL,SDS_CHAR,2,dims,&commentId,status);

    /*
     *  Store unallocated object details.
     */
    tmpObj = field->unallocObject;
    i = 0;
    while (tmpObj) {
        if (i >= dims[1]) {
            *status = CONF__TRAVERR;
            return;
        }
        SdsPut(nameId,NAME_LENGTH*sizeof(char),i*NAME_LENGTH,tmpObj->name,status);
        SdsPut(raId,sizeof(double),i,&tmpObj->ra,status);
        SdsPut(decId,sizeof(double),i,&tmpObj->dec,status);
        SdsPut(xId,sizeof(int),i,&tmpObj->x,status);
        SdsPut(yId,sizeof(int),i,&tmpObj->y,status);
        SdsPut(typeId,sizeof(char),i,&tmpObj->type,status);
        SdsPut(spectId,sizeof(char),i,&tmpObj->spectrograph,status);
        if (options & PRIORITY)
            SdsPut(priorityId,sizeof(short),i,&tmpObj->priority,status);
        if (options & MAGNITUDE)
            SdsPut(magId,sizeof(double),i,&tmpObj->magnitude,status);
        if (options & PROG_ID)
            SdsPut(pId,sizeof(short),i,&tmpObj->pId,status);
        if (options & COMMENT)
            SdsPut(commentId,COMMENT_LENGTH*sizeof(char),i*COMMENT_LENGTH,
                   tmpObj->comment,status);
        tmpObj = tmpObj->next;
        i++;
    }

/*
 *  Free the id's.
 */
    SdsFreeId(nameId,&ignore);
    nameId = 0;
    SdsFreeId(raId, &ignore);
    raId = 0;
    SdsFreeId(decId, &ignore);
    decId = 0;
    SdsFreeId(xId, &ignore);
    xId = 0;
    SdsFreeId(yId, &ignore);
    yId = 0;
    SdsFreeId(typeId, &ignore);
    typeId = 0;
    SdsFreeId(spectId, &ignore);
    spectId = 0;
    if (priorityId) {
        SdsFreeId(priorityId, &ignore);
        priorityId = 0;
    }
    if (magId) {
        SdsFreeId(magId, &ignore);
        magId = 0;
    }
    if (pId) {
        SdsFreeId(pId, &ignore);
        pId = 0;
    }
    if (commentId) {
        SdsFreeId(commentId, &ignore);
        commentId = 0;
    }


    if (i < dims[1]) {
        *status = CONF__TRAVERR;
        return;
    }
    /*
     *  Create unallocated guide structure.
     */
    dims[1] = field->fieldData.unallocGui;
    dims[0] = NAME_LENGTH;
    SdsNew(ugId,"name",0,NULL,SDS_CHAR,2,dims,&nameId,status);
    SdsNew(ugId,"ra",0,NULL,SDS_DOUBLE,1,&dims[1],&raId,status);
    SdsNew(ugId,"dec",0,NULL,SDS_DOUBLE,1,&dims[1],&decId,status);
    SdsNew(ugId,"x",0,NULL,SDS_INT,1,&dims[1],&xId,status);
    SdsNew(ugId,"y",0,NULL,SDS_INT,1,&dims[1],&yId,status);
    SdsNew(ugId,"type",0,NULL,SDS_CHAR,1,&dims[1],&typeId,status);
    SdsNew(ugId,"dhdx",0,NULL,SDS_DOUBLE,1,&dims[1],&dhdxId,status);
    SdsNew(ugId,"dddx",0,NULL,SDS_DOUBLE,1,&dims[1],&dddxId,status);
    SdsNew(ugId,"dhdy",0,NULL,SDS_DOUBLE,1,&dims[1],&dhdyId,status);
    SdsNew(ugId,"dddy",0,NULL,SDS_DOUBLE,1,&dims[1],&dddyId,status);
    if (options & PRIORITY)
        SdsNew(ugId,"priority",0,NULL,SDS_SHORT,1,&dims[1],&priorityId,status);
    if (options & MAGNITUDE)
        SdsNew(ugId,"magnitude",0,NULL,SDS_DOUBLE,1,&dims[1],&magId,status);
    if (options & PROG_ID)
        SdsNew(ugId,"pId",0,NULL,SDS_SHORT,1,&dims[1],&pId,status);
    dims[0] = COMMENT_LENGTH;
    if (options & COMMENT)
        SdsNew(ugId,"comment",0,NULL,SDS_CHAR,2,dims,&commentId,status);

    

 
    /*
     *  Store unallocated guide details.
     */
    tmpObj = field->unallocGuide;
    i = 0;
    while (tmpObj) {
        if (i >= dims[1]) {
            *status = CONF__TRAVERR;
            return;
        }
     
               
        SdsPut(nameId,NAME_LENGTH*sizeof(char),i*NAME_LENGTH,
               tmpObj->name,status);
        SdsPut(raId,sizeof(double),i,&tmpObj->ra,status);
        SdsPut(decId,sizeof(double),i,&tmpObj->dec,status);
        SdsPut(xId,sizeof(int),i,&tmpObj->x,status);
        SdsPut(yId,sizeof(int),i,&tmpObj->y,status);
        SdsPut(typeId,sizeof(char),i,&tmpObj->type,status);
        SdsPut(dhdxId,sizeof(double),i,&tmpObj->dhdx,status);
        SdsPut(dddxId,sizeof(double),i,&tmpObj->dddx,status);
        SdsPut(dhdyId,sizeof(double),i,&tmpObj->dhdy,status);
        SdsPut(dddyId,sizeof(double),i,&tmpObj->dddy,status);
        if (options & PRIORITY)
            SdsPut(priorityId,sizeof(short),i,&tmpObj->priority,status);
        if (options & MAGNITUDE)
            SdsPut(magId,sizeof(double),i,&tmpObj->magnitude,status);
        if (options & PROG_ID)
            SdsPut(pId,sizeof(short),i,&tmpObj->pId,status);
        if (options & COMMENT)
            SdsPut(commentId,COMMENT_LENGTH*sizeof(char),i*COMMENT_LENGTH,
                   tmpObj->comment,status);
        tmpObj = tmpObj->next;
        i++;
    }

/*
 *  Free the id's
 */
    SdsFreeId(nameId,&ignore);
    nameId = 0;
    SdsFreeId(raId, &ignore);
    raId = 0;
    SdsFreeId(decId, &ignore);
    decId = 0;
    SdsFreeId(xId, &ignore);
    xId = 0;
    SdsFreeId(yId, &ignore);
    yId = 0;
    SdsFreeId(typeId, &ignore);
    typeId = 0;
    SdsFreeId(dhdxId, &ignore);
    dhdxId = 0;
    SdsFreeId(dddxId, &ignore);
    dddxId = 0;
    SdsFreeId(dhdyId, &ignore);
    dhdyId = 0;
    SdsFreeId(dddyId, &ignore);
    dddyId = 0;
    if (priorityId) {
        SdsFreeId(priorityId, &ignore);
        priorityId = 0;
    }
    if (magId) {
        SdsFreeId(magId, &ignore);
        magId = 0;
    }
    if (pId) {
        SdsFreeId(pId, &ignore);
        pId = 0;
    }
    if (commentId) {
        SdsFreeId(commentId, &ignore);
        commentId = 0;
    }

    /*
     * Free the other id's
     */
    SdsFreeId(fId,&ignore);
    SdsFreeId(ugId, &ignore);
    SdsFreeId(uoId, &ignore);
    


    if (i < (unsigned)field->fieldData.unallocGui) {
        *status = CONF__TRAVERR;
        return;
     }
}
