/*****************************************************************************
 * Free42 -- an HP-42S calculator simulator
 * Copyright (C) 2004-2008  Thomas Okken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef CORE_LINALG1_H
#define CORE_LINALG1_H 1

#include "core_globals.h"

int linalg_div(const vartype *left, const vartype *right,
			     void (*completion)(int, vartype *)) LINALG1_SECT;
int linalg_mul(const vartype *left, const vartype *right,
			     void (*completion)(int, vartype *)) LINALG1_SECT;
int linalg_inv(const vartype *src, void (*completion)(int, vartype *))
								 LINALG1_SECT;
int linalg_det(const vartype *src, void (*completion)(int, vartype *))
								 LINALG1_SECT;

#endif
