// 15 August 1997, Rick Huebner:  Small changes made to adapt for MathLib

/* @(#)s_signif.c 5.1 93/09/24 */
/*
 * ====================================================
 * Copyright (C) 1993 by Sun Microsystems, Inc. All rights reserved.
 *
 * Developed at SunPro, a Sun Microsystems, Inc. business.
 * Permission to use, copy, modify, and distribute this
 * software is freely granted, provided that this notice
 * is preserved.
 * ====================================================
 */

#if defined(LIBM_SCCS) && !defined(lint)
static char rcsid[] = "$NetBSD: s_significand.c,v 1.6 1995/05/10 20:48:11 jtc Exp $";
#endif

/*
 * significand(x) computes just
 * 	scalb(x, (double) -ilogb(x)),
 * for exercising the fraction-part(F) IEEE 754-1985 test vector.
 */

#include "mathlib_math.h"
#include "mathlib_math_private.h"

#ifdef __STDC__
	double __significand(double x)
#else
	double __significand(x)
	double x;
#endif
{
	return __ieee754_scalb(x,(double) -__ilogb(x));
}
weak_alias (__significand, significand)
#ifdef NO_LONG_DOUBLE
strong_alias (__significand, __significandl)
weak_alias (__significand, significandl)
#endif
