// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package shared

import (
	"github.com/cli/cli/v2/pkg/iostreams"
	"io"
	"sync"
)

// Ensure, that LogRendererMock does implement LogRenderer.
// If this is not the case, regenerate this file with moq.
var _ LogRenderer = &LogRendererMock{}

// LogRendererMock is a mock implementation of LogRenderer.
//
//	func TestSomethingThatUsesLogRenderer(t *testing.T) {
//
//		// make and configure a mocked LogRenderer
//		mockedLogRenderer := &LogRendererMock{
//			FollowFunc: func(fetcher func() ([]byte, error), w io.Writer, ioMoqParam *iostreams.IOStreams) error {
//				panic("mock out the Follow method")
//			},
//			RenderFunc: func(logs []byte, w io.Writer, ioMoqParam *iostreams.IOStreams) (bool, error) {
//				panic("mock out the Render method")
//			},
//		}
//
//		// use mockedLogRenderer in code that requires LogRenderer
//		// and then make assertions.
//
//	}
type LogRendererMock struct {
	// FollowFunc mocks the Follow method.
	FollowFunc func(fetcher func() ([]byte, error), w io.Writer, ioMoqParam *iostreams.IOStreams) error

	// RenderFunc mocks the Render method.
	RenderFunc func(logs []byte, w io.Writer, ioMoqParam *iostreams.IOStreams) (bool, error)

	// calls tracks calls to the methods.
	calls struct {
		// Follow holds details about calls to the Follow method.
		Follow []struct {
			// Fetcher is the fetcher argument value.
			Fetcher func() ([]byte, error)
			// W is the w argument value.
			W io.Writer
			// IoMoqParam is the ioMoqParam argument value.
			IoMoqParam *iostreams.IOStreams
		}
		// Render holds details about calls to the Render method.
		Render []struct {
			// Logs is the logs argument value.
			Logs []byte
			// W is the w argument value.
			W io.Writer
			// IoMoqParam is the ioMoqParam argument value.
			IoMoqParam *iostreams.IOStreams
		}
	}
	lockFollow sync.RWMutex
	lockRender sync.RWMutex
}

// Follow calls FollowFunc.
func (mock *LogRendererMock) Follow(fetcher func() ([]byte, error), w io.Writer, ioMoqParam *iostreams.IOStreams) error {
	if mock.FollowFunc == nil {
		panic("LogRendererMock.FollowFunc: method is nil but LogRenderer.Follow was just called")
	}
	callInfo := struct {
		Fetcher    func() ([]byte, error)
		W          io.Writer
		IoMoqParam *iostreams.IOStreams
	}{
		Fetcher:    fetcher,
		W:          w,
		IoMoqParam: ioMoqParam,
	}
	mock.lockFollow.Lock()
	mock.calls.Follow = append(mock.calls.Follow, callInfo)
	mock.lockFollow.Unlock()
	return mock.FollowFunc(fetcher, w, ioMoqParam)
}

// FollowCalls gets all the calls that were made to Follow.
// Check the length with:
//
//	len(mockedLogRenderer.FollowCalls())
func (mock *LogRendererMock) FollowCalls() []struct {
	Fetcher    func() ([]byte, error)
	W          io.Writer
	IoMoqParam *iostreams.IOStreams
} {
	var calls []struct {
		Fetcher    func() ([]byte, error)
		W          io.Writer
		IoMoqParam *iostreams.IOStreams
	}
	mock.lockFollow.RLock()
	calls = mock.calls.Follow
	mock.lockFollow.RUnlock()
	return calls
}

// Render calls RenderFunc.
func (mock *LogRendererMock) Render(logs []byte, w io.Writer, ioMoqParam *iostreams.IOStreams) (bool, error) {
	if mock.RenderFunc == nil {
		panic("LogRendererMock.RenderFunc: method is nil but LogRenderer.Render was just called")
	}
	callInfo := struct {
		Logs       []byte
		W          io.Writer
		IoMoqParam *iostreams.IOStreams
	}{
		Logs:       logs,
		W:          w,
		IoMoqParam: ioMoqParam,
	}
	mock.lockRender.Lock()
	mock.calls.Render = append(mock.calls.Render, callInfo)
	mock.lockRender.Unlock()
	return mock.RenderFunc(logs, w, ioMoqParam)
}

// RenderCalls gets all the calls that were made to Render.
// Check the length with:
//
//	len(mockedLogRenderer.RenderCalls())
func (mock *LogRendererMock) RenderCalls() []struct {
	Logs       []byte
	W          io.Writer
	IoMoqParam *iostreams.IOStreams
} {
	var calls []struct {
		Logs       []byte
		W          io.Writer
		IoMoqParam *iostreams.IOStreams
	}
	mock.lockRender.RLock()
	calls = mock.calls.Render
	mock.lockRender.RUnlock()
	return calls
}
