/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfs.CatKeyRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogString;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusCatalogKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSCatalogKey
extends CommonBTKey<CommonHFSCatalogKey>
implements StructElements {
    public abstract CommonHFSCatalogNodeID getParentID();

    public abstract CommonHFSCatalogString getNodeName();

    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + CommonHFSCatalogKey.class.getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public static CommonHFSCatalogKey create(HFSPlusCatalogKey key) {
        return new HFSPlusImplementation(key);
    }

    public static CommonHFSCatalogKey create(CatKeyRec key) {
        return new HFSImplementation(key);
    }

    public static class HFSImplementation
    extends CommonHFSCatalogKey {
        private final CatKeyRec key;

        public HFSImplementation(CatKeyRec key) {
            this.key = key;
        }

        public CommonHFSCatalogNodeID getParentID() {
            return CommonHFSCatalogNodeID.create(this.key.getCkrParID());
        }

        public CommonHFSCatalogString getNodeName() {
            return CommonHFSCatalogString.createHFS(this.key.getCkrCName());
        }

        public int maxSize() {
            return this.key.maxSize();
        }

        public int occupiedSize() {
            return this.key.occupiedSize();
        }

        public byte[] getBytes() {
            return this.key.getBytes();
        }

        public int compareTo(CommonHFSCatalogKey o) {
            if (o instanceof HFSImplementation) {
                HFSImplementation k = (HFSImplementation)o;
                long res = this.getParentID().toLong() - k.getParentID().toLong();
                if (res == 0L) {
                    int res2 = Util.unsignedArrayCompareLex(this.key.getCkrCName(), k.key.getCkrCName());
                    if (res2 == 0) {
                        return 0;
                    }
                    if (res2 > 0) {
                        return 1;
                    }
                    return -1;
                }
                if (res > 0L) {
                    return 1;
                }
                return -1;
            }
            throw new RuntimeException("Can't compare a " + o.getClass() + " with a " + this.getClass());
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.key.getStructElements();
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSCatalogKey {
        private final HFSPlusCatalogKey key;

        public HFSPlusImplementation(HFSPlusCatalogKey key) {
            this.key = key;
        }

        public CommonHFSCatalogNodeID getParentID() {
            return CommonHFSCatalogNodeID.create(this.key.getParentID());
        }

        public CommonHFSCatalogString getNodeName() {
            return CommonHFSCatalogString.createHFSPlus(this.key.getNodeName());
        }

        public byte[] getBytes() {
            return this.key.getBytes();
        }

        public int compareTo(CommonHFSCatalogKey o) {
            if (o instanceof HFSPlusImplementation) {
                HFSPlusImplementation k = (HFSPlusImplementation)o;
                return this.key.compareTo(k.key);
            }
            throw new RuntimeException("Can't compare a " + o.getClass() + " with a " + this.getClass());
        }

        public int maxSize() {
            return this.key.maxSize();
        }

        public int occupiedSize() {
            return this.key.occupiedSize();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.key.getStructElements();
        }
    }
}

