/*-
 * Copyright (C) 2008 Erik Larsson
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer.gui;

import org.catacombae.csjc.structelements.StringRepresentableField;

/**
 *
 * @author erik
 */
public class TextViewPanel extends javax.swing.JPanel {

    /** Creates new form TextViewPanel */
    public TextViewPanel(String label, StringRepresentableField field) {
        initComponents();

        fieldLabel.setText(label);

        String fieldContentsText = field.getValueAsString();
        String suffix = field.getUnitComponent();
        if(suffix != null)
            fieldContentsText += " " + suffix;

        fieldContents.setText(fieldContentsText);

        jLabel1.setVisible(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        fieldLabel = new javax.swing.JLabel();
        fieldContents = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();

        fieldLabel.setText("jLabel1");

        fieldContents.setEditable(false);
        fieldContents.setText("jTextField1");
        fieldContents.setBorder(null);
        fieldContents.setOpaque(false);

        jLabel1.setText("jLabel1");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(fieldLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(fieldContents, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 87, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .add(jLabel1)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(fieldLabel)
                    .add(fieldContents, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel1))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField fieldContents;
    private javax.swing.JLabel fieldLabel;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

}
