subroutine obs_list_new(list,book,obs,error)
  use gbl_message
  use class_types
  use mrtcal_calib_types
  use mrtcal_dependencies_interfaces
  use mrtcal_interfaces, except_this=>obs_list_new
  !---------------------------------------------------------------------
  ! @ private
  ! Prepare a new observation from the list and return a pointer to it
  !---------------------------------------------------------------------
  type(obs_list_t), target, intent(inout) :: list   !
  type(drift_book_t),       pointer       :: book   ! Set in return
  type(observation),        pointer       :: obs    ! Set in return
  logical,                  intent(inout) :: error  !
  ! Local
  character(len=*), parameter :: rname='OBS>LIST>NEW'
  !
  if (list%n.ge.mobs_list_t) then
    call mrtcal_message(seve%e,rname,'Internal list is full')
    error = .true.
    return
  endif
  !
  list%n = list%n+1
  book => list%book(list%n)
  obs => list%obs(list%n)
  !
  ! Initialize the observation: beware you can not Initialize an observation
  ! twice, except if you have cleaned it before (class_obs_clean)
  call class_obs_init(obs,error)
  if (error)  return
  !
end subroutine obs_list_new
!
subroutine free_obs_list(list,error)
  use mrtcal_calib_types
  use mrtcal_dependencies_interfaces
  use mrtcal_interfaces, except_this=>free_obs_list
  !---------------------------------------------------------------------
  ! @ private
  ! Free a whole list type
  !---------------------------------------------------------------------
  type(obs_list_t), intent(inout) :: list
  logical,          intent(inout) :: error
  ! Local
  integer(kind=4) :: iobs
  !
  do iobs=1,list%n
    ! NB: only the initialized ones can be freed
    call class_obs_clean(list%obs(iobs),error)
    if (error)  continue
  enddo
  list%n = 0
  !
end subroutine free_obs_list
!
subroutine obs_list_to_idx(list,optx,error)
  use class_types
  use mrtcal_calib_types
  use mrtcal_dependencies_interfaces
  !---------------------------------------------------------------------
  ! @ private
  ! Create a CLASS index from an obs_list_t
  !---------------------------------------------------------------------
  type(obs_list_t), intent(in)    :: list
  type(optimize),   intent(inout) :: optx
  logical,          intent(inout) :: error
  ! Local
  logical, parameter :: long=.true.
  integer(kind=entry_length) :: iobs
  type(indx_t) :: ind
  !
  call reallocate_optimize(optx,list%n,long,.false.,error)
  if (error)  return
  !
  do iobs=1,list%n
    ! ZZZ CLASS should provide an API which avoids passing through a type(indx_t)
    call index_fromobs(list%obs(iobs)%head,ind,error)
    if (error)  return
    call index_tooptimize(ind,iobs,long,iobs,optx,error)
    if (error)  return
  enddo
  optx%next = list%n+1
  !
end subroutine obs_list_to_idx
!
subroutine obs_list_to_selection(list,keys,select,error)
  use toc_types
  use class_types
  use mrtcal_calib_types
  use mrtcal_dependencies_interfaces
  use mrtcal_interfaces, except_this=>obs_list_to_selection
  !---------------------------------------------------------------------
  ! @ private
  ! Create a toc_selection_t
  !---------------------------------------------------------------------
  type(obs_list_t),      intent(in)    :: list
  integer(kind=4),       intent(in)    :: keys(:)
  type(toc_selection_t), intent(inout) :: select
  logical,               intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='OBS>LIST>TO>SELECTION'
  type(optimize) :: optx
  type(toc_t), target :: ltoc
  integer(kind=4), parameter :: silent_lun=0
  !
  call obs_list_to_idx(list,optx,error)
  if (error)  return
  call class_toc_init(ltoc,error)
  if (error)  return
  call class_toc_datasetup(ltoc,optx)
  call toc_main(rname,ltoc,optx%next-1,keys,'',silent_lun,toc_format,error,dobak=.true.)
  if (error)  return
  call ltoc%all%select%copy(select,error)
  if (error)  continue
  !
  call deallocate_optimize(optx,error)
  if (error)  continue
  call toc_clean(ltoc,error)
  if (error)  continue
end subroutine obs_list_to_selection
