!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeheader_edit_tool
  use cubetools_structure
  use cubetools_keywordlist_types
  use cubetools_messaging
  use cubetools_header_array_types
  use cubetools_spatial_types
  use cubetools_spectral_prog_types
  use cubetools_spectral_frame_types
  use cubetools_spectral_line_types
  use cubetools_spectral_f_or_w_types
  use cubetools_spectral_v_or_z_types
  use cubetools_axset_types
  use cubetools_noise_types
  use cubetools_observatory_types
  !
  public :: edit_comm_t,edit_user_t
  private
  !
  type :: edit_comm_t
     type(spatial_source_opt_t)     :: source        
     type(spafra_opt_t)             :: spafra  
     type(spapro_type_opt_t)        :: ptype
     type(spapro_center_opt_t)      :: pcenter
     type(spapro_angle_opt_t)       :: pangle
     type(beam_opt_t)               :: beam          
     type(option_t),      pointer   :: unit          
     type(noise_opt_t)              :: noise
     type(option_t),      pointer   :: axis
     type(keywordlist_comm_t), pointer :: ax_kind
     type(observatory_opt_t)        :: obs
     type(spectral_line_comm_t)     :: line
     type(spectral_f_or_w_comm_t)   :: f_or_w
     type(spectral_v_or_z_comm_t)   :: v_or_z
     type(spectral_frame_comm_t)    :: spefra
     type(option_t),      pointer   :: axnames
   contains
     procedure, public :: register => cubeheader_edit_register
     procedure, public :: parse    => cubeheader_edit_parse
     procedure, public :: main     => cubeheader_edit_main
  end type edit_comm_t
  !
  type edit_user_t
     type(spatial_source_user_t)    :: source
     type(spafra_user_t)            :: spafra
     type(spapro_type_user_t)       :: ptype
     type(spapro_center_user_t)     :: pcenter
     type(spapro_angle_user_t)      :: pangle
     type(beam_user_t)              :: beam
     type(axset_axis_user_t)        :: axis
     type(array_unit_user_t)        :: unit
     type(noise_user_t)             :: noise
     type(axset_axnames_user_t)     :: axnames
     type(observatory_user_t)       :: obs
     type(spectral_line_user_t)     :: line
     type(spectral_f_or_w_user_t)   :: f_or_w
     type(spectral_v_or_z_user_t)   :: v_or_z
     type(spectral_frame_user_t)    :: spefra
  end type edit_user_t
  !
contains
  !
  subroutine cubeheader_edit_register(comm,error)
    !----------------------------------------------------------------------
    ! Register keys related to header edition
    !----------------------------------------------------------------------
    class(edit_comm_t), intent(inout) :: comm
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='PUT>HEADER>REGISTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call comm%source%register(&
         'Put a new source name',&
         error)
    if (error) return
    !
    call comm%spafra%register(&
         'Put new Spatial frame information',&
         error)
    if (error) return
    !
    call comm%ptype%register(&
         'PTYPE',&
         'Put a new projection type',&
         error)
    if (error) return
    call comm%pcenter%register(&
         'PCENTER',&
         'Put a new projection center',&
         error)
    if (error) return
    call comm%pangle%register(&
         'PANGLE',&
         'Put a new projection angle',&
         error)
    if (error) return
    !
    call comm%beam%register(&
         'Put a new beam',&
         error)
    if (error) return
    !
    !----------------------------------------------------------------------
    !
    call cubetools_array_unit_register(&
         'UNIT',&
         'Put a new unit for the cube',&
         comm%unit,error)
    if (error) return
    !
    call comm%noise%register(&
         'Put new noise values',&
         error)
    if (error) return
    !
    call cubetools_axset_axis_register(&
         'AXIS',&
         'Put a new axis description for one of the current axes',&
         comm%axis,comm%ax_kind,error)
    if (error) return
    !
    call cubetools_axset_axnames_register(&
         'AXNAMES',&
         'Put new names on cube''s axes',&
         comm%axnames,error)
    if (error) return
    !
    !----------------------------------------------------------------------
    !
    call comm%obs%register(&
         'Put new observatory information',&
         error)
    if (error) return
    !
    !----------------------------------------------------------------------
    !
    call comm%line%register(&
         'Put a new line name',&
         error)
    if (error) return
    !
    call comm%f_or_w%register(error)
    if (error) return
    call comm%v_or_z%register(error)
    if (error) return
    !
    call comm%spefra%register(&
         'Put new spectral frame information',&
         error)
    if (error) return
  end subroutine cubeheader_edit_register
  !
  subroutine cubeheader_edit_parse(comm,line,user,error)
    !-------------------------------------------------------------------
    ! Parse routine for header part of command PUT
    !-------------------------------------------------------------------
    class(edit_comm_t), intent(in)    :: comm
    character(len=*),   intent(in)    :: line
    type(edit_user_t),  intent(out)   :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='PUT>HEADER>PARSE'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call comm%source%parse(line,user%source,error)
    if (error) return
    call comm%spafra%parse(line,user%spafra,error)
    if (error) return
    call comm%ptype%parse(line,user%ptype,error)
    if (error) return
    call comm%pcenter%parse(line,user%pcenter,error)
    if (error) return
    call comm%pangle%parse(line,user%pangle,error)
    if (error) return
    call comm%beam%parse(line,user%beam,error)
    if (error) return
    !
    call cubetools_array_unit_parse(line,comm%unit,user%unit,error)
    if (error) return
    call comm%noise%parse(line,user%noise,error)
    if (error) return
    call cubetools_axset_axis_parse(line,comm%axis,user%axis,error)
    if (error) return
    call cubetools_axset_axnames_parse(line,comm%axnames,user%axnames,error)
    if (error) return
    !
    call comm%obs%parse(line,user%obs,error)
    if (error) return
    !
    call comm%line%parse(line,user%line,error)
    if (error) return
    call comm%f_or_w%parse(line,user%f_or_w,error)
    if (error) return
    call comm%v_or_z%parse(line,user%v_or_z,error)
    if (error) return
    call comm%spefra%parse(line,user%spefra,error)
    if (error) return
  end subroutine cubeheader_edit_parse
  !
  subroutine cubeheader_edit_main(comm,user,head,error)
    use cubetools_header_interface !***JP: Ugly patch. Do not reuse elsewhere!
    use cubetools_header_types     !***JP: Ugly patch. Do not reuse elsewhere!
    !-------------------------------------------------------------------
    ! Main routine for header part of command PUT
    !-------------------------------------------------------------------
    class(edit_comm_t),  intent(in)    :: comm
    type(edit_user_t),   intent(in)    :: user
    type(cube_header_t), intent(inout) :: head
    logical,             intent(inout) :: error
    !
    type(cube_header_interface_t) :: headinter
    character(len=*), parameter :: rname='PUT>HEADER>MAIN'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call comm%source%user2prog(user%source,head%spa%source,error)
    if (error) return
    call comm%spafra%user2prog(user%spafra,head%spa%fra,error)
    if (error) return
    call comm%ptype%user2prog(user%ptype,head%spa%pro,error)
    if (error) return
    call comm%pcenter%user2prog(head%spa%fra,user%pcenter,head%spa%pro,error)
    if (error) return
    call comm%pangle%user2prog(user%pangle,head%spa%pro,error)
    if (error) return
    call comm%beam%user2prog(user%beam,head%spa%bea,error)
    if (error) return
    !
    call cubetools_array_unit_user2prog(user%unit,head%arr%unit,error)
    if (error) return
    call comm%noise%user2prog(user%noise,head%arr%noi,error)
    if (error) return
    call cubetools_axset_axis_user2prog(user%axis,head%set,error)
    if (error) return
    call cubetools_axset_axnames_user2prog(user%axnames,head%set,error)
    if (error) return
    !
    call comm%obs%user2prog(user%obs,head%obs,error)
    if (error) return
    !
    call user%line%toprog(head%spe,error)
    if (error) return
    !***JP: Ugly patch. Do not reuse elsewhere!
    call cubetools_header_export(head,headinter,error)
    if (error) return
    call user%f_or_w%toprog(headinter,error)
    if (error) return
    call user%v_or_z%toprog(comm%v_or_z,headinter,error)
    if (error) return
    call cubetools_header_import_and_derive(headinter,head,error)
    if (error) return
    !***JP: Ugly patch. Do not reuse elsewhere!
    call user%spefra%toprog(comm%spefra,head%spe,error)
    if (error) return
  end subroutine cubeheader_edit_main
end module cubeheader_edit_tool
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
