!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_keyval_list_tool
  use cubetools_parameters
  use cubetools_format
  use cubesyntax_messaging
  !
  public :: keyval_list_t
  public :: keyval
  private
  !
  type keyval_list_t
   contains
     procedure, private :: list_inte => cubesyntax_keyval_list_inte
!!$     procedure, private :: list_long => cubesyntax_keyval_list_long
     procedure, private :: list_real => cubesyntax_keyval_list_real
     procedure, private :: list_dble => cubesyntax_keyval_list_dble
     procedure, private :: list_strg => cubesyntax_keyval_list_strg
     generic,   public  :: list => list_inte,list_real,list_dble,list_strg
  end type keyval_list_t
  type(keyval_list_t) :: keyval
  !
  integer(kind=4) :: list_l = 40
  !
  character(len=mess_l) :: mess
  !
contains
  !
  subroutine cubesyntax_keyval_list_inte(prog,name,value,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(keyval_list_t), intent(in)    :: prog
    character(len=*),     intent(in)    :: name
    integer(kind=inte_k), intent(in)    :: value
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='KEYVAL>LIST>INTE'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    mess = '  '//cubetools_format_stdkey_boldval(name,value,'i0',list_l)
    call cubesyntax_message(seve%r,rname,mess)
  end subroutine cubesyntax_keyval_list_inte
  !
  subroutine cubesyntax_keyval_list_real(prog,name,value,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(keyval_list_t), intent(in)    :: prog
    character(len=*),     intent(in)    :: name
    real(kind=real_k),    intent(in)    :: value
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='KEYVAL>LIST>REAL'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    mess = '  '//cubetools_format_stdkey_boldval(name,value,fsimple,list_l)
    call cubesyntax_message(seve%r,rname,mess)
  end subroutine cubesyntax_keyval_list_real
  !
  subroutine cubesyntax_keyval_list_dble(prog,name,value,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(keyval_list_t), intent(in)    :: prog
    character(len=*),     intent(in)    :: name
    real(kind=dble_k),    intent(in)    :: value
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='KEYVAL>LIST>DBLE'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    mess = '  '//cubetools_format_stdkey_boldval(name,value,fdouble,list_l)
    call cubesyntax_message(seve%r,rname,mess)
  end subroutine cubesyntax_keyval_list_dble
  !
  subroutine cubesyntax_keyval_list_strg(prog,name,value,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(keyval_list_t), intent(in)    :: prog
    character(len=*),     intent(in)    :: name
    character(len=*),     intent(in)    :: value
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='KEYVAL>LIST>STRG'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    mess = '  '//cubetools_format_stdkey_boldval(name,value,list_l)
    call cubesyntax_message(seve%r,rname,mess)
  end subroutine cubesyntax_keyval_list_strg
end module cubesyntax_keyval_list_tool
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
