!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!***JP: An almost verbatim copy of cubemain_ancillary_mask_types => Should be merged
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_ancillary_weight_types
  use cubetools_parameters
  use cubemain_messaging
  use cubeadm_ancillary_cube_types
  !
  public :: ancillary_weight_comm_t,ancillary_weight_user_t,ancillary_weight_prog_t
  private
  !
  type, extends(ancillary_cube_comm_t) :: ancillary_weight_comm_t
   contains
     procedure, public :: register => cubemain_ancillary_weight_comm_register
  end type ancillary_weight_comm_t
  !
  type, extends(ancillary_cube_user_t) :: ancillary_weight_user_t
     ! Empty for the moment
  end type ancillary_weight_user_t
  !
  ! *** JP to be generic we would need to add the possibility of a spectral weight...
  type, extends(ancillary_cube_prog_t) :: ancillary_weight_prog_t
     logical :: isspatial = .false. ! Spatial or cube?
   contains
     procedure, public :: check_consistency => cubemain_ancillary_weight_prog_check_consistency
     procedure, public :: must_be_spatial   => cubemain_ancillary_weight_must_be_spatial
     procedure, public :: must_be_3d        => cubemain_ancillary_weight_must_be_3d
  end type ancillary_weight_prog_t
  !
contains
  !
  subroutine cubemain_ancillary_weight_comm_register(comm,abstract,access,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! Register an optional "/WEIGHT [weightid]" key
    !----------------------------------------------------------------------
    class(ancillary_weight_comm_t), intent(inout) :: comm
    character(len=*),               intent(in)    :: abstract
    integer(kind=code_k),           intent(in)    :: access
    logical,                        intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>WEIGHT>COMM>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call comm%fully_register(&
         'WEIGHT','[weightid]',&
         abstract,strg_id,&
         'WEIGHT',&
         'Weight cube can be 2D or 3D',&
         [flag_weight],&
         code_arg_optional,&
         code_read,&
         access,&
         error)
    if (error) return
  end subroutine cubemain_ancillary_weight_comm_register
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_ancillary_weight_prog_check_consistency(weight,refcube,error)
    use cubetools_header_methods
    use cube_types
    use cubeadm_consistency
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ancillary_weight_prog_t), intent(inout) :: weight
    type(cube_t),                   intent(in)    :: refcube
    logical,                        intent(inout) :: error
    !
    integer(kind=chan_k) :: nc
    type(consistency_t) :: cons
    character(len=*), parameter :: rname='ANCILLARY>WEIGHT>PROG>CHECK>CONSISTENCY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (.not.weight%do) return
    !
    call cubetools_header_get_nchan(weight%cube%head,nc,error)
    if (error) return
    weight%isspatial = nc.eq.1
    if (weight%isspatial) then
       call cons%spatial('Input cube',refcube,'Weight',weight%cube,error)
       if (error) return
    else
       call cons%grid('Input cube',refcube,'Weight',weight%cube,error)
       if (error) return
    endif    
  end subroutine cubemain_ancillary_weight_prog_check_consistency
  !
  subroutine cubemain_ancillary_weight_must_be_spatial(weight,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ancillary_weight_prog_t), intent(inout) :: weight
    logical,                        intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>WEIGHT>MUST>BE>SPATIAL'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (.not.weight%isspatial) then
       call cubemain_message(seve%e,rname,'A spatial weight is required')
    endif
  end subroutine cubemain_ancillary_weight_must_be_spatial
  !
  subroutine cubemain_ancillary_weight_must_be_3d(weight,error)
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(ancillary_weight_prog_t), intent(inout) :: weight
    logical,                        intent(inout) :: error
    !
    character(len=*), parameter :: rname='ANCILLARY>WEIGHT>MUST>BE>3D'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (weight%isspatial) then
       call cubemain_message(seve%e,rname,'A 3D weight is required')
    endif
  end subroutine cubemain_ancillary_weight_must_be_3d
end module cubemain_ancillary_weight_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
