//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azopenaiassistants

// FilePurpose - The possible values denoting the intended usage of a file.
type FilePurpose string

const (
	// FilePurposeAssistants - Indicates a file is used as input to assistants.
	FilePurposeAssistants FilePurpose = "assistants"
	// FilePurposeAssistantsOutput - Indicates a file is used as output by assistants.
	FilePurposeAssistantsOutput FilePurpose = "assistants_output"
	// FilePurposeFineTune - Indicates a file is used for fine tuning input.
	FilePurposeFineTune FilePurpose = "fine-tune"
	// FilePurposeFineTuneResults - Indicates a file is used for fine tuning results.
	FilePurposeFineTuneResults FilePurpose = "fine-tune-results"
)

// PossibleFilePurposeValues returns the possible values for the FilePurpose const type.
func PossibleFilePurposeValues() []FilePurpose {
	return []FilePurpose{
		FilePurposeAssistants,
		FilePurposeAssistantsOutput,
		FilePurposeFineTune,
		FilePurposeFineTuneResults,
	}
}

// ListSortOrder - The available sorting options when requesting a list of response objects.
type ListSortOrder string

const (
	// ListSortOrderAscending - Specifies an ascending sort order.
	ListSortOrderAscending ListSortOrder = "asc"
	// ListSortOrderDescending - Specifies a descending sort order.
	ListSortOrderDescending ListSortOrder = "desc"
)

// PossibleListSortOrderValues returns the possible values for the ListSortOrder const type.
func PossibleListSortOrderValues() []ListSortOrder {
	return []ListSortOrder{
		ListSortOrderAscending,
		ListSortOrderDescending,
	}
}

// MessageRole - The possible values for roles attributed to messages in a thread.
type MessageRole string

const (
	// MessageRoleAssistant - The role representing the assistant.
	MessageRoleAssistant MessageRole = "assistant"
	// MessageRoleUser - The role representing the end-user.
	MessageRoleUser MessageRole = "user"
)

// PossibleMessageRoleValues returns the possible values for the MessageRole const type.
func PossibleMessageRoleValues() []MessageRole {
	return []MessageRole{
		MessageRoleAssistant,
		MessageRoleUser,
	}
}

// RunStatus - Possible values for the status of an assistant thread run.
type RunStatus string

const (
	// RunStatusCancelled - Represents a run that has been cancelled.
	RunStatusCancelled RunStatus = "cancelled"
	// RunStatusCancelling - Represents a run that is in the process of cancellation.
	RunStatusCancelling RunStatus = "cancelling"
	// RunStatusCompleted - Represents a run that successfully completed.
	RunStatusCompleted RunStatus = "completed"
	// RunStatusExpired - Represents a run that expired before it could otherwise finish.
	RunStatusExpired RunStatus = "expired"
	// RunStatusFailed - Represents a run that failed.
	RunStatusFailed RunStatus = "failed"
	// RunStatusInProgress - Represents a run that is in progress.
	RunStatusInProgress RunStatus = "in_progress"
	// RunStatusQueued - Represents a run that is queued to start.
	RunStatusQueued RunStatus = "queued"
	// RunStatusRequiresAction - Represents a run that needs another operation, such as tool output submission, to continue.
	RunStatusRequiresAction RunStatus = "requires_action"
)

// PossibleRunStatusValues returns the possible values for the RunStatus const type.
func PossibleRunStatusValues() []RunStatus {
	return []RunStatus{
		RunStatusCancelled,
		RunStatusCancelling,
		RunStatusCompleted,
		RunStatusExpired,
		RunStatusFailed,
		RunStatusInProgress,
		RunStatusQueued,
		RunStatusRequiresAction,
	}
}

// RunStepErrorCode - Possible error code values attributable to a failed run step.
type RunStepErrorCode string

const (
	// RunStepErrorCodeRateLimitExceeded - Represents an error indicating configured rate limits were exceeded.
	RunStepErrorCodeRateLimitExceeded RunStepErrorCode = "rate_limit_exceeded"
	// RunStepErrorCodeServerError - Represents a server error.
	RunStepErrorCodeServerError RunStepErrorCode = "server_error"
)

// PossibleRunStepErrorCodeValues returns the possible values for the RunStepErrorCode const type.
func PossibleRunStepErrorCodeValues() []RunStepErrorCode {
	return []RunStepErrorCode{
		RunStepErrorCodeRateLimitExceeded,
		RunStepErrorCodeServerError,
	}
}

// RunStepStatus - Possible values for the status of a run step.
type RunStepStatus string

const (
	// RunStepStatusCancelled - Represents a run step that was cancelled.
	RunStepStatusCancelled RunStepStatus = "cancelled"
	// RunStepStatusCompleted - Represents a run step that successfully completed.
	RunStepStatusCompleted RunStepStatus = "completed"
	// RunStepStatusExpired - Represents a run step that expired before otherwise finishing.
	RunStepStatusExpired RunStepStatus = "expired"
	// RunStepStatusFailed - Represents a run step that failed.
	RunStepStatusFailed RunStepStatus = "failed"
	// RunStepStatusInProgress - Represents a run step still in progress.
	RunStepStatusInProgress RunStepStatus = "in_progress"
)

// PossibleRunStepStatusValues returns the possible values for the RunStepStatus const type.
func PossibleRunStepStatusValues() []RunStepStatus {
	return []RunStepStatus{
		RunStepStatusCancelled,
		RunStepStatusCompleted,
		RunStepStatusExpired,
		RunStepStatusFailed,
		RunStepStatusInProgress,
	}
}

// RunStepType - The possible types of run steps.
type RunStepType string

const (
	// RunStepTypeMessageCreation - Represents a run step to create a message.
	RunStepTypeMessageCreation RunStepType = "message_creation"
	// RunStepTypeToolCalls - Represents a run step that calls tools.
	RunStepTypeToolCalls RunStepType = "tool_calls"
)

// PossibleRunStepTypeValues returns the possible values for the RunStepType const type.
func PossibleRunStepTypeValues() []RunStepType {
	return []RunStepType{
		RunStepTypeMessageCreation,
		RunStepTypeToolCalls,
	}
}

// ServiceAPIVersions - The known set of supported API versions.
type ServiceAPIVersions string

const (
	// ServiceAPIVersionsV20240215Preview - The initial version of Azure OpenAI Assistants that corresponds to functionality in
	// OpenAI's first beta release.
	ServiceAPIVersionsV20240215Preview ServiceAPIVersions = "2024-02-15-preview"
)

// PossibleServiceAPIVersionsValues returns the possible values for the ServiceAPIVersions const type.
func PossibleServiceAPIVersionsValues() []ServiceAPIVersions {
	return []ServiceAPIVersions{
		ServiceAPIVersionsV20240215Preview,
	}
}
