//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by Microsoft (R) AutoRest Code Generator.Changes may cause incorrect behavior and will be lost if the code
// is regenerated.
// Code generated by @autorest/go. DO NOT EDIT.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/connectedvmware/armconnectedvmware"
	"net/http"
	"net/url"
	"regexp"
)

// VMInstanceHybridIdentityMetadataServer is a fake server for instances of the armconnectedvmware.VMInstanceHybridIdentityMetadataClient type.
type VMInstanceHybridIdentityMetadataServer struct {
	// Get is the fake for method VMInstanceHybridIdentityMetadataClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceURI string, options *armconnectedvmware.VMInstanceHybridIdentityMetadataClientGetOptions) (resp azfake.Responder[armconnectedvmware.VMInstanceHybridIdentityMetadataClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VMInstanceHybridIdentityMetadataClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceURI string, options *armconnectedvmware.VMInstanceHybridIdentityMetadataClientListOptions) (resp azfake.PagerResponder[armconnectedvmware.VMInstanceHybridIdentityMetadataClientListResponse])
}

// NewVMInstanceHybridIdentityMetadataServerTransport creates a new instance of VMInstanceHybridIdentityMetadataServerTransport with the provided implementation.
// The returned VMInstanceHybridIdentityMetadataServerTransport instance is connected to an instance of armconnectedvmware.VMInstanceHybridIdentityMetadataClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVMInstanceHybridIdentityMetadataServerTransport(srv *VMInstanceHybridIdentityMetadataServer) *VMInstanceHybridIdentityMetadataServerTransport {
	return &VMInstanceHybridIdentityMetadataServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armconnectedvmware.VMInstanceHybridIdentityMetadataClientListResponse]](),
	}
}

// VMInstanceHybridIdentityMetadataServerTransport connects instances of armconnectedvmware.VMInstanceHybridIdentityMetadataClient to instances of VMInstanceHybridIdentityMetadataServer.
// Don't use this type directly, use NewVMInstanceHybridIdentityMetadataServerTransport instead.
type VMInstanceHybridIdentityMetadataServerTransport struct {
	srv          *VMInstanceHybridIdentityMetadataServer
	newListPager *tracker[azfake.PagerResponder[armconnectedvmware.VMInstanceHybridIdentityMetadataClientListResponse]]
}

// Do implements the policy.Transporter interface for VMInstanceHybridIdentityMetadataServerTransport.
func (v *VMInstanceHybridIdentityMetadataServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VMInstanceHybridIdentityMetadataClient.Get":
		resp, err = v.dispatchGet(req)
	case "VMInstanceHybridIdentityMetadataClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VMInstanceHybridIdentityMetadataServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceURIParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VMInstanceHybridIdentityMetadata, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VMInstanceHybridIdentityMetadataServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceUri>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceURIParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceUri")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(resourceURIParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armconnectedvmware.VMInstanceHybridIdentityMetadataClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}
