//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datalake-store/armdatalakestore"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// VirtualNetworkRulesServer is a fake server for instances of the armdatalakestore.VirtualNetworkRulesClient type.
type VirtualNetworkRulesServer struct {
	// CreateOrUpdate is the fake for method VirtualNetworkRulesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string, parameters armdatalakestore.CreateOrUpdateVirtualNetworkRuleParameters, options *armdatalakestore.VirtualNetworkRulesClientCreateOrUpdateOptions) (resp azfake.Responder[armdatalakestore.VirtualNetworkRulesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method VirtualNetworkRulesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string, options *armdatalakestore.VirtualNetworkRulesClientDeleteOptions) (resp azfake.Responder[armdatalakestore.VirtualNetworkRulesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VirtualNetworkRulesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string, options *armdatalakestore.VirtualNetworkRulesClientGetOptions) (resp azfake.Responder[armdatalakestore.VirtualNetworkRulesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByAccountPager is the fake for method VirtualNetworkRulesClient.NewListByAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAccountPager func(resourceGroupName string, accountName string, options *armdatalakestore.VirtualNetworkRulesClientListByAccountOptions) (resp azfake.PagerResponder[armdatalakestore.VirtualNetworkRulesClientListByAccountResponse])

	// Update is the fake for method VirtualNetworkRulesClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, accountName string, virtualNetworkRuleName string, options *armdatalakestore.VirtualNetworkRulesClientUpdateOptions) (resp azfake.Responder[armdatalakestore.VirtualNetworkRulesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewVirtualNetworkRulesServerTransport creates a new instance of VirtualNetworkRulesServerTransport with the provided implementation.
// The returned VirtualNetworkRulesServerTransport instance is connected to an instance of armdatalakestore.VirtualNetworkRulesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualNetworkRulesServerTransport(srv *VirtualNetworkRulesServer) *VirtualNetworkRulesServerTransport {
	return &VirtualNetworkRulesServerTransport{
		srv:                   srv,
		newListByAccountPager: newTracker[azfake.PagerResponder[armdatalakestore.VirtualNetworkRulesClientListByAccountResponse]](),
	}
}

// VirtualNetworkRulesServerTransport connects instances of armdatalakestore.VirtualNetworkRulesClient to instances of VirtualNetworkRulesServer.
// Don't use this type directly, use NewVirtualNetworkRulesServerTransport instead.
type VirtualNetworkRulesServerTransport struct {
	srv                   *VirtualNetworkRulesServer
	newListByAccountPager *tracker[azfake.PagerResponder[armdatalakestore.VirtualNetworkRulesClientListByAccountResponse]]
}

// Do implements the policy.Transporter interface for VirtualNetworkRulesServerTransport.
func (v *VirtualNetworkRulesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualNetworkRulesClient.CreateOrUpdate":
		resp, err = v.dispatchCreateOrUpdate(req)
	case "VirtualNetworkRulesClient.Delete":
		resp, err = v.dispatchDelete(req)
	case "VirtualNetworkRulesClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualNetworkRulesClient.NewListByAccountPager":
		resp, err = v.dispatchNewListByAccountPager(req)
	case "VirtualNetworkRulesClient.Update":
		resp, err = v.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualNetworkRulesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkRules/(?P<virtualNetworkRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakestore.CreateOrUpdateVirtualNetworkRuleParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, accountNameParam, virtualNetworkRuleNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualNetworkRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualNetworkRulesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if v.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkRules/(?P<virtualNetworkRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, virtualNetworkRuleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualNetworkRulesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkRules/(?P<virtualNetworkRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, virtualNetworkRuleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualNetworkRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualNetworkRulesServerTransport) dispatchNewListByAccountPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListByAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAccountPager not implemented")}
	}
	newListByAccountPager := v.newListByAccountPager.get(req)
	if newListByAccountPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkRules`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListByAccountPager(resourceGroupNameParam, accountNameParam, nil)
		newListByAccountPager = &resp
		v.newListByAccountPager.add(req, newListByAccountPager)
		server.PagerResponderInjectNextLinks(newListByAccountPager, req, func(page *armdatalakestore.VirtualNetworkRulesClientListByAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListByAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAccountPager) {
		v.newListByAccountPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualNetworkRulesServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataLakeStore/accounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/virtualNetworkRules/(?P<virtualNetworkRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatalakestore.UpdateVirtualNetworkRuleParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkRuleName")])
	if err != nil {
		return nil, err
	}
	var options *armdatalakestore.VirtualNetworkRulesClientUpdateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armdatalakestore.VirtualNetworkRulesClientUpdateOptions{
			Parameters: &body,
		}
	}
	respr, errRespr := v.srv.Update(req.Context(), resourceGroupNameParam, accountNameParam, virtualNetworkRuleNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualNetworkRule, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
