//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdataprotection

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FetchSecondaryRecoveryPointsClient contains the methods for the FetchSecondaryRecoveryPoints group.
// Don't use this type directly, use NewFetchSecondaryRecoveryPointsClient() instead.
type FetchSecondaryRecoveryPointsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewFetchSecondaryRecoveryPointsClient creates a new instance of FetchSecondaryRecoveryPointsClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewFetchSecondaryRecoveryPointsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FetchSecondaryRecoveryPointsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &FetchSecondaryRecoveryPointsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListPager - Returns a list of Secondary Recovery Points for a DataSource in a vault, that can be used for Cross Region
// Restore.
//
// Generated from API version 2023-11-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - location - The name of the Azure region.
//   - parameters - Request body for operation
//   - options - FetchSecondaryRecoveryPointsClientListOptions contains the optional parameters for the FetchSecondaryRecoveryPointsClient.NewListPager
//     method.
func (client *FetchSecondaryRecoveryPointsClient) NewListPager(resourceGroupName string, location string, parameters FetchSecondaryRPsRequestParameters, options *FetchSecondaryRecoveryPointsClientListOptions) *runtime.Pager[FetchSecondaryRecoveryPointsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[FetchSecondaryRecoveryPointsClientListResponse]{
		More: func(page FetchSecondaryRecoveryPointsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FetchSecondaryRecoveryPointsClientListResponse) (FetchSecondaryRecoveryPointsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "FetchSecondaryRecoveryPointsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, location, parameters, options)
			}, nil)
			if err != nil {
				return FetchSecondaryRecoveryPointsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *FetchSecondaryRecoveryPointsClient) listCreateRequest(ctx context.Context, resourceGroupName string, location string, parameters FetchSecondaryRPsRequestParameters, options *FetchSecondaryRecoveryPointsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchSecondaryRecoveryPoints"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *FetchSecondaryRecoveryPointsClient) listHandleResponse(resp *http.Response) (FetchSecondaryRecoveryPointsClientListResponse, error) {
	result := FetchSecondaryRecoveryPointsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AzureBackupRecoveryPointResourceList); err != nil {
		return FetchSecondaryRecoveryPointsClientListResponse{}, err
	}
	return result, nil
}
